/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.ResourceReferenceState;
import java.util.Objects;

public class TransportResourceReferenceStateType
implements ResourceReferenceState {
    private LockState lockState;
    private boolean enabled;
    private boolean present;

    public TransportResourceReferenceStateType() {
    }

    public TransportResourceReferenceStateType(LockState lockState, boolean enabled, boolean present) {
        this.lockState = lockState;
        this.enabled = enabled;
        this.present = present;
    }

    public TransportResourceReferenceStateType(ResourceReferenceState copy) {
        this.lockState = Objects.requireNonNull(copy, "resource reference state is required").getLockState();
        this.present = copy.isPresent();
        this.enabled = copy.isEnabled();
    }

    @Override
    public LockState getLockState() {
        return this.lockState;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    @Override
    public boolean isAbsent() {
        return !this.present;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setLockState(LockState lockState) {
        this.lockState = lockState;
    }

    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return true;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public void setAbsent(boolean absent) {
        this.present = !absent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.lockState == null ? 0 : this.lockState.hashCode());
        result = 31 * result + (this.present ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        TransportResourceReferenceStateType other = (TransportResourceReferenceStateType)obj;
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.lockState != other.lockState) {
            return false;
        }
        return this.present == other.present;
    }
}

