/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.ServiceResourceReference;
import de.governikus.csl.uom.res.ServiceResourceReferenceParameter;
import de.governikus.csl.uom.res.ServiceResourceReferenceState;
import de.governikus.csl.uom.types.Configuration;
import de.governikus.csl.uom.types.ConfigurationInfo;
import java.util.List;

public interface ServiceResource<I>
extends Resource,
ResourceState,
ServiceResourceReferenceState,
ServiceResourceReferenceParameter {
    public String getID();

    @Override
    public boolean isEnabled();

    @Override
    public boolean setEnabled(boolean var1);

    @Override
    public boolean isStarted();

    public void setManagerService(I var1);

    default public ServiceResourceReference getServiceReference() {
        return (ServiceResourceReference)this.getReference();
    }

    @Override
    default public ServiceResourceReferenceState getServiceState() {
        return this.getServiceReference().getServiceState();
    }

    default public void refresh(Object lock) throws CoreException {
    }

    default public <C extends Configuration<?>> boolean configure(Object lock, C configuration) {
        return false;
    }

    default public <C extends Configuration<?>> C getConfiguration() {
        return null;
    }

    @Override
    default public List<? extends ConfigurationInfo> getConfigurationInfo() {
        return this.getServiceReference().getConfigurationInfo();
    }

    @Override
    default public boolean isConfigurable() {
        return this.getServiceReference().isConfigurable();
    }

    @Override
    default public boolean isRefreshable() {
        return this.getServiceReference().isRefreshable();
    }

    public static final class Util {
        public static ServiceResourceReference createEmptyServiceResourceReference(final String resType) {
            RESOURCE.getResourceClass(resType);
            return new ServiceResourceReference(){

                @Override
                public String getName() {
                    return "";
                }

                @Override
                public ResourceType getType() {
                    return null;
                }

                @Override
                public ResourceComponentType getComponentType() {
                    return null;
                }

                @Override
                public ResourceAreaType getAreaType() {
                    return null;
                }

                @Override
                public String getResourceType() {
                    return resType;
                }

                @Override
                public ResourceReferenceState getState() {
                    return ResourceConstants.SIMPLE_SERVICE_RESOURCE_REFERENCE_STATE;
                }

                @Override
                public ResourceReference getOriginatorService() {
                    return null;
                }

                @Override
                public ServiceResourceReferenceState getServiceState() {
                    return null;
                }
            };
        }
    }
}

