/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceState;

public interface ResourceReferenceParameter {
    public static final String DEFAULT_ID = "";
    public static final Resource RESOURCE = new Resource(){

        @Override
        public String getName() {
            return null;
        }

        @Override
        public ResourceState getState() {
            return null;
        }

        @Override
        public ResourceReference getReference() {
            return null;
        }
    };
    public static final ResourceReferenceParameter CHECKER = new ResourceReferenceParameter(){

        @Override
        public String getName() {
            return "do no use me";
        }
    };

    public String getName();

    default public String getId() {
        String name = this.getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return DEFAULT_ID;
    }

    default public Class<? extends Resource> getResourceClass(Class<? extends Resource> expectedType, String type) {
        try {
            Class<?> typeClass = Class.forName(type, false, Thread.currentThread().getContextClassLoader());
            if (expectedType.isAssignableFrom(typeClass)) {
                return typeClass;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IllegalArgumentException("class '" + type + "' does not represent a class extending Resource");
    }

    default public Class<? extends Resource> getResourceClass(String type) {
        return this.getResourceClass(Resource.class, type);
    }

    default public String check(Class<? extends Resource> expectedType, String typeResource) {
        try {
            if (!expectedType.isAssignableFrom(Class.forName(typeResource, false, Thread.currentThread().getContextClassLoader()))) {
                throw new IllegalArgumentException("typeResource not a ServiceResource: " + typeResource);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return typeResource;
    }

    default public String check(String typeResource) {
        return this.check(Resource.class, typeResource);
    }
}

