/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceReferenceParameter;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceType;

public interface ResourceReference
extends ResourceReferenceParameter {
    public String getResourceType();

    public ResourceType getType();

    public ResourceComponentType getComponentType();

    public ResourceAreaType getAreaType();

    public ResourceReference getOriginatorService();

    public ResourceReferenceState getState();

    public static final class Util {
        private Util() {
        }

        public static ResourceReference createEmptyResourceReference(final String resType) {
            Resource.RESOURCE.getResourceClass(resType);
            return new ResourceReference(){

                @Override
                public String getName() {
                    return "";
                }

                @Override
                public ResourceType getType() {
                    return null;
                }

                @Override
                public ResourceComponentType getComponentType() {
                    return null;
                }

                @Override
                public ResourceAreaType getAreaType() {
                    return null;
                }

                @Override
                public String getResourceType() {
                    return resType;
                }

                @Override
                public ResourceReferenceState getState() {
                    return ResourceConstants.SIMPLE_RESOURCE_REFERENCE_STATE;
                }

                @Override
                public ResourceReference getOriginatorService() {
                    return null;
                }
            };
        }
    }
}

