/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.lock.LockState;
import de.governikus.csl.uom.res.AbstractKeyResourceReference;
import de.governikus.csl.uom.res.KeyFunction;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceState;
import de.governikus.csl.uom.res.ServiceResource;
import de.governikus.csl.uom.res.ServiceResourceReferenceState;
import de.governikus.csl.uom.res.TransportServiceResourceReferenceStateType;
import de.governikus.csl.uom.res.impl.ServiceResourceReferenceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ResourceConstants {
    public static final List<KeyFunctionSupportedAlgorithms> DEFAULT_SUPPORTED_ALGORTHMS_ALL;
    public static final List<KeyFunctionSupportedAlgorithms> DEFAULT_SUPPORTED_ALGORTHMS_RSA;
    public static final List<KeyFunctionSupportedAlgorithms> DEFAULT_SUPPORTED_ALGORTHMS_EC;
    public static final KeyFunctionSupportedAlgorithms DEFAULT_SUPPORTED_ALGORITHMS_RSA_DECRYPT;
    public static final KeyFunctionSupportedAlgorithms DEFAULT_SUPPORTED_ALGORITHMS_RSA_ENCRYPT;
    public static final KeyFunctionSupportedAlgorithms DEFAULT_SUPPORTED_ALGORITHMS_RSA_SIGN;
    public static final KeyFunctionSupportedAlgorithms DEFAULT_SUPPORTED_ALGORITHMS_RSA_AUTHENTICATE;
    public static final KeyFunctionSupportedAlgorithms DEFAULT_SUPPORTED_ALGORITHMS_EC_SIGN;
    public static final KeyFunctionSupportedAlgorithms DEFAULT_SUPPORTED_ALGORITHMS_EC_AUTHENTICATE;
    public static final ResourceState SIMPLE_RESOURCE_STATE;
    public static final ResourceReferenceState SIMPLE_RESOURCE_REFERENCE_STATE;
    public static final ServiceResourceReferenceState SIMPLE_SERVICE_RESOURCE_REFERENCE_STATE;
    public static final ResourceReference RESOURCE_REFERENCE_UNKNOWN;
    public static final ServiceResourceReferenceImpl ORIGINATOR_UNKONWN_SERVICE_REFERENCE;

    private ResourceConstants() {
    }

    static {
        List<String> supportedRSADecryptEncryptAlgorithms = Arrays.asList("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2009/xmlenc11#mgf1sha1", "http://www.w3.org/2009/xmlenc11#mgf1sha224", "http://www.w3.org/2009/xmlenc11#mgf1sha256", "http://www.w3.org/2009/xmlenc11#mgf1sha384", "http://www.w3.org/2009/xmlenc11#mgf1sha256");
        List<String> supportedRSASignatureAuthenticateAlgorithms = Arrays.asList("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha224", "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-224", "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-256", "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-384", "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-512", "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1");
        List<String> supportedECSignatureAuthenticateAlgorithms = Arrays.asList("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160-ansi", "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512-ansi", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224-ansi", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256-ansi", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384-ansi", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512-ansi", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512");
        ArrayList<String> supportedALLDecryptEncryptAlgorithms = new ArrayList<String>();
        supportedALLDecryptEncryptAlgorithms.addAll(supportedRSADecryptEncryptAlgorithms);
        ArrayList<String> supportedALLSignatureAuthenticateAlgorithms = new ArrayList<String>();
        supportedALLSignatureAuthenticateAlgorithms.addAll(supportedRSASignatureAuthenticateAlgorithms);
        supportedALLSignatureAuthenticateAlgorithms.addAll(supportedECSignatureAuthenticateAlgorithms);
        KeyFunctionSupportedAlgorithms allDecryptKeyFunctionSupportedAlgorithms = new KeyFunctionSupportedAlgorithms(KeyFunction.DECRYPT, supportedALLDecryptEncryptAlgorithms);
        KeyFunctionSupportedAlgorithms allEncryptKeyFunctionSupportedAlgorithms = new KeyFunctionSupportedAlgorithms(KeyFunction.ENCRYPT, supportedALLSignatureAuthenticateAlgorithms);
        KeyFunctionSupportedAlgorithms allSignKeyFunctionSupportedAlgorithms = new KeyFunctionSupportedAlgorithms(KeyFunction.SIGN, supportedALLSignatureAuthenticateAlgorithms);
        KeyFunctionSupportedAlgorithms allAuthenticateKeyFunctionSupportedAlgorithms = new KeyFunctionSupportedAlgorithms(KeyFunction.AUTHENTICATE, supportedRSASignatureAuthenticateAlgorithms);
        DEFAULT_SUPPORTED_ALGORTHMS_ALL = AbstractKeyResourceReference.checkCloneSupportedAlgorithms(Arrays.asList(allDecryptKeyFunctionSupportedAlgorithms, allEncryptKeyFunctionSupportedAlgorithms, allSignKeyFunctionSupportedAlgorithms, allAuthenticateKeyFunctionSupportedAlgorithms));
        DEFAULT_SUPPORTED_ALGORITHMS_RSA_DECRYPT = new KeyFunctionSupportedAlgorithms(KeyFunction.DECRYPT, supportedRSADecryptEncryptAlgorithms);
        DEFAULT_SUPPORTED_ALGORITHMS_RSA_ENCRYPT = new KeyFunctionSupportedAlgorithms(KeyFunction.ENCRYPT, supportedRSADecryptEncryptAlgorithms);
        DEFAULT_SUPPORTED_ALGORITHMS_RSA_SIGN = new KeyFunctionSupportedAlgorithms(KeyFunction.SIGN, supportedRSASignatureAuthenticateAlgorithms);
        DEFAULT_SUPPORTED_ALGORITHMS_RSA_AUTHENTICATE = new KeyFunctionSupportedAlgorithms(KeyFunction.AUTHENTICATE, supportedRSASignatureAuthenticateAlgorithms);
        DEFAULT_SUPPORTED_ALGORTHMS_RSA = AbstractKeyResourceReference.checkCloneSupportedAlgorithms(Arrays.asList(DEFAULT_SUPPORTED_ALGORITHMS_RSA_DECRYPT, DEFAULT_SUPPORTED_ALGORITHMS_RSA_ENCRYPT, DEFAULT_SUPPORTED_ALGORITHMS_RSA_SIGN, DEFAULT_SUPPORTED_ALGORITHMS_RSA_AUTHENTICATE));
        DEFAULT_SUPPORTED_ALGORITHMS_EC_SIGN = new KeyFunctionSupportedAlgorithms(KeyFunction.SIGN, supportedECSignatureAuthenticateAlgorithms);
        DEFAULT_SUPPORTED_ALGORITHMS_EC_AUTHENTICATE = new KeyFunctionSupportedAlgorithms(KeyFunction.AUTHENTICATE, supportedECSignatureAuthenticateAlgorithms);
        DEFAULT_SUPPORTED_ALGORTHMS_EC = AbstractKeyResourceReference.checkCloneSupportedAlgorithms(Arrays.asList(DEFAULT_SUPPORTED_ALGORITHMS_EC_SIGN, DEFAULT_SUPPORTED_ALGORITHMS_EC_AUTHENTICATE));
        SIMPLE_RESOURCE_STATE = new ResourceState(){

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public boolean isAbsent() {
                return false;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public boolean setEnabled(boolean enabled) {
                return true;
            }

            @Override
            public void setLockState(LockState lockState) {
            }

            @Override
            public LockState getLockState() {
                return LockState.NONE;
            }
        };
        SIMPLE_RESOURCE_REFERENCE_STATE = new ResourceReferenceState(){

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public boolean isAbsent() {
                return false;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public LockState getLockState() {
                return LockState.EXCLUSIVE;
            }
        };
        SIMPLE_SERVICE_RESOURCE_REFERENCE_STATE = new ServiceResourceReferenceState(){

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public boolean isAbsent() {
                return false;
            }

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public LockState getLockState() {
                return LockState.NONE;
            }

            @Override
            public boolean isStarted() {
                return true;
            }
        };
        RESOURCE_REFERENCE_UNKNOWN = null;
        ORIGINATOR_UNKONWN_SERVICE_REFERENCE = new ServiceResourceReferenceImpl("unknown", ResourceComponentType.SERVICE, ResourceAreaType.LOCAL, ServiceResource.class.getName(), new TransportServiceResourceReferenceStateType());
    }
}

