/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.KeyFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="KeyFunctionSupportedAlgorithms", propOrder={"keyFunction", "supportedAlgorithms"})
public class KeyFunctionSupportedAlgorithms {
    private KeyFunction keyFunction;
    private List<String> supportedAlgorithms;

    public KeyFunctionSupportedAlgorithms() {
    }

    public KeyFunctionSupportedAlgorithms(KeyFunction keyFunction, String ... supportedAlgorithms) {
        this(keyFunction, supportedAlgorithms == null || supportedAlgorithms.length == 0 ? null : Arrays.asList(supportedAlgorithms));
    }

    public KeyFunctionSupportedAlgorithms(KeyFunction keyFunction, List<String> supportedAlgorithms) {
        if (keyFunction == null) {
            throw new IllegalArgumentException("KeyFunction is required");
        }
        if (supportedAlgorithms == null || supportedAlgorithms.isEmpty()) {
            throw new IllegalArgumentException("at least one algorithm must be supported");
        }
        ArrayList<String> tmp = new ArrayList<String>(supportedAlgorithms);
        while (tmp.contains(null)) {
            tmp.remove(null);
        }
        while (tmp.contains("")) {
            tmp.remove("");
        }
        if (tmp.isEmpty()) {
            throw new IllegalArgumentException("cleaned algorithms (null and empty algorithm names are not usable) are empty, at least one algorithm is required");
        }
        this.keyFunction = keyFunction;
        this.supportedAlgorithms = Collections.unmodifiableList(tmp);
    }

    public KeyFunction getKeyFunction() {
        return this.keyFunction;
    }

    public void setKeyFunction(KeyFunction keyFunction) {
        this.keyFunction = keyFunction;
    }

    public List<String> getSupportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    public void setSupportedAlgorithms(List<String> supportedAlgorithms) {
        this.supportedAlgorithms = supportedAlgorithms;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyFunction == null ? 0 : this.keyFunction.hashCode());
        result = 31 * result + (this.supportedAlgorithms == null ? 0 : this.supportedAlgorithms.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        KeyFunctionSupportedAlgorithms other = (KeyFunctionSupportedAlgorithms)obj;
        if (this.keyFunction != other.keyFunction) {
            return false;
        }
        return !(this.supportedAlgorithms == null ? other.supportedAlgorithms != null : !this.supportedAlgorithms.equals(other.supportedAlgorithms));
    }
}

