/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.impl.ServiceResourceReferenceImpl;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractResourceReference", propOrder={"name", "type", "componentType", "areaType", "state", "originatorService"})
public abstract class AbstractResourceReference
implements ResourceReference {
    private ResourceAreaType areaType;
    private ResourceComponentType componentType;
    private String name;
    private String id;
    protected transient ServiceResourceReferenceImpl originatorService;
    private String resourceType;
    protected ResourceReferenceState state;
    private ResourceType type;

    public static boolean equals(AbstractResourceReference one, AbstractResourceReference other) {
        if (one.name == null ? other.name != null : !one.name.equals(other.name)) {
            return false;
        }
        if (one.type == null ? other.type != null : one.type != other.type) {
            return false;
        }
        if (one.areaType == null ? other.areaType != null : one.areaType != other.areaType) {
            return false;
        }
        return !(one.componentType == null ? other.componentType != null : one.componentType != other.componentType);
    }

    public static boolean equals(Object one, Object other) {
        if (AbstractResourceReference.class.isInstance(one) && AbstractResourceReference.class.isInstance(other)) {
            return AbstractResourceReference.equals((AbstractResourceReference)AbstractResourceReference.class.cast(one), (AbstractResourceReference)AbstractResourceReference.class.cast(other));
        }
        return false;
    }

    protected AbstractResourceReference() {
    }

    public AbstractResourceReference(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeResource) {
        this(name, resourceType, resourceComponentType, resourceAreaType, typeResource, ResourceConstants.SIMPLE_RESOURCE_REFERENCE_STATE);
    }

    public AbstractResourceReference(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeResource, ResourceReferenceState resourceReferenceState) {
        this(name, resourceType, resourceComponentType, resourceAreaType, typeResource, resourceReferenceState, ResourceConstants.ORIGINATOR_UNKONWN_SERVICE_REFERENCE);
    }

    public AbstractResourceReference(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeResource, ResourceReferenceState resourceReferenceState, ServiceResourceReferenceImpl originatorService) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name can not be null or empty String");
        }
        if (resourceType == null) {
            throw new IllegalArgumentException("resource type not permitted as null");
        }
        if (resourceComponentType == null) {
            throw new IllegalArgumentException("resource component type not permitted as null");
        }
        if (resourceAreaType == null) {
            throw new IllegalArgumentException("resource area type not permitted as null");
        }
        if (typeResource == null) {
            throw new IllegalArgumentException("type of resource not permitted as null");
        }
        if (resourceReferenceState == null) {
            throw new IllegalArgumentException("resource state not permitted as null");
        }
        this.name = name;
        this.type = resourceType;
        this.componentType = resourceComponentType;
        this.areaType = resourceAreaType;
        this.resourceType = typeResource;
        this.state = resourceReferenceState;
        this.originatorService = originatorService;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        return AbstractResourceReference.equals(this, (AbstractResourceReference)obj);
    }

    @Override
    public final ResourceAreaType getAreaType() {
        return this.areaType;
    }

    @Override
    public final ResourceComponentType getComponentType() {
        return this.componentType;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final ResourceReference getOriginatorService() {
        return this.originatorService;
    }

    public final ResourceReference getOriginatorServiceReference() {
        return this.originatorService;
    }

    public final ResourceAreaType getResourceAreaType() {
        return this.areaType;
    }

    public final ResourceComponentType getResourceComponentType() {
        return this.componentType;
    }

    public final ResourceReferenceState getResourceReferenceState() {
        return this.state;
    }

    @Override
    public final String getResourceType() {
        return this.resourceType;
    }

    @Override
    public final ResourceReferenceState getState() {
        return this.state;
    }

    @Override
    public final ResourceType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.areaType == null ? 0 : this.areaType.hashCode());
        result = 31 * result + (this.componentType == null ? 0 : this.componentType.hashCode());
        return result;
    }

    public final AbstractResourceReference setName(String name) {
        if (this.name == null && name != null) {
            this.name = name;
        }
        return this;
    }

    public final AbstractResourceReference setOriginatorService(ServiceResourceReferenceImpl originatorService) {
        if (this.originatorService == null && originatorService != null) {
            this.originatorService = originatorService;
        }
        return this;
    }

    public final AbstractResourceReference setResourceAreaType(ResourceAreaType resourceAreaType) {
        if (this.areaType == null && resourceAreaType != null) {
            this.areaType = resourceAreaType;
        }
        return this;
    }

    public final AbstractResourceReference setResourceComponentType(ResourceComponentType resourceComponentType) {
        if (this.componentType == null && resourceComponentType != null) {
            this.componentType = resourceComponentType;
        }
        return this;
    }

    public final AbstractResourceReference setResourceReferenceState(ResourceReferenceState resourceReferenceState) {
        if (this.state == null && resourceReferenceState != null) {
            this.state = resourceReferenceState;
        }
        return this;
    }

    public final AbstractResourceReference setResourceType(String resourceType) {
        if (this.resourceType == null && resourceType != null) {
            this.resourceType = resourceType;
        }
        return this;
    }

    public final AbstractResourceReference setType(ResourceType type) {
        if (this.type == null && type != null) {
            this.type = type;
        }
        return this;
    }

    @Override
    public final String getId() {
        if (this.id != null && !this.id.isEmpty()) {
            return this.id;
        }
        return ResourceReference.super.getId();
    }

    public final void setId(String id) {
        if (this.id != null && !this.id.isEmpty()) {
            return;
        }
        this.id = id;
    }
}

