/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.Resource;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceReference;
import de.governikus.csl.uom.res.ResourceState;

public abstract class AbstractResource
implements Resource {
    protected final ResourceReference resourceReference;
    protected final ResourceState resourceState;

    public AbstractResource() {
        this.resourceReference = null;
        this.resourceState = ResourceConstants.SIMPLE_RESOURCE_STATE;
    }

    public AbstractResource(ResourceReference resourceReference) {
        this(resourceReference, null);
    }

    public AbstractResource(ResourceReference resourceReference, ResourceState resourceState) {
        if (resourceReference == null) {
            throw new IllegalArgumentException("resource reference can not be null");
        }
        this.resourceReference = resourceReference;
        this.resourceState = resourceState == null ? ResourceConstants.SIMPLE_RESOURCE_STATE : resourceState;
    }

    @Override
    public ResourceReference getReference() {
        return this.resourceReference;
    }

    @Override
    public final String getName() {
        return this.resourceReference == null ? null : this.resourceReference.getName();
    }

    @Override
    public final ResourceState getState() {
        return this.resourceState;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourceReference == null ? 0 : this.resourceReference.hashCode());
        result = 31 * result + this.resourceState.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!AbstractResource.class.isInstance(obj)) {
            return false;
        }
        AbstractResource other = (AbstractResource)obj;
        if (this.resourceReference == null ? other.resourceReference != null : !this.resourceReference.equals(other.resourceReference)) {
            return false;
        }
        return this.resourceState.equals(other.resourceState);
    }

    @Override
    public String getId() {
        return this.resourceReference.getId();
    }
}

