/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.AbstractResourceReference;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.KeyResourceReference;
import de.governikus.csl.uom.res.ResourceAreaType;
import de.governikus.csl.uom.res.ResourceComponentType;
import de.governikus.csl.uom.res.ResourceReferenceState;
import de.governikus.csl.uom.res.ResourceType;
import de.governikus.csl.uom.res.impl.ServiceResourceReferenceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractKeyResourceReference
extends AbstractResourceReference
implements KeyResourceReference {
    protected String algorithm;
    protected String format;
    private List<KeyFunctionSupportedAlgorithms> algorithms;

    public AbstractKeyResourceReference(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeKeyResource, ResourceReferenceState resourceReferenceState, ServiceResourceReferenceImpl originatorServiceReference, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, resourceType, resourceComponentType, resourceAreaType, typeKeyResource, resourceReferenceState, originatorServiceReference);
        this.algorithms = Objects.requireNonNull(AbstractKeyResourceReference.checkCloneSupportedAlgorithms(supportedAlgorithms));
    }

    protected AbstractKeyResourceReference() {
    }

    public AbstractKeyResourceReference(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeKeyResource, ResourceReferenceState resourceReferenceState, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        this(name, resourceType, resourceComponentType, resourceAreaType, typeKeyResource, resourceReferenceState, null, supportedAlgorithms);
    }

    public AbstractKeyResourceReference(String name, ResourceType resourceType, ResourceComponentType resourceComponentType, ResourceAreaType resourceAreaType, String typeKeyResource, List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        super(name, resourceType, resourceComponentType, resourceAreaType, typeKeyResource);
        this.algorithms = Objects.requireNonNull(AbstractKeyResourceReference.checkCloneSupportedAlgorithms(supportedAlgorithms));
    }

    public static List<KeyFunctionSupportedAlgorithms> checkCloneSupportedAlgorithms(List<KeyFunctionSupportedAlgorithms> supportedAlgorithms) {
        if (supportedAlgorithms == null || supportedAlgorithms.isEmpty() || supportedAlgorithms.contains(null)) {
            throw new IllegalArgumentException("algorithms can not be null or empty, no entry can be null");
        }
        return Collections.unmodifiableList(new ArrayList<KeyFunctionSupportedAlgorithms>(supportedAlgorithms));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.algorithms == null ? 0 : this.algorithms.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        AbstractKeyResourceReference other = (AbstractKeyResourceReference)obj;
        if (this.algorithms == null && other.algorithms == null) {
            return true;
        }
        if (this.algorithms == null && other.algorithms != null) {
            return false;
        }
        return this.algorithms.equals(other.algorithms);
    }

    public AbstractKeyResourceReference setAlgorithm(String algorithm) {
        this.algorithm = Objects.requireNonNull(algorithm);
        if (this.algorithm.isEmpty()) {
            this.algorithm = null;
        }
        return this;
    }

    public AbstractKeyResourceReference setFormat(String format) {
        this.format = Objects.requireNonNull(format);
        if (this.format.isEmpty()) {
            this.format = null;
        }
        return this;
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithm != null) {
            return this.algorithm;
        }
        return KeyResourceReference.super.getAlgorithm();
    }

    @Override
    public String getFormat() {
        if (this.format != null) {
            return this.format;
        }
        return KeyResourceReference.super.getFormat();
    }

    @Override
    public List<KeyFunctionSupportedAlgorithms> getKeyFunctionSupportedAlgorithms() {
        return this.algorithms;
    }

    public void setKeyFunctionSupportedAlgorithms(List<KeyFunctionSupportedAlgorithms> algorithms) {
        if (this.algorithms == null && algorithms != null) {
            this.algorithms = algorithms;
        }
    }
}

