/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.res;

import de.governikus.csl.uom.res.AbstractKeyResourceReference;
import de.governikus.csl.uom.res.AbstractResource;
import de.governikus.csl.uom.res.KeyFunctionSupportedAlgorithms;
import de.governikus.csl.uom.res.KeyResource;
import de.governikus.csl.uom.res.KeyResourceReference;
import de.governikus.csl.uom.res.ResourceConstants;
import de.governikus.csl.uom.res.ResourceFailedException;
import de.governikus.csl.uom.res.ResourceState;
import java.security.Key;
import java.util.List;

public abstract class AbstractKeyResource<K extends Key>
extends AbstractResource
implements KeyResource<K>,
Key {
    private final K key;
    private final boolean keyAccessible;
    private final String jceProviderName;
    private static final long serialVersionUID = 1L;

    public AbstractKeyResource() {
        this.key = null;
        this.keyAccessible = false;
        this.jceProviderName = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.jceProviderName == null ? 0 : this.jceProviderName.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.keyAccessible ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!AbstractKeyResource.class.isInstance(obj)) {
            return false;
        }
        AbstractKeyResource other = (AbstractKeyResource)obj;
        if (this.jceProviderName == null ? other.jceProviderName != null : !this.jceProviderName.equals(other.jceProviderName)) {
            return false;
        }
        if (this.key == null) {
            return other.key == null;
        }
        return this.key.equals(other.key) && this.keyAccessible == other.keyAccessible;
    }

    public AbstractKeyResource(KeyResourceReference resourceReference, K key, String jceProviderName) {
        this(resourceReference, null, key, false, jceProviderName);
    }

    public AbstractKeyResource(AbstractKeyResourceReference resourceReference, ResourceState resourceState, K key, String jceProviderName) {
        this(resourceReference, resourceState, key, false, jceProviderName);
    }

    public AbstractKeyResource(KeyResourceReference resourceReference, K key, boolean keyAccessible, String jceProviderName) {
        this(resourceReference, null, key, keyAccessible, jceProviderName);
    }

    public AbstractKeyResource(KeyResourceReference resourceReference, ResourceState resourceState, K key, boolean keyAccessible, String jceProviderName) {
        super(resourceReference, resourceState == null ? ResourceConstants.SIMPLE_RESOURCE_STATE : resourceState);
        if (key == null) {
            throw new IllegalArgumentException("key is required, can not be null");
        }
        this.key = key;
        this.keyAccessible = keyAccessible;
        this.jceProviderName = jceProviderName == null || jceProviderName.isEmpty() ? null : jceProviderName;
    }

    @Override
    public final K getKey() throws ResourceFailedException {
        if (this.key == null) {
            return null;
        }
        if (this.keyAccessible) {
            return this.key;
        }
        throw new ResourceFailedException("resource not accessible");
    }

    @Override
    public boolean isKeyAccessible() {
        return this.keyAccessible;
    }

    @Override
    public String getJCEProviderName() {
        return this.jceProviderName;
    }

    @Override
    public final String getAlgorithm() {
        return this.key == null ? null : this.key.getAlgorithm();
    }

    @Override
    public final String getFormat() {
        return this.key == null ? null : this.key.getFormat();
    }

    @Override
    public final byte[] getEncoded() {
        return this.key == null ? null : this.key.getEncoded();
    }

    @Override
    public List<KeyFunctionSupportedAlgorithms> getKeyFunctionSupportedAlgorithms() {
        return this.resourceReference == null ? null : ((KeyResourceReference)this.resourceReference).getKeyFunctionSupportedAlgorithms();
    }
}

