/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.jcebase.AlgorithmConstants;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XMLOIDJCEAlgorithmMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)XMLOIDJCEAlgorithmMapper.class.getName());
    private static XMLOIDJCEAlgorithmMapper singleton = null;
    private Map<String, String> mappingXMLJCE;
    private Map<String, String> mappingJCEXML;
    private Map<String, String> mappingOIDJCE;
    private Map<String, String> mappingJCEOID;
    private Map<String, String> mappingOIDOID;

    private XMLOIDJCEAlgorithmMapper() {
        this.setupMaps();
        this.registerDigest();
        this.registerSignature();
        this.registerKeyTransport();
    }

    private void setupMaps() {
        this.mappingXMLJCE = new HashMap<String, String>();
        this.mappingJCEXML = new HashMap<String, String>();
        this.mappingOIDJCE = new HashMap<String, String>();
        this.mappingJCEOID = new HashMap<String, String>();
        this.mappingOIDOID = new HashMap<String, String>();
    }

    private void registerDigest() {
        this.put("RIPEMD160", "http://www.w3.org/2001/04/xmlenc#ripemd160", AlgorithmConstants.ID_DIGEST_RIPEMD160);
        this.put("SHA1", "http://www.w3.org/2000/09/xmldsig#sha1", AlgorithmConstants.ID_DIGEST_SHA1);
        this.put("SHA224", "http://www.w3.org/2001/04/xmldsig-more#sha224", AlgorithmConstants.ID_DIGEST_SHA2_224);
        this.put("SHA256", "http://www.w3.org/2001/04/xmlenc#sha256", AlgorithmConstants.ID_DIGEST_SHA2_256);
        this.put("SHA384", "http://www.w3.org/2001/04/xmldsig-more#sha384", AlgorithmConstants.ID_DIGEST_SHA2_384);
        this.put("SHA512", "http://www.w3.org/2001/04/xmlenc#sha512", AlgorithmConstants.ID_DIGEST_SHA2_512);
        this.put("SHA3-224", "http://www.w3.org/2007/05/xmldsig-more#sha3-224", AlgorithmConstants.ID_DIGEST_SHA3_224);
        this.put("SHA3-256", "http://www.w3.org/2007/05/xmldsig-more#sha3-256", AlgorithmConstants.ID_DIGEST_SHA3_256);
        this.put("SHA3-384", "http://www.w3.org/2007/05/xmldsig-more#sha3-384", AlgorithmConstants.ID_DIGEST_SHA3_384);
        this.put("SHA3-512", "http://www.w3.org/2007/05/xmldsig-more#sha3-512", AlgorithmConstants.ID_DIGEST_SHA3_512);
    }

    private void registerSignature() {
        this.put("RIPEMD160withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", AlgorithmConstants.ID_SIGNATURE_RSA_RIPEMD160);
        this.put("RIPEMD160withECDSA", "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_RIPEMD160);
        this.put("RIPEMD160withCVC-ECDSA", "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", AlgorithmConstants.ID_SIGNATURE_ECDSA_RIPEMD160_CVC);
        this.put("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", AlgorithmConstants.ID_SIGNATURE_RSA_SHA1);
        this.put("SHA1withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", null);
        this.put("SHA1withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA1);
        this.put("SHA1withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA1_CVC);
        this.put("SHA1withDSA", "http://www.w3.org/2000/09/xmldsig#dsa-sha1-ansi", AlgorithmConstants.ID_SIGNATURE_DSA_SHA1);
        this.put("SHA1withCVC-DSA", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        this.put("SHA224withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha224", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_224);
        this.put("SHA224withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", null);
        this.put("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_256);
        this.put("SHA256withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", null);
        this.put("SHA384withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_384);
        this.put("SHA384withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", null);
        this.put("SHA512withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_512);
        this.put("SHA512withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", null);
        this.put("SHA224withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_224);
        this.put("SHA224withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_224_CVC, AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_224_CVC_TA);
        this.put("SHA256withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_256);
        this.put("SHA256withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_256_CVC, AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_256_CVC_TA);
        this.put("SHA384withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_384);
        this.put("SHA384withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_384_CVC, AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_384_CVC_TA);
        this.put("SHA512withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_512);
        this.put("SHA512withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_512_CVC, AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_512_CVC_TA);
        this.put("SHA256withDSA", "http://www.w3.org/2009/xmldsig11#dsa-sha256-ansi", AlgorithmConstants.ID_SIGNATURE_DSA_SHA2_256);
        this.put("SHA256withCVC-DSA", "http://www.w3.org/2009/xmldsig11#dsa-sha256", null);
        this.put("SHA3-224withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-224", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_224);
        this.put("SHA3-224withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", null);
        this.put("SHA3-256withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-256", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_256);
        this.put("SHA3-256withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", null);
        this.put("SHA3-384withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-384", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_384);
        this.put("SHA3-384withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", null);
        this.put("SHA3-512withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-512", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_512);
        this.put("SHA3-512withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", null);
        this.put("SHA3-224withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_224);
        this.put("SHA3-224withCVC-ECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_224_CVC);
        this.put("SHA3-256withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_256);
        this.put("SHA3-256withCVC-ECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_256_CVC);
        this.put("SHA3-384withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_384);
        this.put("SHA3-384withCVC-ECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_384_CVC);
        this.put("SHA3-512withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512-ansi", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_512);
        this.put("SHA3-512withCVC-ECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_512_CVC);
    }

    private void registerKeyTransport() {
        this.put("RSA/ECB/PKCS1Padding", "http://www.w3.org/2001/04/xmlenc#rsa-1_5", AlgorithmConstants.ID_KEYTRANSPORT_RSA_V1_5);
        this.put("RSA/NONE/OAEPWithSHA1AndMGF1Padding", "http://www.w3.org/2009/xmlenc11#mgf1sha1", null);
        this.put("RSA/NONE/OAEPWithSHA224AndMGF1Padding", "http://www.w3.org/2009/xmlenc11#mgf1sha224", null);
        this.put("RSA/NONE/OAEPWithSHA256AndMGF1Padding", "http://www.w3.org/2009/xmlenc11#mgf1sha256", null);
        this.put("RSA/NONE/OAEPWithSHA384AndMGF1Padding", "http://www.w3.org/2009/xmlenc11#mgf1sha384", null);
        this.put("RSA/NONE/OAEPWithSHA512AndMGF1Padding", "http://www.w3.org/2009/xmlenc11#mgf1sha512", null);
    }

    private void put(String jce, String algoId, String oid) {
        this.put(jce, algoId, oid, null);
    }

    private void put(String jce, String algoId, String oid, String alternativeOID) {
        if (algoId != null) {
            this.mappingXMLJCE.put(algoId, jce);
            this.mappingJCEXML.put(jce, algoId);
        }
        if (oid != null) {
            this.mappingOIDJCE.put(oid, jce);
            this.mappingJCEOID.put(jce, oid);
            if (alternativeOID != null) {
                this.mappingOIDOID.put(alternativeOID, oid);
            }
        }
    }

    public static synchronized XMLOIDJCEAlgorithmMapper getMapper() {
        if (singleton == null) {
            singleton = new XMLOIDJCEAlgorithmMapper();
        }
        return singleton;
    }

    public String mapXMLAlgorithmJCE(String xmlAlgorithmURI) {
        return this.mappingXMLJCE.get(xmlAlgorithmURI);
    }

    public String mapJCEAlgorithmXML(String jceAlgorithmName) {
        return this.mappingJCEXML.get(jceAlgorithmName);
    }

    public String mapOIDAlgorithmJCE(String algorithmOID) {
        String result = this.mappingOIDJCE.get(algorithmOID);
        if (result == null) {
            result = this.mappingOIDJCE.get(this.mappingOIDOID.get(algorithmOID));
        }
        return result;
    }

    public String mapJCEAlgorithmOID(String jceAlgorithmName) {
        return this.mappingJCEOID.get(jceAlgorithmName);
    }

    public String mapOIDAlgorithmXML(String algorithmOID) {
        String jce = this.mappingOIDJCE.get(algorithmOID);
        if (jce == null) {
            return null;
        }
        String result = this.mappingJCEXML.get(jce);
        if (result == null) {
            result = this.mapOIDAlgorithmXML(this.mappingOIDOID.get(algorithmOID));
        }
        return result;
    }

    public String mapXMLAlgorithmOID(String xmlAlgorithmURI) {
        String jce = this.mappingXMLJCE.get(xmlAlgorithmURI);
        if (jce == null) {
            return null;
        }
        return this.mappingJCEOID.get(jce);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier(String algorithmOID) {
        return this.getAlgorithmIdentifier(algorithmOID, (ASN1Encodable)DERNull.INSTANCE);
    }

    public AlgorithmIdentifier getAlgorithmIdentifier(String signatureAlgorithmOID, byte[] signatureAlgorithmParameters) {
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(signatureAlgorithmOID), signatureAlgorithmParameters == null || signatureAlgorithmParameters.length == 0 ? null : ASN1Sequence.getInstance((Object)signatureAlgorithmParameters));
    }

    public AlgorithmIdentifier getAlgorithmIdentifier(String signatureAlgorithmOID, ASN1Encodable encodable) {
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(signatureAlgorithmOID), encodable);
    }

    public String getURI(AlgorithmIdentifier signatureAlgorithmIdentifier) throws CoreException {
        ASN1ObjectIdentifier sigAlgOID = signatureAlgorithmIdentifier.getAlgorithm();
        ASN1Encodable sigAlgParams = signatureAlgorithmIdentifier.getParameters();
        if (sigAlgParams != null && !DERNull.INSTANCE.equals(sigAlgParams)) {
            if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)sigAlgOID)) {
                AlgorithmIdentifier digestAlgorithmIdentifier = new DefaultDigestAlgorithmIdentifierFinder().find(signatureAlgorithmIdentifier);
                return this.mappingJCEXML.get(this.mappingOIDJCE.get(digestAlgorithmIdentifier.getAlgorithm().getId()) + "with" + "RSAandMGF1");
            }
            throw new CoreException("not supported algorithm parameters: " + sigAlgParams);
        }
        String jce = this.mappingOIDJCE.get(signatureAlgorithmIdentifier.getAlgorithm().getId());
        if (jce == null) {
            jce = this.mappingOIDJCE.get(this.mappingOIDOID.get(signatureAlgorithmIdentifier.getAlgorithm().getId()));
        }
        return this.mappingJCEXML.get(jce);
    }

    public static String getCSLAlgorithmJCE(String algorithm) {
        return XMLOIDJCEAlgorithmMapper.getCSLAlgorithmJCE(algorithm, false);
    }

    public static String getCSLAlgorithmJCE(String algorithm, boolean digest) {
        XMLOIDJCEAlgorithmMapper mapper = XMLOIDJCEAlgorithmMapper.getMapper();
        String result = mapper.mapOIDAlgorithmJCE(algorithm);
        if (result == null || result.isEmpty()) {
            result = mapper.mapXMLAlgorithmJCE(algorithm);
        }
        if (result == null || result.isEmpty()) {
            LOGGER.debug("algorithm not mapped to JCE: {}", (Object)algorithm);
            result = algorithm;
        }
        if (digest && result != null && !result.contains("hashedWith") && result.contains("with")) {
            result = result.replace("with", "hashedWith");
        }
        return result;
    }

    public static String getCSLAlgorithmURI(String algorithm) {
        XMLOIDJCEAlgorithmMapper mapper = XMLOIDJCEAlgorithmMapper.getMapper();
        String result = mapper.mapOIDAlgorithmXML(algorithm);
        if ((result == null || result.isEmpty()) && ((result = mapper.mapJCEAlgorithmXML(algorithm)) == null || result.isEmpty()) && algorithm != null && algorithm.contains("hashedWith")) {
            result = mapper.mapJCEAlgorithmXML(algorithm.replace("hashedWith", "with"));
        }
        if (result == null || result.isEmpty()) {
            LOGGER.debug("algorithm not mapped to URI: {}", (Object)algorithm);
            result = algorithm;
        }
        return result;
    }

    public static String getCSLAlgorithmOID(String algorithm) {
        XMLOIDJCEAlgorithmMapper mapper = XMLOIDJCEAlgorithmMapper.getMapper();
        String result = mapper.mapXMLAlgorithmOID(algorithm);
        if ((result == null || result.isEmpty()) && ((result = mapper.mapOIDAlgorithmJCE(algorithm)) == null || result.isEmpty()) && algorithm != null && algorithm.contains("hashedWith")) {
            result = mapper.mapJCEAlgorithmXML(algorithm.replace("hashedWith", "with"));
        }
        if (result == null || result.isEmpty()) {
            LOGGER.debug("algorithm not mapped to OID: {}", (Object)algorithm);
            result = algorithm;
        }
        return result;
    }
}

