/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.jcebase.ASN1CertUtil;
import de.governikus.csl.uom.jcebase.AbstractX509CertificateFacade;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AttCertIssuer;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.Holder;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.ObjectDigestInfo;
import org.bouncycastle.asn1.x509.V2Form;

public class X509AttributeCertificateImpl
extends AbstractX509CertificateFacade<AttributeCertificate>
implements X509AttributeCertificateFacade {
    private final List<Attribute> attributes;
    private final Extensions extensions;
    private final X500Principal holderIssuer;
    private final BigInteger holderSerialNumber;
    private final X500Principal issuer;
    private final BigInteger issuerSerialNumber;
    private final Date notAfter;
    private final Date notBefore;
    private final ObjectDigestInfo objectDigestInfo;
    private final X500Principal subject;

    public X509AttributeCertificateImpl(AttributeCertificate attributeCertificate) throws IllegalArgumentException {
        super(attributeCertificate);
        int l;
        AttributeCertificateInfo acinfo = attributeCertificate.getAcinfo();
        AttCertIssuer attCertIssuer = acinfo.getIssuer();
        ASN1Encodable issuer = attCertIssuer.getIssuer();
        X500Principal tmpIssuer = null;
        if (issuer instanceof V2Form) {
            V2Form issuerV2Form = (V2Form)issuer;
            IssuerSerial issuerIssuerSerial = issuerV2Form.getBaseCertificateID();
            this.issuerSerialNumber = issuerIssuerSerial != null ? issuerIssuerSerial.getSerial().getValue() : null;
            tmpIssuer = ASN1CertUtil.getX500Principal(issuerV2Form.getIssuerName());
        } else if (issuer instanceof GeneralNames) {
            tmpIssuer = ASN1CertUtil.getX500Principal((GeneralNames)issuer);
            this.issuerSerialNumber = null;
        } else {
            throw new IllegalArgumentException("not supported issuer type: " + issuer.getClass().getName());
        }
        this.issuer = tmpIssuer;
        AttCertValidityPeriod attrCertValidityPeriod = acinfo.getAttrCertValidityPeriod();
        try {
            this.notAfter = attrCertValidityPeriod.getNotAfterTime().getDate();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("not after time not parseable: " + e.getMessage(), e);
        }
        try {
            this.notBefore = attrCertValidityPeriod.getNotBeforeTime().getDate();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("not before time not parseable: " + e.getMessage(), e);
        }
        Holder holder = acinfo.getHolder();
        this.subject = ASN1CertUtil.getX500Principal(holder.getEntityName());
        IssuerSerial holderIssuerSerial = holder.getBaseCertificateID();
        this.holderSerialNumber = holderIssuerSerial.getSerial().getValue();
        this.holderIssuer = ASN1CertUtil.getX500Principal(holderIssuerSerial.getIssuer());
        ASN1Sequence attributesSequence = attributeCertificate.getAcinfo().getAttributes();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (attributesSequence != null && (l = attributesSequence.size()) > 0) {
            for (int i = 0; i < l; ++i) {
                attributes.add(Attribute.getInstance((Object)attributesSequence.getObjectAt(i)));
            }
        }
        this.attributes = Collections.unmodifiableList(attributes);
        this.extensions = acinfo.getExtensions();
        this.objectDigestInfo = holder.getObjectDigestInfo();
    }

    @Override
    public boolean checkIssuerHolder(X509CertificateFacade issuerCertificate, X509CertificateFacade holderCertificate) throws GeneralSecurityException {
        return this.checkIssuer(issuerCertificate) && this.checkHolder(holderCertificate);
    }

    @Override
    public boolean checkHolder(X509CertificateFacade holderCertificate) throws GeneralSecurityException {
        if (holderCertificate == null) {
            return false;
        }
        boolean result = this.holderSerialNumber.equals(holderCertificate.getSerialNumber());
        if (!result) {
            return result;
        }
        if (this.subject != null) {
            result &= this.subject.equals(holderCertificate.getSubjectX500Principal());
        }
        if (this.holderIssuer != null) {
            result &= this.holderIssuer.equals(holderCertificate.getIssuerX500Principal());
        }
        if (this.objectDigestInfo != null) {
            DigestAlgorithm digestAlgorithm = AlgorithmService.getDigestForOID((String)this.objectDigestInfo.getDigestAlgorithm().getAlgorithm().getId());
            byte[] data = null;
            switch (this.getObjectDigestInfo().getDigestedObjectType().getValue().intValue()) {
                case 0: {
                    data = holderCertificate.getPublicKey().getEncoded();
                    break;
                }
                case 1: {
                    try {
                        data = holderCertificate.getEncoded();
                        break;
                    }
                    catch (CertificateEncodingException e) {
                        throw new CertificateEncodingException("bytes of holder certificate can not be encoded: " + e.getMessage(), e);
                    }
                }
            }
            if (data != null) {
                byte[] digest;
                if (digestAlgorithm == null) {
                    throw new CertificateEncodingException("digest algorithm not found");
                }
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(digestAlgorithm.getJCAName(), "BC");
                    digest = messageDigest.digest(data);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CertificateEncodingException("MessageDigest creation failed (missing algorithm): " + e.getMessage(), e);
                }
                catch (NoSuchProviderException e) {
                    throw new CertificateEncodingException("MessageDigest creation failed (missing provider): " + e.getMessage(), e);
                }
                return result &= Arrays.equals(digest, this.objectDigestInfo.getObjectDigest().getBytes());
            }
        }
        return result;
    }

    @Override
    public boolean checkIssuer(X509CertificateFacade issuerCertificate) throws GeneralSecurityException {
        if (issuerCertificate == null) {
            return false;
        }
        boolean result = this.issuer.equals(issuerCertificate.getSubjectX500Principal());
        if (this.issuerSerialNumber != null) {
            result &= this.issuerSerialNumber.equals(issuerCertificate.getSerialNumber());
        }
        return result;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.notAfter.getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.notAfter.getTime());
        }
        if (date.getTime() < this.notBefore.getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.notBefore.getTime());
        }
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getBasicConstraints() {
        return 0;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return ASN1CertUtil.getString(this.extensions.getCriticalExtensionOIDs());
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return ((AttributeCertificate)this.certificate).getEncoded();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e);
        }
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        try {
            Extension ext = this.extensions.getExtension(new ASN1ObjectIdentifier(oid));
            if (ext != null) {
                return ext.getExtnValue().getEncoded();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Principal getHolderIssuerDN() {
        return this.holderIssuer;
    }

    @Override
    public X500Principal getHolderIssuerX500Principal() {
        return this.holderIssuer;
    }

    @Override
    public BigInteger getHolderSerialNumber() {
        return this.holderSerialNumber;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuer;
    }

    @Override
    public BigInteger getIssuerSerialNumber() {
        return this.issuerSerialNumber;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return ASN1CertUtil.getUniquedID(((AttributeCertificate)this.certificate).getAcinfo().getIssuerUniqueID());
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.issuer;
    }

    @Override
    public boolean[] getKeyUsage() {
        return new boolean[0];
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        return ASN1CertUtil.getString(this.extensions.getNonCriticalExtensionOIDs());
    }

    @Override
    public Date getNotAfter() {
        return this.notAfter;
    }

    @Override
    public Date getNotBefore() {
        return this.notBefore;
    }

    @Override
    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return ((AttributeCertificate)this.certificate).getAcinfo().getSerialNumber().getValue();
    }

    @Override
    public Principal getSubjectDN() {
        return this.subject;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return new boolean[0];
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.subject;
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return ((AttributeCertificate)this.certificate).getAcinfo().getEncoded();
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e);
        }
    }

    @Override
    public int getVersion() {
        return ((AttributeCertificate)this.certificate).getAcinfo().getVersion().getValue().intValue();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    @Override
    public byte[] getSigAlgParams() {
        try {
            return ((AttributeCertificate)this.certificate).getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public byte[] getSignature() {
        return ((AttributeCertificate)this.certificate).getSignatureValue().getBytes();
    }

    @Override
    public final String getSigAlgOID() {
        return ((AttributeCertificate)this.certificate).getSignatureAlgorithm().getAlgorithm().getId();
    }
}

