/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;

public final class JceInstanceHelper {
    public static AlgorithmParameters getAlgorithmParameters(String algorithm) throws NoSuchAlgorithmException {
        return AlgorithmParameters.getInstance(algorithm);
    }

    public static AlgorithmParameters getAlgorithmParameters(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return AlgorithmParameters.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getAlgorithmParameters(algorithm);
    }

    public static AlgorithmParameters getAlgorithmParameters(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return AlgorithmParameters.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getAlgorithmParameters(algorithm);
    }

    public static Cipher getCipher(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(transformation);
    }

    public static Cipher getCipher(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return Cipher.getInstance(transformation, provider);
        }
        return JceInstanceHelper.getCipher(transformation);
    }

    public static Cipher getCipher(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return Cipher.getInstance(transformation, provider);
        }
        return JceInstanceHelper.getCipher(transformation);
    }

    public static KeyAgreement getKeyAgreement(String transformation) throws NoSuchAlgorithmException {
        return KeyAgreement.getInstance(transformation);
    }

    public static KeyAgreement getKeyAgreement(String transformation, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyAgreement.getInstance(transformation, provider);
        }
        return JceInstanceHelper.getKeyAgreement(transformation);
    }

    public static KeyAgreement getKeyAgreement(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return JceInstanceHelper.getKeyAgreement(transformation, provider);
        }
        return JceInstanceHelper.getKeyAgreement(transformation);
    }

    public static KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm);
    }

    public static KeyFactory getKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyFactory.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getKeyFactory(algorithm);
    }

    public static KeyFactory getKeyFactory(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyFactory.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getKeyFactory(algorithm);
    }

    public static KeyGenerator getKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyGenerator.getInstance(algorithm);
    }

    public static KeyGenerator getKeyGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyGenerator.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getKeyGenerator(algorithm);
    }

    public static KeyGenerator getKeyGenerator(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyGenerator.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getKeyGenerator(algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyPairGenerator.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getKeyPairGenerator(algorithm);
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyPairGenerator.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getKeyPairGenerator(algorithm);
    }

    public static KeyStore getKeyStore(String type) throws KeyStoreException {
        return KeyStore.getInstance(type);
    }

    public static KeyStore getKeyStore(String type, boolean initializeImmediately) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return JceInstanceHelper.initializeKeyStore(JceInstanceHelper.getKeyStore(type), initializeImmediately);
    }

    public static KeyStore getKeyStore(String type, Provider provider) throws KeyStoreException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyStore.getInstance(type, provider);
        }
        return JceInstanceHelper.getKeyStore(type);
    }

    public static KeyStore getKeyStore(String type, Provider provider, boolean initializeImmediately) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        return JceInstanceHelper.initializeKeyStore(JceInstanceHelper.getKeyStore(type, provider), initializeImmediately);
    }

    public static KeyStore getKeyStore(String type, String provider) throws NoSuchProviderException, KeyStoreException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return KeyStore.getInstance(type, provider);
        }
        return JceInstanceHelper.getKeyStore(type);
    }

    public static KeyStore getKeyStore(String type, String provider, boolean initializeImmediately) throws NoSuchProviderException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return JceInstanceHelper.initializeKeyStore(JceInstanceHelper.getKeyStore(type, provider), initializeImmediately);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return SecretKeyFactory.getInstance(algorithm);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return SecretKeyFactory.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getSecretKeyFactory(algorithm);
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return SecretKeyFactory.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getSecretKeyFactory(algorithm);
    }

    public static Signature getSignature(String algorithm) throws NoSuchAlgorithmException {
        return Signature.getInstance(algorithm);
    }

    public static Signature getSignature(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return Signature.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getSignature(algorithm);
    }

    public static Signature getSignature(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return Signature.getInstance(algorithm, provider);
        }
        return JceInstanceHelper.getSignature(algorithm);
    }

    public static Provider getProvider(String provider) {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return Security.getProvider(provider);
        }
        return null;
    }

    public static KeyStore initializeKeyStore(KeyStore keyStore, boolean initialized) throws NoSuchAlgorithmException, CertificateException, IOException {
        if (initialized && keyStore != null) {
            keyStore.load(null, null);
        }
        return keyStore;
    }

    public static KeyStore initializeKeyStore(KeyStore keyStore, InputStream stream, char[] password) throws NoSuchAlgorithmException, CertificateException, IOException {
        try (InputStream is = stream;){
            keyStore.load(is, password);
        }
        return keyStore;
    }

    public static boolean isProviderRegistered(Provider provider) {
        if (JceInstanceHelper.isProviderSpecified(provider)) {
            return JceInstanceHelper.isProviderRegistered(provider.getName());
        }
        return false;
    }

    public static boolean isProviderRegistered(String provider) {
        return JceInstanceHelper.getProvider(provider) != null;
    }

    public static boolean isProviderSpecified(Provider provider) {
        return provider != null;
    }

    public static boolean isProviderSpecified(String provider) {
        return provider != null && !provider.isEmpty();
    }

    private JceInstanceHelper() {
    }
}

