/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import de.governikus.csl.uom.impl.ProxyCreator;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface CertificatePublicKeyFacade
extends PublicKey {
    public Certificate getCertificate();

    public List<Certificate> getCertificateChain();

    public static class Impl
    implements CertificatePublicKeyFacade {
        private static final long serialVersionUID = 1L;
        private final List<Certificate> certificateChain;

        @Override
        public Certificate getCertificate() {
            return this.certificateChain.get(0);
        }

        @Override
        public List<Certificate> getCertificateChain() {
            return this.certificateChain;
        }

        private Impl(Certificate certificate) {
            this(Impl.createList(certificate));
        }

        private static List<Certificate> createList(Certificate certificate) {
            return Collections.singletonList(Objects.requireNonNull(certificate, "certificate can not be null"));
        }

        private Impl(List<Certificate> certificateChain) throws NullPointerException, IllegalArgumentException {
            ArrayList tmp = new ArrayList(Objects.requireNonNull(certificateChain));
            while (tmp.contains(null)) {
                tmp.remove(null);
            }
            if (tmp.isEmpty()) {
                throw new IllegalArgumentException("at least one certificate at chain is required");
            }
            this.certificateChain = Collections.unmodifiableList(tmp);
        }

        @Override
        public String getAlgorithm() {
            return this.getCertificate().getPublicKey().getAlgorithm();
        }

        @Override
        public String getFormat() {
            return this.getCertificate().getPublicKey().getFormat();
        }

        @Override
        public byte[] getEncoded() {
            return this.getCertificate().getPublicKey().getEncoded();
        }

        public static CertificatePublicKeyFacade createProxy(Certificate certificate) throws NullPointerException {
            return Impl.createProxy(Impl.createList(certificate));
        }

        public static CertificatePublicKeyFacade createProxy(List<Certificate> certificateChain) throws NullPointerException, IllegalArgumentException {
            Impl facade = new Impl(certificateChain);
            return ProxyCreator.newProxyInstance(CertificatePublicKeyFacade.class.getClassLoader(), new ProxyCreator.ProxyInvocationHandler<CertificatePublicKeyFacade>(CertificatePublicKeyFacade.class, Arrays.asList(facade.getCertificate().getPublicKey(), facade)));
        }
    }
}

