/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public interface CertificateBase {
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException;

    @Deprecated
    public Principal getIssuerDN();

    public boolean[] getIssuerUniqueID();

    public X500Principal getIssuerX500Principal();

    public Date getNotAfter();

    public Date getNotBefore();

    public BigInteger getSerialNumber();

    public String getSigAlgName();

    public String getSigAlgOID();

    public byte[] getSigAlgParams();

    public byte[] getSignature();

    public SignatureAlgorithm getSignatureAlgorithm() throws CertificateException;

    public int getVersion();

    public boolean[] getSubjectUniqueID();

    @Deprecated
    public Principal getSubjectDN();

    public X500Principal getSubjectX500Principal();

    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException;

    public byte[] getTBSCertificate() throws CertificateEncodingException;

    public boolean hasQCComplianceStatement();

    public boolean hasQCPPolicy();

    public boolean hasQCPSSCDPolicy();

    default public boolean hasQCPPolicyIdentifiers() {
        return this.hasQCPNPolicy() || this.hasQCPLPolicy() || this.hasQCPNQSCDPolicy() || this.hasQCPLQSCDPolicy() || this.hasQCPWPolicy();
    }

    public boolean hasQCPNPolicy();

    public boolean hasQCPLPolicy();

    public boolean hasQCPNQSCDPolicy();

    public boolean hasQCPLQSCDPolicy();

    public boolean hasQCPWPolicy();

    public boolean hasQCSSCDStatement();

    public EUQualifiedCertificateType getEUQualifiedCertificateType();

    public List<EUQualifiedCertificateType> getEUQualifiedCertificateTypes();

    public List<PolicyInformation> getCertificatePolicies();

    public List<QCStatement> getQCStatements();
}

