/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.uom.jcebase.ASN1CertUtil;
import de.governikus.csl.uom.jcebase.AbstractCertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateBaseFacade;
import de.governikus.csl.uom.validate.ValidityModel;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public abstract class AbstractX509CertificateFacade<WC>
extends AbstractCertificateFacade<WC>
implements X509CertificateBaseFacade<WC> {
    public static final String OID_QC_EXTENSION_QCCompliance = "0.4.0.1862.1.1";
    public static final String OID_QC_EXTENSION_SSCD = "0.4.0.1862.1.4";
    public static final String OID_QC_EXTENSION_CERTIFICATE_TYPE = "0.4.0.1862.1.6";
    public static final String OID_QC_EXTENSION_QCP_SSCD = "0.4.0.1456.1.1";
    public static final String OID_QC_EXTENSION_QCP = "0.4.0.1456.1.2";
    public static final String OID_QC_EXTENSION_QCP_N = "0.4.0.194112.1";
    public static final String OID_QC_EXTENSION_QCP_L = "0.4.0.194112.1.1";
    public static final String OID_QC_EXTENSION_QCP_N_QSCD = "0.4.0.194112.1.2";
    public static final String OID_QC_EXTENSION_QCP_L_QSCD = "0.4.0.194112.1.3";
    public static final String OID_QC_EXTENSION_QCP_W = "0.4.0.194112.1.4";
    public static final String OID_X509_EXTENSION_QC_STATEMENTS = "1.3.6.1.5.5.7.1.3";
    public static final String OID_X509_EXT_KEY_USAGE = "2.5.29.37";
    private List<QCStatement> qcStatements;
    private List<PolicyInformation> policyInformations;
    private ValidityModel validityModel;

    public AbstractX509CertificateFacade(WC certificate) throws IllegalArgumentException {
        super(certificate);
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature s = Signature.getInstance(this.getSignatureAlgorithm().getJCAName(), "BC");
        this.verify(s, key);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature s = Signature.getInstance(this.getSignatureAlgorithm().getJCAName(), sigProvider);
        this.verify(s, key);
    }

    private void verify(Signature s, PublicKey key) throws InvalidKeyException, SignatureException, CertificateEncodingException {
        s.initVerify(key);
        s.update(this.getTBSCertificate());
        boolean b = s.verify(this.getSignature());
        if (!b) {
            throw new SignatureException();
        }
    }

    @Override
    public final String getSigAlgName() {
        try {
            return this.getSignatureAlgorithm().getJCAName();
        }
        catch (CertificateException e) {
            return null;
        }
    }

    @Override
    public final SignatureAlgorithm getSignatureAlgorithm() throws CertificateException {
        return ASN1CertUtil.getSignatureAlgorithm(this);
    }

    @Override
    public List<QCStatement> getQCStatements() {
        if (this.qcStatements == null) {
            this.qcStatements = this.getQCStatementsInternal();
        }
        return this.qcStatements;
    }

    private List<QCStatement> getQCStatementsInternal() {
        byte[] qcStatementBytes = this.getExtensionValue(OID_X509_EXTENSION_QC_STATEMENTS);
        if (qcStatementBytes != null) {
            ASN1Sequence sequence = null;
            ArrayList<QCStatement> qcStatements = new ArrayList<QCStatement>();
            try {
                ASN1OctetString instance = ASN1OctetString.getInstance((Object)qcStatementBytes);
                byte[] octets = instance.getOctets();
                sequence = ASN1Sequence.getInstance((Object)octets);
            }
            catch (Exception e) {
                Extension ext = Extension.getInstance((Object)qcStatementBytes);
                sequence = ASN1Sequence.getInstance((Object)ext.getExtnValue().getOctets());
            }
            for (ASN1Encodable e : sequence) {
                QCStatement pi = QCStatement.getInstance((Object)e);
                qcStatements.add(pi);
            }
            return qcStatements;
        }
        return null;
    }

    @Override
    public List<PolicyInformation> getCertificatePolicies() {
        if (this.policyInformations == null) {
            this.policyInformations = this.getCertificatePoliciesInternal();
        }
        return this.policyInformations;
    }

    private List<PolicyInformation> getCertificatePoliciesInternal() {
        byte[] certificatePoliciesBytes = this.getExtensionValue("2.5.29.32");
        if (certificatePoliciesBytes == null) {
            certificatePoliciesBytes = this.getExtensionValue("2.5.29.3");
        }
        if (certificatePoliciesBytes != null) {
            ASN1Sequence sequence = null;
            ArrayList<PolicyInformation> policyInformations = new ArrayList<PolicyInformation>();
            try {
                ASN1OctetString instance = ASN1OctetString.getInstance((Object)certificatePoliciesBytes);
                byte[] octets = instance.getOctets();
                sequence = ASN1Sequence.getInstance((Object)octets);
            }
            catch (Exception e) {
                Extension ext = Extension.getInstance((Object)certificatePoliciesBytes);
                sequence = ASN1Sequence.getInstance((Object)ext.getExtnValue().getOctets());
            }
            for (ASN1Encodable e : sequence) {
                PolicyInformation pi = PolicyInformation.getInstance((Object)e);
                policyInformations.add(pi);
            }
            return policyInformations;
        }
        return null;
    }

    private boolean hasQCStatement(String oid) {
        List<QCStatement> qcs = this.getQCStatements();
        if (qcs != null) {
            for (QCStatement qc : qcs) {
                if (!qc.getStatementId().getId().equals(oid)) continue;
                return true;
            }
        }
        return false;
    }

    private QCStatement getQCStatement(String oid) {
        List<QCStatement> qcs = this.getQCStatements();
        if (qcs != null) {
            for (QCStatement qc : qcs) {
                if (!qc.getStatementId().getId().equals(oid)) continue;
                return qc;
            }
        }
        return null;
    }

    private boolean hasPolicyIdentifier(String oid) {
        List<PolicyInformation> lpi = this.getCertificatePolicies();
        if (lpi != null) {
            for (PolicyInformation pi : lpi) {
                if (!pi.getPolicyIdentifier().getId().equals(oid)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasQCComplianceStatement() {
        return this.hasQCStatement(OID_QC_EXTENSION_QCCompliance);
    }

    @Override
    public boolean hasQCSSCDStatement() {
        return this.hasQCStatement(OID_QC_EXTENSION_SSCD);
    }

    @Override
    public boolean hasQCPSSCDPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP_SSCD);
    }

    @Override
    public boolean hasQCPPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP);
    }

    @Override
    public boolean hasQCPLPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP_L);
    }

    @Override
    public boolean hasQCPLQSCDPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP_L_QSCD);
    }

    @Override
    public boolean hasQCPNPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP_N);
    }

    @Override
    public boolean hasQCPNQSCDPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP_N_QSCD);
    }

    @Override
    public boolean hasQCPWPolicy() {
        return this.hasPolicyIdentifier(OID_QC_EXTENSION_QCP_W);
    }

    @Override
    public EUQualifiedCertificateType getEUQualifiedCertificateType() {
        QCStatement qcStatement = this.getQCStatement(OID_QC_EXTENSION_CERTIFICATE_TYPE);
        if (qcStatement != null) {
            ASN1Encodable statementInfo = qcStatement.getStatementInfo();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)statementInfo);
            ASN1Encodable objectAt = seq.getObjectAt(0);
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)objectAt);
            String id = oid.getId();
            EUQualifiedCertificateType result = EUQualifiedCertificateType.getByOID(id);
            return result;
        }
        return null;
    }

    @Override
    public List<EUQualifiedCertificateType> getEUQualifiedCertificateTypes() {
        ArrayList<EUQualifiedCertificateType> result = new ArrayList<EUQualifiedCertificateType>();
        QCStatement qcStatement = this.getQCStatement(OID_QC_EXTENSION_CERTIFICATE_TYPE);
        if (qcStatement != null) {
            ASN1Encodable statementInfo = qcStatement.getStatementInfo();
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)statementInfo);
            seq.forEach(x -> {
                ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((Object)x);
                String id = oid.getId();
                EUQualifiedCertificateType t = EUQualifiedCertificateType.getByOID(id);
                result.add(t);
            });
        }
        return result;
    }

    @Override
    public ValidityModel getValidityModel() {
        if (this.validityModel == null) {
            this.validityModel = this.getValidityModelInternal();
        }
        return this.validityModel;
    }

    private ValidityModel getValidityModelInternal() {
        byte[] certificatePoliciesBytes = this.getExtensionValue("1.3.6.1.4.1.8301.3.5");
        if (certificatePoliciesBytes != null) {
            ASN1Sequence sequence = null;
            try {
                ASN1OctetString instance = ASN1OctetString.getInstance((Object)certificatePoliciesBytes);
                byte[] octets = instance.getOctets();
                sequence = ASN1Sequence.getInstance((Object)octets);
            }
            catch (Exception e) {
                Extension ext = Extension.getInstance((Object)certificatePoliciesBytes);
                sequence = ASN1Sequence.getInstance((Object)ext.getExtnValue().getOctets());
            }
            for (ASN1Encodable e : sequence) {
                ASN1ObjectIdentifier id = ASN1ObjectIdentifier.getInstance((Object)e);
                if (id.getId().equals("1.3.6.1.4.1.8301.3.5.1")) {
                    return ValidityModel.CHAIN;
                }
                if (!id.getId().equals("1.3.6.1.4.1.8301.3.5.2")) continue;
                return ValidityModel.SHELL;
            }
        }
        return null;
    }
}

