/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jcebase;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmImpl;
import de.governikus.csl.uom.core.AlgorithmServiceFacade;
import de.governikus.csl.uom.jcebase.CertificateBase;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public final class ASN1CertUtil {
    public static final String ID_RSASSA_PSS_PREFIX = "1.2.840.113549.1.1.10";
    public static final int ASN1_MIN_LENGTH_CERT = 5;
    public static final int ASN1_MAX_LENGTH_CERT = 8192;

    private ASN1CertUtil() {
    }

    public static SignatureAlgorithm getSignatureAlgorithm(Object object) throws CertificateException {
        if (object instanceof AttributeCertificate) {
            return ASN1CertUtil.getSignatureAlgorithm((AttributeCertificate)object);
        }
        if (object instanceof X509Certificate) {
            return ASN1CertUtil.getSignatureAlgorithm((X509Certificate)object);
        }
        if (object instanceof CertificateBase) {
            return ((CertificateBase)object).getSignatureAlgorithm();
        }
        throw new UnsupportedOperationException();
    }

    public static SignatureAlgorithm getSignatureAlgorithm(AlgorithmIdentifier signatureAlgorithmIdentifier) throws CertificateException {
        return ASN1CertUtil.getSignatureAlgorithm(signatureAlgorithmIdentifier, (AlgorithmManager)new AlgorithmServiceFacade());
    }

    public static SignatureAlgorithm getSignatureAlgorithm(AlgorithmIdentifier signatureAlgorithmIdentifier, AlgorithmManager algorithmManager) throws CertificateException {
        String sigAlgOID = ASN1CertUtil.getSigAlgOID(signatureAlgorithmIdentifier);
        List<SignatureAlgorithm> signatureAlgorithms = ASN1CertUtil.getSignatureAlgorithms(algorithmManager, sigAlgOID);
        SignatureAlgorithm signatureAlgorithm = signatureAlgorithms.get(0);
        ASN1Encodable sigAlgParams = signatureAlgorithmIdentifier.getParameters();
        if (sigAlgParams != null && !(sigAlgParams instanceof DERNull)) {
            signatureAlgorithm = ASN1CertUtil.getParameterizedSignatureAlgorithm(sigAlgOID, signatureAlgorithm, sigAlgParams);
        } else if (signatureAlgorithms.size() != 1) {
            throw new CertificateException("multiple signature algorithms found for OID: " + sigAlgOID);
        }
        return signatureAlgorithm;
    }

    private static SignatureAlgorithm getParameterizedSignatureAlgorithm(String sigAlgOID, SignatureAlgorithm signatureAlgorithm, ASN1Encodable sigAlgParams) throws CertificateException {
        if (signatureAlgorithm.getBaseAlgorithm().equals((Object)SignatureAlgorithmBase.RSA)) {
            if (!ID_RSASSA_PSS_PREFIX.equals(sigAlgOID)) {
                throw new CertificateException("parameters not supported for algorithm: " + sigAlgOID + "(" + signatureAlgorithm.getName() + ")");
            }
        } else {
            throw new CertificateException("parameters not supported for base algorithm: " + signatureAlgorithm.getBaseAlgorithm());
        }
        signatureAlgorithm = ASN1CertUtil.getRSAPSSSignatureAlgorithm(sigAlgParams);
        return signatureAlgorithm;
    }

    private static SignatureAlgorithm getRSAPSSSignatureAlgorithm(ASN1Encodable sigAlgParams) throws CertificateException {
        RSASSAPSSparams rsaParams = null;
        try {
            rsaParams = RSASSAPSSparams.getInstance((Object)sigAlgParams.toASN1Primitive().getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException("failed to parse RSSASSA PSS parameters");
        }
        DigestAlgorithm digestAlgorithm = AlgorithmService.getDigestForOID((String)rsaParams.getHashAlgorithm().getAlgorithm().getId());
        PaddingAlgorithm padding = AlgorithmService.getPaddingForOID((String)ID_RSASSA_PSS_PREFIX);
        SignatureAlgorithm signatureAlgorithm = AlgorithmService.getSignature((SignatureAlgorithmBase)SignatureAlgorithmBase.RSA, (DigestAlgorithm)digestAlgorithm, (PaddingAlgorithm)padding, null);
        return signatureAlgorithm;
    }

    private static List<SignatureAlgorithm> getSignatureAlgorithms(AlgorithmManager algorithmManager, String sigAlgOID) throws CertificateException {
        List<SignatureAlgorithm> signatureAlgorithms = algorithmManager.getSignatureAlgorithmsByOID(sigAlgOID);
        if (signatureAlgorithms.isEmpty()) {
            throw new CertificateException("no signature algorithm found for OID: " + sigAlgOID);
        }
        ArrayList<SignatureAlgorithm> tmpSignatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        for (SignatureAlgorithm signatureAlgorithm : signatureAlgorithms) {
            if (!(signatureAlgorithm instanceof SignatureAlgorithmImpl)) continue;
            tmpSignatureAlgorithms.add(signatureAlgorithm);
        }
        signatureAlgorithms = tmpSignatureAlgorithms;
        if (signatureAlgorithms.isEmpty()) {
            throw new CertificateException("no signature algorithm found for OID: " + sigAlgOID);
        }
        return signatureAlgorithms;
    }

    private static String getSigAlgOID(AlgorithmIdentifier signatureAlgorithmIdentifier) throws CertificateException {
        if (signatureAlgorithmIdentifier == null) {
            throw new CertificateException("signature algorithm identifier can not be null");
        }
        return signatureAlgorithmIdentifier.getAlgorithm().getId();
    }

    public static SignatureAlgorithm getSignatureAlgorithm(AttributeCertificate attributeCertificate) throws CertificateException {
        if (attributeCertificate == null) {
            throw new IllegalArgumentException("attribute certificate class can not be null");
        }
        return ASN1CertUtil.getSignatureAlgorithm(attributeCertificate.getSignatureAlgorithm());
    }

    public static SignatureAlgorithm getSignatureAlgorithm(AttributeCertificate attributeCertificate, AlgorithmManager algorithmManager) throws CertificateException {
        if (attributeCertificate == null) {
            throw new IllegalArgumentException("attribute certificate class can not be null");
        }
        return ASN1CertUtil.getSignatureAlgorithm(attributeCertificate.getSignatureAlgorithm(), algorithmManager);
    }

    public static SignatureAlgorithm getSignatureAlgorithm(X509Certificate certificate) throws CertificateException {
        return ASN1CertUtil.getSignatureAlgorithm(ASN1CertUtil.getSignatureAlgorithmIdentifier(certificate));
    }

    public static AlgorithmIdentifier getSignatureAlgorithmIdentifier(X509Certificate certificate) throws CertificateException {
        if (certificate == null) {
            throw new IllegalArgumentException("certificate can not be null");
        }
        byte[] sigAlgParams = certificate.getSigAlgParams();
        if (sigAlgParams == null || sigAlgParams.length == 0) {
            return new AlgorithmIdentifier(new ASN1ObjectIdentifier(certificate.getSigAlgOID()));
        }
        ASN1Primitive sigAlgPrimitive = null;
        try {
            sigAlgPrimitive = ASN1CertUtil.fromByteArray(sigAlgParams);
        }
        catch (IOException e) {
            throw new CertificateException("signature algorithm parameters not parsafound for OID: ");
        }
        return new AlgorithmIdentifier(new ASN1ObjectIdentifier(certificate.getSigAlgOID()), (ASN1Encodable)sigAlgPrimitive);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASN1Primitive fromByteArray(byte[] data) throws IOException {
        try (ASN1InputStream aIn = new ASN1InputStream(data);){
            ASN1Primitive aSN1Primitive = aIn.readObject();
            return aSN1Primitive;
        }
        catch (ClassCastException e) {
            throw new IOException("cannot recognise object in stream");
        }
    }

    public static Set<String> getString(ASN1ObjectIdentifier[] extensionOIDs) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (extensionOIDs != null) {
            for (ASN1ObjectIdentifier extensionOID : extensionOIDs) {
                if (extensionOID == null) continue;
                result.add(extensionOID.getId());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public static boolean[] getUniquedID(ASN1BitString uniqueID) {
        String uniqueIDString = uniqueID == null ? "" : uniqueID.getString();
        boolean[] result = new boolean[uniqueIDString.length()];
        for (int i = 0; i < uniqueIDString.length(); ++i) {
            result[i] = uniqueIDString.charAt(i) == '1';
        }
        return result;
    }

    public static InputStream getLimitedASN1InputStream(InputStream is) throws IOException {
        return ASN1CertUtil.getLimitedASN1InputStream(is, 8192);
    }

    public static InputStream getLimitedASN1InputStream(InputStream is, int asn1MaximumLength) throws IOException {
        return ASN1CertUtil.getLimitedASN1InputStream(is, 5, asn1MaximumLength);
    }

    public static InputStream getLimitedASN1InputStream(InputStream is, int asn1MinimumLength, int asn1MaximumLength) throws IOException {
        if (is == null) {
            return null;
        }
        if (asn1MinimumLength < 0) {
            throw new IllegalArgumentException("minimum length can not be negative");
        }
        if (asn1MaximumLength < 0) {
            throw new IllegalArgumentException("maximum length can not be negative");
        }
        if (asn1MinimumLength > asn1MaximumLength) {
            throw new IllegalArgumentException("");
        }
        PushbackInputStream pis = new PushbackInputStream(is, 20);
        byte[] streamFirstBytes = new byte[asn1MinimumLength];
        int r = pis.read(streamFirstBytes);
        if (r < asn1MinimumLength) {
            throw new IOException("ASN.1 length not accepted - minimum of bytes can not be read");
        }
        pis.unread(streamFirstBytes, 0, r);
        try (ByteArrayInputStream tmp = new ByteArrayInputStream(streamFirstBytes);){
            int tag = ((InputStream)tmp).read();
            if (tag == -1) {
                InputStream inputStream = null;
                return inputStream;
            }
            ASN1CertUtil.readTagNumber(tmp, tag);
            int l = ASN1CertUtil.readLength(tmp, asn1MaximumLength);
            if (l == -1) {
                throw new IOException("indifinite length encoding, ASN.1 length might be out of bounds");
            }
            if (l < asn1MinimumLength) {
                throw new IOException("ASN.1 length not accepted");
            }
        }
        return pis;
    }

    private static int readTagNumber(InputStream s, int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b = s.read();
            if ((b & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = s.read();
            }
            if (b < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    private static int readLength(InputStream s, int limit) throws IOException {
        int length = s.read();
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes: " + size);
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = s.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return length;
    }

    public static X500Principal getX500Principal(GeneralNames generalNames) {
        if (generalNames == null) {
            return null;
        }
        GeneralName[] names = generalNames.getNames();
        if (names == null) {
            throw new IllegalArgumentException("GeneralNames does not provide any names (null)");
        }
        if (names.length == 0) {
            throw new IllegalArgumentException("GeneralNames does not provide any names (empty)");
        }
        if (names.length > 1) {
            throw new IllegalArgumentException("GeneralNames provide more than one name (too many)");
        }
        GeneralName generalName = names[0];
        if (generalName == null) {
            throw new IllegalArgumentException("GeneralName is null");
        }
        ASN1TaggedObject asn1TaggedObject = (ASN1TaggedObject)generalName.toASN1Primitive();
        try {
            X500Name name = X500Name.getInstance((Object)asn1TaggedObject.getBaseObject());
            byte[] b = name.getEncoded();
            return new X500Principal(b);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

