/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.impl;

import de.governikus.csl.uom.util.ClassUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class ProxyCreator {
    public static <T> T newProxyInstance(ClassLoader loader, ProxyInvocationHandler<T> h) {
        return h.getTypeClass().cast(Proxy.newProxyInstance(loader, h.getInterfaces().toArray(new Class[0]), h));
    }

    public static class ProxyInvocationHandler<T>
    implements InvocationHandler {
        public static final Method OBJECT_METHOD_TO_STRING;
        private final Class<T> typeClass;
        private final List<Class<?>> interfaces;
        private final List<Object> objects;

        public ProxyInvocationHandler(Class<T> typeClass, Object object) {
            this(typeClass, Collections.singletonList(object));
        }

        public ProxyInvocationHandler(Class<T> typeClass, List<Object> objects) {
            this(typeClass, objects, null);
        }

        public ProxyInvocationHandler(Class<T> typeClass, List<Object> objects, Collection<Class<?>> additionalInterfaces) {
            if (typeClass == null) {
                throw new IllegalArgumentException();
            }
            if (!typeClass.isInterface()) {
                throw new IllegalArgumentException();
            }
            if (objects == null) {
                throw new IllegalArgumentException();
            }
            if (objects.isEmpty()) {
                throw new IllegalArgumentException();
            }
            if (objects.contains(null)) {
                throw new IllegalArgumentException();
            }
            LinkedHashSet tmp = new LinkedHashSet();
            for (int i = 0; i < objects.size(); ++i) {
                for (Class<? extends Object> interfaceClass : ClassUtils.findInterfaces(objects.get(i).getClass())) {
                    tmp.add(interfaceClass);
                }
            }
            if (additionalInterfaces != null) {
                tmp.addAll(additionalInterfaces);
            }
            this.typeClass = typeClass;
            this.interfaces = Collections.unmodifiableList(new ArrayList(tmp));
            this.objects = Collections.unmodifiableList(new ArrayList<Object>(objects));
        }

        public Class<T> getTypeClass() {
            return this.typeClass;
        }

        public List<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        public List<Object> getObjects() {
            return this.objects;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (OBJECT_METHOD_TO_STRING.equals(method)) {
                return super.toString() + "(" + this.objects.toString() + ")";
            }
            for (int i = 0; i < this.interfaces.size(); ++i) {
                try {
                    Class<?> interfaceClass = this.interfaces.get(i);
                    Method m = interfaceClass.getMethod(method.getName(), method.getParameterTypes());
                    if (m == null) continue;
                    for (int j = 0; j < this.objects.size(); ++j) {
                        Object object = this.objects.get(j);
                        if (!interfaceClass.isInstance(object)) continue;
                        return m.invoke(object, args);
                    }
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            Method tmp = null;
            try {
                tmp = Object.class.getMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                tmp = null;
            }
            OBJECT_METHOD_TO_STRING = tmp;
        }
    }
}

