/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.core;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmImpl;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class AlgorithmServiceFacade
implements AlgorithmManager {
    public static final String ID_RSASSA_PSS_OID = "1.2.840.113549.1.1.10";

    @Override
    public SignatureAlgorithm getSignatureAlgorithmByJCAName(String jcaName) {
        return AlgorithmService.getSignatureForJCAName((String)jcaName);
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithmByOID(String oid) {
        List signatureForOID = AlgorithmService.getSignatureForOID((String)oid);
        if (signatureForOID != null && !signatureForOID.isEmpty()) {
            return (SignatureAlgorithm)signatureForOID.get(0);
        }
        return null;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithmByURI(String url) {
        return AlgorithmService.getSignatureForURI((String)url);
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithmByJcaOidOrUrl(String jcaName, String oid, String url) {
        SignatureAlgorithm algorithm;
        if (jcaName != null && (algorithm = AlgorithmService.getSignatureForJCAName((String)jcaName)) != null) {
            return algorithm;
        }
        List algorithms = null;
        if (oid != null) {
            algorithms = AlgorithmService.getSignatureForOID((String)oid);
        }
        if (algorithms != null && algorithms.size() > 0) {
            return (SignatureAlgorithm)algorithms.get(0);
        }
        if (url != null) {
            return AlgorithmService.getSignatureForURI((String)url);
        }
        return null;
    }

    @Override
    public DigestAlgorithm getDigestAlgorithmByJCAName(String jcaName) {
        return AlgorithmService.getDigestForJCAName((String)jcaName);
    }

    @Override
    public DigestAlgorithm getDigestAlgorithmByOID(String oid) {
        return AlgorithmService.getDigestForOID((String)oid);
    }

    @Override
    public DigestAlgorithm getDigestAlgorithmByURL(String url) {
        return AlgorithmService.getDigestForURI((String)url);
    }

    @Override
    public DigestAlgorithm getDigestAlgorithmByJcaOidOrUrl(String jcaName, String odi, String url) {
        DigestAlgorithm algorithm = null;
        if (jcaName != null) {
            algorithm = AlgorithmService.getDigestForJCAName((String)jcaName);
        }
        if (algorithm == null && odi != null) {
            algorithm = AlgorithmService.getDigestForOID((String)odi);
        }
        if (algorithm == null && url != null) {
            algorithm = AlgorithmService.getDigestForURI((String)url);
        }
        return algorithm;
    }

    @Override
    public List<SignatureAlgorithm> getSignatureAlgorithmsByOID(String oid) {
        return AlgorithmService.getSignatureForOID((String)oid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SignatureAlgorithm getSignatureAlgorithm(AlgorithmIdentifier signatureAlgorithmIdentifier) throws CoreException {
        if (signatureAlgorithmIdentifier == null) {
            throw new CoreException("signature algorithm identifier can not be null");
        }
        String sigAlgOID = signatureAlgorithmIdentifier.getAlgorithm().getId();
        ArrayList<SignatureAlgorithm> signatureAlgorithms = AlgorithmService.getSignatureForOID((String)sigAlgOID);
        if (signatureAlgorithms.isEmpty()) {
            throw new CoreException("no signature algorithm found for OID: " + sigAlgOID);
        }
        ArrayList<SignatureAlgorithm> tmpSignatureAlgorithms = new ArrayList<SignatureAlgorithm>();
        for (SignatureAlgorithm signatureAlgorithm : signatureAlgorithms) {
            if (!(signatureAlgorithm instanceof SignatureAlgorithmImpl)) continue;
            tmpSignatureAlgorithms.add(signatureAlgorithm);
        }
        signatureAlgorithms = tmpSignatureAlgorithms;
        if (signatureAlgorithms.isEmpty()) {
            throw new CoreException("no signature algorithm found for OID: " + sigAlgOID);
        }
        SignatureAlgorithm signatureAlgorithm = (SignatureAlgorithm)signatureAlgorithms.get(0);
        ASN1Encodable sigAlgParams = signatureAlgorithmIdentifier.getParameters();
        if (sigAlgParams != null && !(sigAlgParams instanceof DERNull)) {
            if (!signatureAlgorithm.getBaseAlgorithm().equals((Object)SignatureAlgorithmBase.RSA)) throw new CoreException("parameters not supported for base algorithm: " + signatureAlgorithm.getBaseAlgorithm());
            if (!ID_RSASSA_PSS_OID.equals(sigAlgOID)) throw new CoreException("parameters not supported for algorithm: " + sigAlgOID + "(" + signatureAlgorithm.getName() + ")");
            RSASSAPSSparams rsaParams = null;
            try {
                rsaParams = RSASSAPSSparams.getInstance((Object)sigAlgParams.toASN1Primitive().getEncoded());
            }
            catch (IOException e) {
                throw new CoreException("failed to parse RSASSA PSS parameters", e);
            }
            DigestAlgorithm digestAlgorithm = AlgorithmService.getDigestForOID((String)rsaParams.getHashAlgorithm().getAlgorithm().getId());
            PaddingAlgorithm padding = AlgorithmService.getPaddingForOID((String)ID_RSASSA_PSS_OID);
            return AlgorithmService.getSignature((SignatureAlgorithmBase)SignatureAlgorithmBase.RSA, (DigestAlgorithm)digestAlgorithm, (PaddingAlgorithm)padding, null);
        }
        if (signatureAlgorithms.size() == 1) return signatureAlgorithm;
        throw new CoreException("multiple signature algorithms found for OID: " + sigAlgOID);
    }
}

