/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom;

import de.governikus.csl.uom.CoreException;

public class CSLCardException
extends CoreException {
    public static final String NO_MESSAGE = "no message";
    private static final long serialVersionUID = 1L;
    private final Failure failure;

    public CSLCardException(Failure failure) {
        this(failure, NO_MESSAGE, null);
    }

    public CSLCardException(Failure failure, Throwable cause) {
        this(failure, cause == null ? NO_MESSAGE : cause.getMessage(), cause);
    }

    public CSLCardException(Failure failure, String message) {
        this(failure, message, null);
    }

    public CSLCardException(Failure failure, String message, Throwable cause) {
        super(message, cause);
        this.failure = failure == null ? Failure.CARD_FAILED_UNKNOWN : failure;
    }

    public Failure getFailure() {
        return this.failure;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null || message.isEmpty()) {
            message = NO_MESSAGE;
        }
        return this.failure.name() + ": " + message;
    }

    public static enum Failure {
        CARD_FAILED_UNKNOWN,
        CARD_AUTHORIZATION_FAILED,
        CARD_AUTHORIZATION_TIMEOUT,
        CARD_AUTHORIZATION_WRONG_PIN,
        CARD_AUTHORIZATION_EXPIRED_PIN,
        CARD_AUTHORIZATION_CANCEL,
        CARD_AUTHORIZATION_PIN_DIFFERS,
        CARD_AUTHORIZATION_PIN_TOO_LONG,
        CARD_AUTHORIZATION_PIN_TOO_SHORT;

    }
}

