/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PDFSignatureType;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.verification.CosSignatureAttributeCollector;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.ValidationResult;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.List;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDFSignatureParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PDFSignatureParser.class);
    private static final ObjectFactory svpFactory = new ObjectFactory();
    protected static final String DICTIONARY_KEY_CERT_ENTRY = "Cert";
    protected CertificateFactory certificateFactory;
    private PDFSignatureType signatureType;

    public PDFSignatureParser(PDFSignatureType signatureType) throws CertificateException, NoSuchProviderException {
        this.signatureType = signatureType;
        this.certificateFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
    }

    public boolean canHandle(PDSignature signature) {
        return this.signatureType.getName().equals(signature.getSubFilter());
    }

    public PAdESSignature parseSignature(RevisionResult revisionResult, Document signedDocument, TempDataManager tempDataManager, AlgorithmManager algorithmManager) throws Exception {
        try {
            PAdESSignature padesSig = this.parseSignatureInternal(revisionResult, signedDocument, tempDataManager, algorithmManager);
            SignatureAttributesType signatureAttributes = PDFSignatureParser.getSignatureAttributes((AdESSignature)padesSig);
            CosSignatureAttributeCollector.collect(revisionResult.getPdSignature(), signatureAttributes);
            return padesSig;
        }
        catch (Exception e) {
            ValidationResult parserResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"pades_unparseable_signature"});
            PAdESSignature pAdESSignature = new PAdESSignature();
            pAdESSignature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)parserResult);
            return pAdESSignature;
        }
    }

    public static SignatureAttributesType getSignatureAttributes(AdESSignature adesSig) {
        SignatureAttributesType signatureAttributes;
        if (adesSig.getSignatureAttributes() == null) {
            signatureAttributes = svpFactory.createSignatureAttributesType();
            adesSig.setSignatureAttributes(signatureAttributes);
        } else {
            signatureAttributes = adesSig.getSignatureAttributes();
        }
        return signatureAttributes;
    }

    protected void handleParsingError(ValidationResult vr, String ... messageCodes) {
        vr.setMajor(MajorTotalResult.INDETERMINATE);
        this.handleParsingMessage(vr, messageCodes);
    }

    protected void handleParsingMessage(ValidationResult vr, String ... messageCodes) {
        List messages = vr.getMessages();
        for (String messageCode : messageCodes) {
            messages.add(SVPFactory.createMessageCode((String)messageCode));
        }
    }

    protected abstract PAdESSignature parseSignatureInternal(RevisionResult var1, Document var2, TempDataManager var3, AlgorithmManager var4) throws Exception;
}

