/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.cades.attributes.SignatureAttributesGenerator;
import de.governikus.csl.pades.PAdESDocumentTimestamp;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PAdESTimestampFactory;
import de.governikus.csl.pades.PDFSignatureHelper;
import de.governikus.csl.pades.PDFSignatureType;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.verification.PDFSignatureParser;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.List;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETSI_RFC3161Parser
extends PDFSignatureParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ETSI_RFC3161Parser.class);

    public ETSI_RFC3161Parser() throws CertificateException, NoSuchProviderException {
        super(PDFSignatureType.ETSI_RFC_3161);
    }

    @Override
    protected PAdESSignature parseSignatureInternal(RevisionResult revisionResult, Document signedDocument, TempDataManager tempDataManager, AlgorithmManager algorithmManager) {
        block16: {
            PDSignature sig = revisionResult.getPdSignature();
            TSPParser tspParser = new TSPParser(algorithmManager);
            try {
                byte[] cmsSignature = PDFSignatureHelper.getCMSSignature(sig);
                SignatureTimeStampToken tst = new SignatureTimeStampToken((Source)new BSource(cmsSignature));
                List timestamps = tspParser.parse((SignedData)tst.getContent(), null, (TimestampFactory)new PAdESTimestampFactory());
                if (timestamps == null || timestamps.isEmpty()) break block16;
                PAdESDocumentTimestamp pAdESDocTimestamp = (PAdESDocumentTimestamp)((Object)timestamps.get(0));
                SignatureAttributesGenerator.addSignatureAttributes((byte[])cmsSignature, (SignatureAttributesType)ETSI_RFC3161Parser.getSignatureAttributes((AdESSignature)pAdESDocTimestamp));
                pAdESDocTimestamp.setByteRange(sig.getByteRange());
                pAdESDocTimestamp.setSignatureBytes(PDFSignatureHelper.getCMSSignature(sig));
                try (InputStream inputStream = signedDocument.getInputStream();){
                    byte[] data = sig.getSignedContent(inputStream);
                    pAdESDocTimestamp.setTimestampedData(data);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not read signed document.", (Throwable)e);
                }
                return pAdESDocTimestamp;
            }
            catch (ParseException e) {
                LOGGER.warn("Could not parse signature.", (Throwable)e);
            }
        }
        return null;
    }
}

