/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci.asn1.cms.SignaturePolicyId;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.cades.CAdESDocument;
import de.governikus.csl.cades.CAdESParser;
import de.governikus.csl.cades.CMSSignature;
import de.governikus.csl.cades.attributes.SignatureAttributesGenerator;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.pades.PAdESCMSUtil;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PDFSignatureHelper;
import de.governikus.csl.pades.PDFSignatureType;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.verification.PDFSignatureParser;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.ValidationResult;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class ETSI_CAdESDetachedParser
extends PDFSignatureParser {
    public ETSI_CAdESDetachedParser() throws CertificateException, NoSuchProviderException {
        super(PDFSignatureType.ETSI_CAdES_Detached);
    }

    @Override
    protected PAdESSignature parseSignatureInternal(RevisionResult revisionResult, Document signedDocument, TempDataManager tempDataManager, AlgorithmManager algorithmManager) throws Exception {
        PAdESSignature pAdESSignature = new PAdESSignature();
        PDSignature sigDic = revisionResult.getPdSignature();
        CMSSignedData cmsSig = PDFSignatureHelper.parseCMSSignature(sigDic);
        SignatureAttributesGenerator.addSignatureAttributes((CMSSignedData)cmsSig, (SignatureAttributesType)ETSI_CAdESDetachedParser.getSignatureAttributes((AdESSignature)pAdESSignature));
        ValidationResult parserResult = SVPFactory.createResultOk();
        this.checkCompliance(sigDic, cmsSig, parserResult);
        CAdESParser cadesParser = new CAdESParser(algorithmManager, tempDataManager);
        CAdESDocument cadesDocument = cadesParser.loadDocument(cmsSig);
        List signatures = cadesDocument.getSignatures();
        CMSSignature signature = (CMSSignature)signatures.get(0);
        int[] byteRange = sigDic.getByteRange();
        Document signedContent = PAdESCMSUtil.getSignedContent(signedDocument, byteRange);
        ArrayList<BaseSignedContentPart> signedContentParts = new ArrayList<BaseSignedContentPart>();
        for (Object scp : signature.getSignedContentParts()) {
            signedContentParts.add(new BaseSignedContentPart((StreamProvider)signedContent, scp.getDigest(), scp.getDigestAlgorithm()));
        }
        List signedDataTimestamps = signature.getSignedDataTimestamps();
        if (signedDataTimestamps != null) {
            for (Timestamp ts : signedDataTimestamps) {
                if (!(ts instanceof WritableTimestamp)) continue;
                WritableTimestamp wts = (WritableTimestamp)ts;
                wts.setTimestampedContent((StreamProvider)PAdESCMSUtil.getSignedContent(signedDocument, byteRange));
            }
        }
        byte[] cmsSignature = PDFSignatureHelper.getCMSSignature(sigDic);
        Date claimedSigningTime = PAdESCMSUtil.getSigningTime(sigDic);
        pAdESSignature.copyValues((AdESSignature)signature);
        if (claimedSigningTime != null) {
            pAdESSignature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        pAdESSignature.setSignatureBytes(cmsSignature);
        pAdESSignature.setByteRange(byteRange);
        pAdESSignature.setSignedContentParts(signedContentParts);
        pAdESSignature.setType(SignedObjectType.DATA);
        return pAdESSignature;
    }

    private void checkCompliance(PDSignature sigDic, CMSSignedData cmsSig, ValidationResult parserResult) {
        SignedData signedData = cmsSig.getSignedData();
        if (signedData != null) {
            if (signedData.getSignerInfoList().size() == 1) {
                SignerInfo signerInfo = (SignerInfo)signedData.getSignerInfoList().get(0);
                this.checkSigningTimeSignedAttribute(parserResult, signerInfo);
                this.checkContentTypeNotPresentOrNotDataOid(parserResult, signerInfo);
                this.checkSignaturePolicyIdPresent(parserResult, signerInfo);
            } else {
                LOGGER.error("The PDF signature contains more than one SignerInfo element. This is non-compliant with PAdES signature prfiles!");
                this.handleParsingError(parserResult, "pades_more_than_one_signer_info");
            }
        }
        this.checkCertEntryInDict(sigDic, parserResult);
    }

    private void checkSigningTimeSignedAttribute(ValidationResult parserResult, SignerInfo signerInfo) {
        ANY signingTime = signerInfo.getSignedAttributeValue(SignedAttribute.signingTime);
        if (signingTime != null) {
            LOGGER.warn("The CMS part of the PDF signature has a signed attribute \"signingTime\". This is non-compliant with PAdES signature profiles!");
            this.handleParsingMessage(parserResult, "pades_signing_time_inside_cms");
        }
    }

    private void checkContentTypeNotPresentOrNotDataOid(ValidationResult parserResult, SignerInfo signerInfo) {
        OBJECTIDENTIFIER contentType = (OBJECTIDENTIFIER)signerInfo.getSignedAttributeValue(SignedAttribute.contentType);
        if (contentType == null || !contentType.getOID().equals(CMSObjectIdentifiers.data.getId())) {
            LOGGER.warn("The CMS part of the PDF signature has no signed attribute \"contentType\" with value \"data\" (OID 1.2.840.113549.1.7.1). This is non-compliant with PAdES signature profiles!");
            this.handleParsingMessage(parserResult, "pades_non_compliant_cms_contenttype");
        }
    }

    private void checkSignaturePolicyIdPresent(ValidationResult parserResult, SignerInfo signerInfo) {
        SignaturePolicyId signaturePolicyId = (SignaturePolicyId)signerInfo.getSignedAttributeValue(SignedAttribute.SIGNATURE_POLICY_IDENTIFIER);
        if (signaturePolicyId != null) {
            LOGGER.warn("A signature policy is available, but will not be considered");
            this.handleParsingMessage(parserResult, "pades_signature_policy_used");
        }
    }

    private void checkCertEntryInDict(PDSignature sigDic, ValidationResult parserResult) {
        if (sigDic.getCOSObject() != null && sigDic.getCOSObject().getItem("Cert") != null) {
            LOGGER.warn("The PDF signature has a \"Cert\" entry inside its signature dictionary. This is non-compliant with PAdES signature profiles!");
            this.handleParsingMessage(parserResult, "pades_cert_entry_inside_sig_dictionary");
        }
    }
}

