/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.governikus.csl.utils.SignatureAttributesUtils;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.ContactInfoType;
import de.governikus.csl.validate.svp.FilterType;
import de.governikus.csl.validate.svp.IntegerListType;
import de.governikus.csl.validate.svp.NameType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.SignReasonType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.SignerLocationType;
import de.governikus.csl.validate.svp.SubFilterType;
import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;
import javax.xml.bind.JAXBElement;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;

public class CosSignatureAttributeCollector {
    private static final ObjectFactory svpFactory = new ObjectFactory();

    private CosSignatureAttributeCollector() {
    }

    public static void collect(PDSignature pdSignature, SignatureAttributesType signatureAttributes) {
        List sigAttrs = signatureAttributes.getSigningTimeOrSigningCertificateOrDataObjectFormat();
        CosSignatureAttributeCollector.parseAndAdd(pdSignature, sigAttrs, "signerLocation", SignerLocationType.class, CosSignatureAttributeCollector::parseSignerLocation, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeSignerLocation(arg_0));
        CosSignatureAttributeCollector.parseAndAdd(pdSignature, sigAttrs, "signReason", SignReasonType.class, CosSignatureAttributeCollector::parseSignerReason, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeSignReason(arg_0));
        CosSignatureAttributeCollector.parseAndAdd(pdSignature, sigAttrs, "contactInfo", ContactInfoType.class, CosSignatureAttributeCollector::parseContactInfo, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeContactInfo(arg_0));
        CosSignatureAttributeCollector.parseAndAdd(pdSignature, sigAttrs, "filter", FilterType.class, CosSignatureAttributeCollector::parseFilter, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeFilter(arg_0));
        CosSignatureAttributeCollector.parseAndAdd(pdSignature, sigAttrs, "subFilter", SubFilterType.class, CosSignatureAttributeCollector::parseSubFilter, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeSubFilter(arg_0));
        CosSignatureAttributeCollector.parseAndAdd(pdSignature, sigAttrs, "name", NameType.class, CosSignatureAttributeCollector::parseName, arg_0 -> ((ObjectFactory)svpFactory).createSignatureAttributesTypeName(arg_0));
        CosSignatureAttributeCollector.parseAndAddByteRange(pdSignature, sigAttrs);
    }

    private static void parseAndAddByteRange(PDSignature pdSignature, List<JAXBElement<? extends AttributeBaseType>> sigAttrs) {
        int[] byteRange = pdSignature.getByteRange();
        if (byteRange != null && byteRange.length > 0) {
            IntegerListType byteRangeList = new IntegerListType();
            byteRangeList.setSigned(Boolean.TRUE);
            List integerList = byteRangeList.getIntegerList();
            for (int byteRangeVal : byteRange) {
                integerList.add(new BigInteger(String.valueOf(byteRangeVal)));
            }
            sigAttrs.add((JAXBElement<? extends AttributeBaseType>)svpFactory.createSignatureAttributesTypeByteRange(byteRangeList));
        }
    }

    private static <T extends AttributeBaseType> void parseAndAdd(PDSignature pdSignature, List<JAXBElement<? extends AttributeBaseType>> sigAttrs, String attributeName, Class<T> cl, Function<PDSignature, T> parseMethod, Function<T, JAXBElement<T>> jaxbGenerator) {
        AttributeBaseType parseResult;
        if (SignatureAttributesUtils.findByNameAndType((String)attributeName, cl, sigAttrs) == null && (parseResult = (AttributeBaseType)parseMethod.apply(pdSignature)) != null) {
            JAXBElement<T> reasonElem = jaxbGenerator.apply(parseResult);
            sigAttrs.add(reasonElem);
        }
    }

    private static SignerLocationType parseSignerLocation(PDSignature pdSignature) {
        String string = pdSignature.getCOSObject().getString(COSName.LOCATION);
        if (string != null) {
            SignerLocationType location = new SignerLocationType();
            location.setSigned(Boolean.TRUE);
            location.getAddress().add(string);
            return location;
        }
        return null;
    }

    private static SignReasonType parseSignerReason(PDSignature pdSignature) {
        String string = pdSignature.getCOSObject().getString(COSName.REASON);
        if (string != null) {
            SignReasonType reason = new SignReasonType();
            reason.setSigned(Boolean.TRUE);
            reason.setReasonElement(string);
            return reason;
        }
        return null;
    }

    private static ContactInfoType parseContactInfo(PDSignature pdSignature) {
        String string = pdSignature.getCOSObject().getString(COSName.CONTACT_INFO);
        if (string != null) {
            ContactInfoType contactInfo = new ContactInfoType();
            contactInfo.setSigned(Boolean.TRUE);
            contactInfo.setContactInfoElement(string);
            return contactInfo;
        }
        return null;
    }

    private static NameType parseName(PDSignature pdSignature) {
        String string = pdSignature.getCOSObject().getString(COSName.NAME);
        if (string != null) {
            NameType nameType = new NameType();
            nameType.setSigned(Boolean.valueOf(true));
            nameType.setNameElement(string);
            return nameType;
        }
        return null;
    }

    private static FilterType parseFilter(PDSignature pdSignature) {
        String string = pdSignature.getCOSObject().getNameAsString(COSName.FILTER);
        if (string != null) {
            FilterType filterType = new FilterType();
            filterType.setSigned(Boolean.valueOf(true));
            filterType.setFilterElement(string);
            return filterType;
        }
        return null;
    }

    private static SubFilterType parseSubFilter(PDSignature pdSignature) {
        String string = pdSignature.getCOSObject().getNameAsString(COSName.SUB_FILTER);
        if (string != null) {
            SubFilterType subFilterType = new SubFilterType();
            subFilterType.setSigned(Boolean.valueOf(true));
            subFilterType.setSubFilterElement(string);
            return subFilterType;
        }
        return null;
    }
}

