/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteRangeFilteringInputStream
extends FilterInputStream {
    private static Logger LOGGER = LoggerFactory.getLogger(ByteRangeFilteringInputStream.class);
    private Iterator<ByteBlock> blocks;
    private ByteBlock currentBlock;
    private int position;
    private int skipAttemtps;

    public ByteRangeFilteringInputStream(InputStream in, int[] byteRange) {
        this(in, byteRange, 2);
    }

    ByteRangeFilteringInputStream(InputStream in, int[] byteRange, int skipAtttempts) {
        super(in);
        this.skipAttemtps = skipAtttempts;
        this.position = 0;
        ArrayList<ByteBlock> blockList = new ArrayList<ByteBlock>();
        for (int i = 0; i <= byteRange.length / 2; i += 2) {
            blockList.add(new ByteBlock(byteRange[i], byteRange[i] + byteRange[i + 1]));
        }
        this.blocks = blockList.iterator();
        this.currentBlock = this.blocks.next();
    }

    @Override
    public int read() throws IOException {
        while (true) {
            int read;
            if (this.position < this.currentBlock.from) {
                this.skipToCurrentBlock();
            }
            if ((read = this.currentBlock.read()) >= 0) {
                ++this.position;
                return read;
            }
            if (!this.blocks.hasNext()) break;
            this.currentBlock = this.blocks.next();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int offset = off;
        int toRead = len;
        int bytesRead = 0;
        while (true) {
            int read;
            if (this.position < this.currentBlock.from) {
                this.skipToCurrentBlock();
            }
            if ((read = this.currentBlock.read(b, offset, toRead)) > 0) {
                bytesRead += read;
                this.position += read;
                if ((toRead -= read) == 0) {
                    return bytesRead;
                }
                offset += read;
            }
            if (!this.blocks.hasNext()) break;
            this.currentBlock = this.blocks.next();
        }
        return bytesRead > 0 ? bytesRead : -1;
    }

    private void skipToCurrentBlock() throws IOException {
        int attempts;
        long remaining;
        int toSkip = this.currentBlock.from - this.position;
        long skipped = 0L;
        for (attempts = this.skipAttemtps; skipped < (long)toSkip && attempts > 0; skipped += this.skip(remaining), --attempts) {
            remaining = (long)toSkip - skipped;
        }
        if (attempts == 0 && (long)toSkip != skipped) {
            LOGGER.error("Attempted to skip {} bytes but could only skip {} bytes", (Object)toSkip, (Object)skipped);
        }
        this.position = (int)((long)this.position + skipped);
    }

    private class ByteBlock {
        private int from;
        private int to;

        public ByteBlock(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public int read() throws IOException {
            int left = this.to - ByteRangeFilteringInputStream.this.position;
            if (left <= 0) {
                return -1;
            }
            return ByteRangeFilteringInputStream.super.read();
        }

        public int read(byte[] b, int offset, int len) throws IOException {
            int left = this.to - ByteRangeFilteringInputStream.this.position;
            if (left <= 0) {
                return -1;
            }
            int toRead = Math.min(len, left);
            return ByteRangeFilteringInputStream.super.read(b, offset, toRead);
        }
    }
}

