/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.cades.attributes.SignatureAttributesGenerator;
import de.governikus.csl.pades.PAdESCMSUtil;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PDFSignatureHelper;
import de.governikus.csl.pades.PDFSignatureType;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.verification.PDFSignatureParser;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;

public class ADBE_X509RsaSha1
extends PDFSignatureParser {
    public static final String DICTIONARY_ITEM_KEY_CERT = "Cert";

    public ADBE_X509RsaSha1() throws CertificateException, NoSuchProviderException {
        super(PDFSignatureType.ADBE_X509_RSA_SHA_1);
    }

    @Override
    protected PAdESSignature parseSignatureInternal(RevisionResult revisionResult, Document signedDocument, TempDataManager tempDataManager, AlgorithmManager algorithmManager) throws Exception {
        PDSignature sigDic = revisionResult.getPdSignature();
        COSDictionary cosSigDic = sigDic.getCOSObject();
        int[] byteRange = sigDic.getByteRange();
        COSBase certEntry = cosSigDic.getItem(DICTIONARY_ITEM_KEY_CERT);
        byte[] certificateBytes = null;
        if (certEntry == null) {
            throw new Exception("No certificate found!");
        }
        if (certEntry instanceof COSString) {
            certificateBytes = ((COSString)certEntry).getBytes();
        } else if (certEntry instanceof COSArray) {
            COSArray ary = (COSArray)certEntry;
            certificateBytes = ((COSString)ary.get(0)).getBytes();
        } else {
            throw new Exception("Unknown certificate format");
        }
        Certificate signingCertificate = this.certificateFactory.generateCertificate(new ByteArrayInputStream(certificateBytes));
        SignatureAlgorithm signatureAlgorithm = algorithmManager.getSignatureAlgorithmByJCAName("SHA1withRSA");
        Document signedContent = PAdESCMSUtil.getSignedContent(signedDocument, byteRange);
        Date claimedSigningTime = PAdESCMSUtil.getSigningTime(sigDic);
        byte[] cmsSignature = PDFSignatureHelper.getCMSSignature(sigDic);
        byte[] signatureValue = null;
        byte[] bufferedData = PDFSignatureHelper.getSignatureValue(signedDocument.getInputStream(), byteRange);
        OCTETSTRING octets = new OCTETSTRING(Run.create((Source)new BSource(bufferedData)));
        signatureValue = octets.getOctets();
        PAdESSignature pAdESSignature = new PAdESSignature();
        SignatureAttributesGenerator.addSignatureAttributes((byte[])cmsSignature, (SignatureAttributesType)ADBE_X509RsaSha1.getSignatureAttributes((AdESSignature)pAdESSignature));
        pAdESSignature.setSignatureValue(signatureValue);
        pAdESSignature.setSignatureAlgorithm(signatureAlgorithm);
        if (claimedSigningTime != null) {
            pAdESSignature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        pAdESSignature.setSignatureBytes(cmsSignature);
        pAdESSignature.setByteRange(byteRange);
        pAdESSignature.setSignedContent(signedContent);
        pAdESSignature.setSigningCertificate(new X509CertificateImpl((X509Certificate)signingCertificate));
        pAdESSignature.setType(SignedObjectType.DATA);
        return pAdESSignature;
    }
}

