/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci.asn1.cms.EncapsulatedContentInfo;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.cades.attributes.SignatureAttributesGenerator;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.pades.PAdESCMSUtil;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PDFSignatureHelper;
import de.governikus.csl.pades.PDFSignatureType;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.verification.PDFSignatureParser;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.tsp.TimestampedObject;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;

public class ADBE_PKCS7Sha1Parser
extends PDFSignatureParser {
    public static final String DICTIONARY_ITEM_KEY_JSIGN_CERT = "Zertifikat";

    public ADBE_PKCS7Sha1Parser() throws CertificateException, NoSuchProviderException {
        super(PDFSignatureType.ADBE_PKCS7_SHA_1);
    }

    @Override
    protected PAdESSignature parseSignatureInternal(RevisionResult revisionResult, Document signedDocument, TempDataManager tempDataManager, AlgorithmManager algorithmManager) throws Exception {
        PDSignature sigDic = revisionResult.getPdSignature();
        COSDictionary cosDic = sigDic.getCOSObject();
        String certEntry = cosDic.getString(COSName.getPDFName((String)DICTIONARY_ITEM_KEY_JSIGN_CERT));
        if (certEntry != null) {
            return this.parseJSignSignature(revisionResult, signedDocument, algorithmManager);
        }
        byte[] cmsSignature = PDFSignatureHelper.getCMSSignature(sigDic);
        CMSSignedData cmsSig = PDFSignatureHelper.parseCMSSignature(sigDic);
        ValidationResult parserResult = SVPFactory.createResultOk();
        SignedData signedData = cmsSig.getSignedData();
        if (signedData.getSignerInfoList().size() > 1) {
            LOGGER.error("The PDF signature contains more than one SignerInfo element. This is non-compliant with PAdES signature profiles!");
            this.handleParsingError(parserResult, "pades_more_than_one_signer_info");
        }
        SignerInfo signerInfo = (SignerInfo)signedData.getSignerInfoList().get(0);
        EncapsulatedContentInfo encapsulatedContentInfo = signedData.getEncapsulatedContentInfo();
        int[] byteRange = sigDic.getByteRange();
        List<TimestampedObject> signatureTimestamps = PAdESCMSUtil.parseSignatureTimestamps(signerInfo, algorithmManager);
        List<TimestampedObject> contentTimestamps = PAdESCMSUtil.parseContentTimestamps(signerInfo, byteRange, signedDocument, algorithmManager);
        Date claimedSigningTime = PAdESCMSUtil.getSigningTime(sigDic, signerInfo);
        SignatureAlgorithm signatureAlgorithm = PAdESCMSUtil.getSignatureAlgorithm(signerInfo, algorithmManager);
        ANY content = encapsulatedContentInfo.getContent();
        byte[] signedBytes = null;
        if (content instanceof OCTETSTRING) {
            OCTETSTRING os = (OCTETSTRING)content;
            signedBytes = os.getOctets();
        }
        Document signedContent = PAdESCMSUtil.getSignedContent(signedDocument, byteRange);
        DigestAlgorithm identifier = algorithmManager.getDigestAlgorithmByJCAName("SHA-1");
        BaseSignedContentPart scp = new BaseSignedContentPart((StreamProvider)signedContent, signedBytes, identifier);
        Set<SignatureValidationDataAttachment<X509Certificate>> certificates = PAdESCMSUtil.getCertificates(signerInfo, signedData);
        X509CertificateImpl signingCertificate = PAdESCMSUtil.getSigningCertificate(signerInfo, signedData);
        PAdESSignature pAdESSignature = new PAdESSignature();
        SignatureAttributesGenerator.addSignatureAttributes((CMSSignedData)cmsSig, (SignatureAttributesType)ADBE_PKCS7Sha1Parser.getSignatureAttributes((AdESSignature)pAdESSignature));
        pAdESSignature.setSignatureValue(signerInfo.getSignature().getOctets());
        pAdESSignature.setSignatureAlgorithm(signatureAlgorithm);
        pAdESSignature.setSignedDataTimestamps(contentTimestamps);
        pAdESSignature.setSignatureTimestamps(signatureTimestamps);
        if (claimedSigningTime != null) {
            pAdESSignature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        pAdESSignature.setSignatureBytes(cmsSignature);
        pAdESSignature.setByteRange(byteRange);
        pAdESSignature.setSignedContent((Document)new ByteArrayDocument(signedBytes));
        pAdESSignature.setSignedContentParts(Collections.singletonList(scp));
        pAdESSignature.setSigningCertificate(signingCertificate);
        pAdESSignature.setAttachedCertificates(certificates);
        pAdESSignature.setType(SignedObjectType.DATA);
        pAdESSignature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)parserResult);
        return pAdESSignature;
    }

    private PAdESSignature parseJSignSignature(RevisionResult revisionResult, Document signedDocument, AlgorithmManager algorithmManager) throws Exception {
        PDSignature sigDic = revisionResult.getPdSignature();
        int[] byteRange = sigDic.getByteRange();
        COSDictionary cosSigDic = sigDic.getCOSObject();
        String certEntry = cosSigDic.getString(DICTIONARY_ITEM_KEY_JSIGN_CERT);
        byte[] certificateBytes = Hex.parseHexString((String)certEntry);
        CMSSignedData cmsSignedData = PDFSignatureHelper.parseCMSSignature(sigDic);
        Certificate signingCertificate = this.certificateFactory.generateCertificate(new ByteArrayInputStream(certificateBytes));
        SignatureAlgorithm signatureAlgorithm = algorithmManager.getSignatureAlgorithmByJCAName("SHA1withRSA");
        Document signedContent = PAdESCMSUtil.getSignedContent(signedDocument, byteRange);
        byte[] signatureValue = PDFSignatureHelper.getSignatureValue(signedDocument.getInputStream(), byteRange);
        Date claimedSigningTime = PAdESCMSUtil.getSigningTime(sigDic);
        PAdESSignature pAdESSignature = new PAdESSignature();
        SignatureAttributesGenerator.addSignatureAttributes((CMSSignedData)cmsSignedData, (SignatureAttributesType)ADBE_PKCS7Sha1Parser.getSignatureAttributes((AdESSignature)pAdESSignature));
        pAdESSignature.setSignatureValue(signatureValue);
        pAdESSignature.setSignatureAlgorithm(signatureAlgorithm);
        pAdESSignature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        pAdESSignature.setSignatureBytes(signatureValue);
        pAdESSignature.setByteRange(byteRange);
        pAdESSignature.setSignedContent(signedContent);
        pAdESSignature.setSigningCertificate(new X509CertificateImpl((X509Certificate)signingCertificate));
        pAdESSignature.setType(SignedObjectType.DATA);
        return pAdESSignature;
    }
}

