/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.verification;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.governikus.csl.ades.AdESSignature;
import de.governikus.csl.cades.attributes.SignatureAttributesGenerator;
import de.governikus.csl.pades.PAdESCMSUtil;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PDFSignatureHelper;
import de.governikus.csl.pades.PDFSignatureType;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.verification.PDFSignatureParser;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.DateType;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.uom.validate.commons.SignedObjectType;
import de.governikus.csl.validate.svp.SignatureAttributesType;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.tsp.TimestampedObject;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.x509.AttributeCertificate;

public class ADBE_PKCS7DetachedParser
extends PDFSignatureParser {
    public ADBE_PKCS7DetachedParser() throws CertificateException, NoSuchProviderException {
        super(PDFSignatureType.ADBE_PKCS7_Detached);
    }

    @Override
    protected PAdESSignature parseSignatureInternal(RevisionResult revisionResult, Document signedDocument, TempDataManager tempDataManager, AlgorithmManager algorithmManager) throws Exception {
        PDSignature sigDic = revisionResult.getPdSignature();
        int[] byteRange = sigDic.getByteRange();
        byte[] cmsSignature = PDFSignatureHelper.getSignatureValue(signedDocument.getInputStream(), byteRange);
        PAdESSignature pAdESSignature = new PAdESSignature();
        CMSSignedData cmsSig = new CMSSignedData((Source)new BSource(cmsSignature));
        SignatureAttributesGenerator.addSignatureAttributes((CMSSignedData)cmsSig, (SignatureAttributesType)ADBE_PKCS7DetachedParser.getSignatureAttributes((AdESSignature)pAdESSignature));
        ValidationResult parserResult = SVPFactory.createResultOk();
        SignedData signedData = cmsSig.getSignedData();
        if (signedData.getSignerInfoList().size() > 1) {
            LOGGER.error("The PDF signature contains more than one SignerInfo element. This is non-compliant with PAdES signature prfiles!");
            this.handleParsingError(parserResult, "pades_more_than_one_signer_info");
        }
        SignerInfo signerInfo = (SignerInfo)signedData.getSignerInfoList().get(0);
        List<TimestampedObject> signatureTimestamps = PAdESCMSUtil.parseSignatureTimestamps(signerInfo, algorithmManager);
        List<TimestampedObject> contentTimestamps = PAdESCMSUtil.parseContentTimestamps(signerInfo, byteRange, signedDocument, algorithmManager);
        Date claimedSigningTime = PAdESCMSUtil.getSigningTime(sigDic, signerInfo);
        SignatureAlgorithm signatureAlgorithm = PAdESCMSUtil.getSignatureAlgorithm(signerInfo, algorithmManager);
        Document signedAttributeStream = PAdESCMSUtil.getSignedAttributeStream(signerInfo);
        List<SignedContentPart> signedContentParts = PAdESCMSUtil.getSignedContentParts(signerInfo, signedDocument, byteRange, algorithmManager);
        X509CertificateImpl signingCertificate = PAdESCMSUtil.getSigningCertificate(signerInfo, signedData);
        Set<SignatureValidationDataAttachment<X509Certificate>> certificates = PAdESCMSUtil.getCertificates(signerInfo, signedData);
        Set<AttributeCertificate> attributeCertSet = PAdESCMSUtil.getAttributeCertificates(signerInfo);
        pAdESSignature.setAttributeCertificates(attributeCertSet);
        pAdESSignature.setSignatureValue(signerInfo.getSignature().getOctets());
        pAdESSignature.setSignatureAlgorithm(signatureAlgorithm);
        pAdESSignature.setSignedDataTimestamps(contentTimestamps);
        pAdESSignature.setSignatureTimestamps(signatureTimestamps);
        if (claimedSigningTime != null) {
            pAdESSignature.setSigningTime(SVPFactory.createTypedDate((Date)claimedSigningTime, (DateType)DateType.CLAIMED_SIGNING_TIME));
        }
        pAdESSignature.setSignatureBytes(cmsSignature);
        pAdESSignature.setByteRange(byteRange);
        pAdESSignature.setSignedContent(signedAttributeStream);
        pAdESSignature.setSignedContentParts(signedContentParts);
        pAdESSignature.setSigningCertificate(signingCertificate);
        pAdESSignature.setAttachedCertificates(certificates);
        pAdESSignature.setType(SignedObjectType.DATA);
        pAdESSignature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)parserResult);
        return pAdESSignature;
    }
}

