/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import de.bos_bremen.ci.StreamUtil;
import de.governikus.csl.pades.revision.RevisionScannerResult;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class RevisionResult
implements Closeable {
    private final PDDocument revisionDocument;
    private final long revisionStart;
    private final long revisionLength;
    private PDSignatureField signatureField;
    private PDSignature pdSignature;
    private List<RevisionScannerResult> embeddedRevisions;
    private Boolean lastSignedHavingOnlySecureChanges;

    public RevisionResult(PDDocument revisionDocument, int revisionLength) {
        this(revisionDocument, 0, revisionLength);
    }

    public RevisionResult(PDDocument revisionDocument, int revisionStart, int revisionLength) {
        this.revisionDocument = revisionDocument;
        this.revisionLength = revisionLength;
        this.revisionStart = revisionStart;
    }

    public PDSignatureField getSignatureField() {
        return this.signatureField;
    }

    void setSignatureField(PDSignatureField pdSignature) {
        this.signatureField = pdSignature;
    }

    public PDDocument getRevisionDocument() {
        return this.revisionDocument;
    }

    public long getRevisionLength() {
        return this.revisionLength;
    }

    public long getRevisionStart() {
        return this.revisionStart;
    }

    @Override
    public void close() throws IOException {
        StreamUtil.close((Closeable)this.revisionDocument);
    }

    public PDSignature getPdSignature() {
        return this.pdSignature;
    }

    void setPdSignature(PDSignature pdSignature) {
        this.pdSignature = pdSignature;
    }

    public String getSignatureName() {
        PDSignatureField signatureField = this.getSignatureField();
        if (signatureField != null) {
            return signatureField.getPartialName();
        }
        return null;
    }

    public List<RevisionScannerResult> getEmbeddedRevisions() {
        return this.embeddedRevisions;
    }

    public void setEmbeddedRevisions(List<RevisionScannerResult> embeddedRevisions) {
        this.embeddedRevisions = embeddedRevisions;
    }

    public Boolean getLastSignedHavingOnlySecureChanges() {
        return this.lastSignedHavingOnlySecureChanges;
    }

    public void setLastSignedHavingOnlySecureChanges(Boolean lastSignedHavingOnlySecureChanges) {
        this.lastSignedHavingOnlySecureChanges = lastSignedHavingOnlySecureChanges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("RevisionRange: %d - %d%n", this.revisionStart, this.revisionLength));
        sb.append(String.format("Signed: %b%n", this.pdSignature != null && this.signatureField != null));
        if (this.embeddedRevisions != null && !this.embeddedRevisions.isEmpty()) {
            sb.append(String.format("EmbeddedRevisions: %d%n", this.embeddedRevisions.size()));
            int i = 0;
            for (RevisionScannerResult embeddedRevisionResult : this.embeddedRevisions) {
                sb.append(String.format(".....EmbeddedRevision%d.....%n", ++i));
                sb.append(embeddedRevisionResult.toString());
            }
        }
        return sb.toString();
    }
}

