/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.governikus.csl.pades.revision.PDFRevisionScanner;
import de.governikus.csl.pades.revision.PdfModificationDetectionResultConverter;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.uom.util.TempDataManager;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfModificationDetectionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfModificationDetectionUtil.class);
    private static final ObjectMapper OBJ_MAPPER = new ObjectMapper();

    public static boolean hasOnlySecureChanges(PdfObjectModifications pdfObjectModifications) {
        if (pdfObjectModifications == null || pdfObjectModifications.isEmpty()) {
            return true;
        }
        List annotCreationChanges = pdfObjectModifications.getAnnotCreationChanges();
        List formFillInAndSigCreationChanges = pdfObjectModifications.getFormFillInAndSignatureCreationChanges();
        List undefinedChanges = pdfObjectModifications.getUndefinedChanges();
        return annotCreationChanges.isEmpty() && formFillInAndSigCreationChanges.isEmpty() && undefinedChanges.isEmpty();
    }

    public static void checkModifications(List<RevisionResult> revisionResults, PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, TempDataManager tempDataManager) throws IOException {
        PdfModificationDetectionUtil.checkModifications(revisionResults, PdfModificationDetectionUtil::getLastSignatureRevision, randomAccessSupplier, tempDataManager);
    }

    public static void checkModifications(List<RevisionResult> revisionResults, Function<List<RevisionResult>, RevisionResult> lowerBoundGetter, PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, TempDataManager tempDataManager) throws IOException {
        PdfObjectModifications pdfObjectModifications = PdfModificationDetectionUtil.logAndGetModifications(revisionResults, lowerBoundGetter, randomAccessSupplier, tempDataManager);
        boolean hasOnlySecureChanges = PdfModificationDetectionUtil.hasOnlySecureChanges(pdfObjectModifications);
        RevisionResult revisionResult = lowerBoundGetter.apply(revisionResults);
        if (revisionResult != null) {
            revisionResult.setLastSignedHavingOnlySecureChanges(hasOnlySecureChanges);
        }
    }

    public static PdfObjectModifications logAndGetModifications(List<RevisionResult> revisionResults, PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, TempDataManager tempDataManager) throws IOException {
        return PdfModificationDetectionUtil.logAndGetModifications(revisionResults, PdfModificationDetectionUtil::getLastSignatureRevision, randomAccessSupplier, tempDataManager);
    }

    public static List<Long> getSignatureIDs(RevisionResult revision) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (revision == null) {
            return ids;
        }
        return PdfModificationDetectionUtil.getSignatureIDs(revision.getRevisionDocument());
    }

    public static List<Long> getSignatureIDs(PDDocument revisionDoc) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (revisionDoc == null) {
            return ids;
        }
        PDDocumentCatalog documentCatalog = revisionDoc.getDocumentCatalog();
        if (documentCatalog == null) {
            return ids;
        }
        COSDictionary rootDict = documentCatalog.getCOSObject();
        if (rootDict == null) {
            return ids;
        }
        COSBase result = rootDict.getObjectFromPath(PdfModificationDetectionResultConverter.PDFBOX_SIG_PATH);
        if (result instanceof COSArray) {
            for (COSBase arrayItem : (COSArray)result) {
                COSBase cosBase;
                if (!(arrayItem instanceof COSObject) || !((cosBase = ((COSObject)arrayItem).getObject()) instanceof COSDictionary) || ((COSDictionary)cosBase).getCOSDictionary(COSName.V) == null) continue;
                ids.add(((COSObject)arrayItem).getObjectNumber());
            }
        }
        return ids;
    }

    public static PdfObjectModifications logAndGetModifications(List<RevisionResult> revisionResults, Function<List<RevisionResult>, RevisionResult> lowerBoundGetter, PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, TempDataManager tempDataManager) throws IOException {
        if (revisionResults == null || revisionResults.isEmpty()) {
            return null;
        }
        RevisionResult signatureRevision = lowerBoundGetter.apply(revisionResults);
        RevisionResult lastRevision = revisionResults.get(revisionResults.size() - 1);
        if (signatureRevision == null || lastRevision == null) {
            return null;
        }
        if (signatureRevision == lastRevision) {
            LOGGER.debug("The last signed revision is not followed by any other revision(s)");
            return new PdfObjectModifications();
        }
        long signatureRevisionLength = signatureRevision.getRevisionLength();
        long lastRevisionLength = lastRevision.getRevisionLength();
        PdfObjectModifications pdfObjectModifications = PdfModificationDetectionUtil.getModifications(randomAccessSupplier, signatureRevisionLength, lastRevisionLength, tempDataManager);
        return pdfObjectModifications;
    }

    public static PdfObjectModifications getModifications(PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, long lengthPrev, long lengthNext, TempDataManager tmpMgr) throws IOException {
        return PdfModificationDetectionUtil.getModifications(randomAccessSupplier, lengthPrev, lengthNext, 0, null, tmpMgr);
    }

    public static PdfObjectModifications getModifications(PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, long lengthPrev, long lengthNext, int compareDepth, TempDataManager tmpMgr) throws IOException {
        return PdfModificationDetectionUtil.getModifications(randomAccessSupplier, lengthPrev, lengthNext, compareDepth, null, tmpMgr);
    }

    /*
     * Exception decompiling
     */
    public static PdfObjectModifications getModifications(PDFRevisionScanner.RandomAccessReadSupplier randomAccessSupplier, long lengthPrev, long lengthNext, int compareDepth, TriConsumer<PdfObjectModifications, Long, Long> modificationsConsumer, TempDataManager tmpMgr) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkModificationResult(List<Long> signatureIDs, PdfObjectModifications pdfObjectModifications, long lengthPrev, long lengthNext) throws JsonProcessingException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(PdfModificationDetectionUtil.createModificationsLogMsg(pdfObjectModifications, lengthPrev, lengthNext));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PdfObjectModifications before filtering: {}", (Object)OBJ_MAPPER.writeValueAsString((Object)pdfObjectModifications));
        }
        PdfModificationDetectionResultConverter.moveChanges(signatureIDs, pdfObjectModifications);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("PdfObjectModifications after filtering: {}", (Object)OBJ_MAPPER.writeValueAsString((Object)pdfObjectModifications));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(PdfModificationDetectionUtil.createModificationsLogMsg(pdfObjectModifications, lengthPrev, lengthNext));
        }
    }

    public static String createModificationsLogMsg(PdfObjectModifications pdfObjectModifications, long lengthPrev, long lengthNext) {
        List annotCreationChanges = pdfObjectModifications.getAnnotCreationChanges();
        List formFillInAndSigCreationChanges = pdfObjectModifications.getFormFillInAndSignatureCreationChanges();
        List secureChanges = pdfObjectModifications.getSecureChanges();
        List undefinedChanges = pdfObjectModifications.getUndefinedChanges();
        if (!pdfObjectModifications.isEmpty()) {
            String logMsg = String.format("\nChanges from last signed revision: %d to last revision %d\n", lengthPrev, lengthNext);
            logMsg = logMsg + PdfModificationDetectionUtil.createModificationsLogMsg("--- Annoation creation", annotCreationChanges);
            logMsg = logMsg + PdfModificationDetectionUtil.createModificationsLogMsg("--- Form fill & signature creation", formFillInAndSigCreationChanges);
            logMsg = logMsg + PdfModificationDetectionUtil.createModificationsLogMsg("--- Secure", secureChanges);
            logMsg = logMsg + PdfModificationDetectionUtil.createModificationsLogMsg("--- Undefined", undefinedChanges);
            return logMsg;
        }
        return String.format("Changes from last signed revision: %d to last revision %d: 0", lengthPrev, lengthNext);
    }

    public static String createModificationsLogMsg(String changesName, List<ObjectModification> changes) {
        StringBuilder sb = new StringBuilder();
        sb.append(changesName);
        sb.append(" changes: ");
        sb.append(changes.size());
        sb.append(":\n");
        for (ObjectModification mod : changes) {
            sb.append("\t");
            sb.append(mod.getActionType());
            sb.append(": ");
            sb.append(mod.getObjectTree());
            sb.append(" (");
            sb.append(mod.getType());
            sb.append(", ");
            sb.append(mod.getFieldName());
            sb.append(")");
            Object origObj = mod.getOriginalObject();
            Object finalObj = mod.getFinalObject();
            if (origObj instanceof Number && finalObj instanceof Number) {
                sb.append(": ");
                sb.append(origObj);
                sb.append(" -> ");
                sb.append(finalObj);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static RevisionResult getFirstAnySignatureRevision(List<RevisionResult> revisionResults) {
        return PdfModificationDetectionUtil.getFirstRevision(revisionResults, PdfModificationDetectionUtil::isAnySignature);
    }

    public static RevisionResult getLastAnySignatureRevision(List<RevisionResult> revisionResults) {
        return PdfModificationDetectionUtil.getLastRevision(revisionResults, PdfModificationDetectionUtil::isAnySignature);
    }

    public static RevisionResult getFirstSignatureRevision(List<RevisionResult> revisionResults) {
        return PdfModificationDetectionUtil.getFirstRevision(revisionResults, PdfModificationDetectionUtil::isSignature);
    }

    public static RevisionResult getLastSignatureRevision(List<RevisionResult> revisionResults) {
        return PdfModificationDetectionUtil.getLastRevision(revisionResults, PdfModificationDetectionUtil::isSignature);
    }

    public static RevisionResult getFirstTimestampRevision(List<RevisionResult> revisionResults) {
        return PdfModificationDetectionUtil.getFirstRevision(revisionResults, PdfModificationDetectionUtil::isTimestamp);
    }

    public static RevisionResult getLastTimestampRevision(List<RevisionResult> revisionResults) {
        return PdfModificationDetectionUtil.getLastRevision(revisionResults, PdfModificationDetectionUtil::isTimestamp);
    }

    public static RevisionResult getFirstRevision(List<RevisionResult> revisionResults, Function<PDSignatureField, Boolean> filter) {
        for (int i = 0; i < revisionResults.size(); ++i) {
            RevisionResult revisionResult = revisionResults.get(i);
            if (revisionResult == null || !filter.apply(revisionResult.getSignatureField()).booleanValue()) continue;
            return revisionResult;
        }
        return null;
    }

    public static RevisionResult getLastRevision(List<RevisionResult> revisionResults, Function<PDSignatureField, Boolean> filter) {
        for (int i = revisionResults.size() - 1; i >= 0; --i) {
            RevisionResult revisionResult = revisionResults.get(i);
            if (revisionResult == null || !filter.apply(revisionResult.getSignatureField()).booleanValue()) continue;
            return revisionResult;
        }
        return null;
    }

    public static boolean isAnySignature(PDSignatureField pdSigField) {
        return pdSigField != null;
    }

    public static boolean isSignature(PDSignatureField pdSigField) {
        COSDictionary vDict = PdfModificationDetectionUtil.getV(pdSigField);
        return Objects.equals(COSName.SIG, PdfModificationDetectionUtil.getSignatureType(vDict));
    }

    public static boolean isTimestamp(PDSignatureField pdSigField) {
        COSDictionary vDict = PdfModificationDetectionUtil.getV(pdSigField);
        return Objects.equals(COSName.DOC_TIME_STAMP, PdfModificationDetectionUtil.getSignatureType(vDict));
    }

    public static COSDictionary getV(PDSignatureField pdSigField) {
        if (pdSigField == null) {
            return null;
        }
        COSDictionary cosDictionary = pdSigField.getCOSObject();
        if (cosDictionary == null) {
            return null;
        }
        COSBase cosBase = cosDictionary.getDictionaryObject(COSName.V);
        if (cosBase instanceof COSDictionary) {
            return (COSDictionary)cosBase;
        }
        return null;
    }

    public static COSName getSignatureType(COSDictionary vDict) {
        if (vDict == null) {
            return null;
        }
        COSBase item = vDict.getDictionaryObject(COSName.TYPE);
        if (item == null || !(item instanceof COSName)) {
            return COSName.SIG;
        }
        return (COSName)item;
    }

    static {
        OBJ_MAPPER.configure(SerializationFeature.FAIL_ON_SELF_REFERENCES, false);
        OBJ_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3) throws IOException;
    }
}

