/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import eu.europa.esig.dss.enumerations.PdfObjectModificationType;
import eu.europa.esig.dss.pdf.modifications.ObjectModification;
import eu.europa.esig.dss.pdf.modifications.PdfObjectModifications;
import eu.europa.esig.dss.pdf.modifications.PdfObjectTree;
import eu.europa.esig.dss.pdf.pdfbox.DSSPdfBoxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.cos.COSName;

public class PdfModificationDetectionResultConverter {
    static final String PDF_PATH_PART_CATALOG = COSName.CATALOG.getName();
    static final String PDF_PATH_PART_ACRO_FORM = COSName.ACRO_FORM.getName();
    static final String PDFBOX_SIG_PATH = PDF_PATH_PART_ACRO_FORM + "/" + COSName.FIELDS.getName();
    static final String PDF_PATH_PART_SIGFLAGS = COSName.SIG_FLAGS.getName();
    static final String PDF_PATH_PART_DA = COSName.DA.getName();
    static final String PDF_PATH_PART_DR = COSName.DR.getName();
    static final String PDF_PATH_PART_ENCODING = COSName.ENCODING.getName();
    static final String PDF_PATH_PART_FONT = COSName.FONT.getName();
    static final String PDF_PATH_PART_STRUCTTREEROOT = COSName.STRUCT_TREE_ROOT.getName();
    static final List<String> PDF_PATH_ACROFROM_SIGFLAGS = Arrays.asList(PDF_PATH_PART_CATALOG, PDF_PATH_PART_ACRO_FORM, PDF_PATH_PART_SIGFLAGS);
    private static final List<String> PDF_PATH_ACROFROM_DA = Arrays.asList(PDF_PATH_PART_CATALOG, PDF_PATH_PART_ACRO_FORM, PDF_PATH_PART_DA);
    private static final List<String> PDF_PATH_ACROFROM_DR = Arrays.asList(PDF_PATH_PART_CATALOG, PDF_PATH_PART_ACRO_FORM, PDF_PATH_PART_DR);
    private static final List<String> PDF_PATH_STRUCTTREEROOT = Arrays.asList(PDF_PATH_PART_CATALOG, PDF_PATH_PART_STRUCTTREEROOT);

    public static void moveChanges(List<Long> signatureIDs, PdfObjectModifications pdfObjectModifications) {
        PdfModificationDetectionResultConverter.moveStructTreeRootChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getUndefinedChanges());
        PdfModificationDetectionResultConverter.moveFontChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getFormFillInAndSignatureCreationChanges());
        PdfModificationDetectionResultConverter.moveSigFlagChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getFormFillInAndSignatureCreationChanges());
        PdfModificationDetectionResultConverter.moveTypeChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getAnnotCreationChanges());
        PdfModificationDetectionResultConverter.moveTypeChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getFormFillInAndSignatureCreationChanges());
        PdfModificationDetectionResultConverter.moveTypeChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getUndefinedChanges());
        PdfModificationDetectionResultConverter.moveAnnotationChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getAnnotCreationChanges(), signatureIDs);
        PdfModificationDetectionResultConverter.moveAnnotationChanges(pdfObjectModifications.getSecureChanges(), pdfObjectModifications.getFormFillInAndSignatureCreationChanges(), signatureIDs);
    }

    static Number getNumberThatIs(Number n1, Number n2, List<Class<?>> anyOf) {
        if (anyOf.stream().anyMatch(c -> c.isInstance(n1))) {
            return n1;
        }
        if (anyOf.stream().anyMatch(c -> c.isInstance(n2))) {
            return n2;
        }
        return null;
    }

    static boolean areEqual(long longVal, double doubleVal) {
        int preDecimal = (int)doubleVal;
        double decimal = doubleVal - (double)preDecimal;
        return decimal == 0.0 && longVal == (long)preDecimal;
    }

    static boolean isKeyChain(PdfObjectTree tree, List<String> compareChain) {
        return PdfModificationDetectionResultConverter.isKeyChain(tree, compareChain, false);
    }

    static boolean isKeyChain(PdfObjectTree tree, List<String> compareChain, boolean allowPartialMatch) {
        List keyChain = tree.getKeyChain();
        if (!(allowPartialMatch || keyChain != null && keyChain.size() == compareChain.size())) {
            return false;
        }
        for (int i = 0; !(i >= keyChain.size() || allowPartialMatch && i >= compareChain.size()); ++i) {
            if (compareChain.get(i).equals(keyChain.get(i))) continue;
            return false;
        }
        return !allowPartialMatch || keyChain.size() >= compareChain.size();
    }

    static boolean isSigFlagsKeyChain(PdfObjectTree tree) {
        return PdfModificationDetectionResultConverter.isKeyChain(tree, PDF_PATH_ACROFROM_SIGFLAGS);
    }

    static boolean isDAKeyChain(PdfObjectTree tree) {
        return PdfModificationDetectionResultConverter.isKeyChain(tree, PDF_PATH_ACROFROM_DA, true);
    }

    static boolean isDRKeyChain(PdfObjectTree tree) {
        return PdfModificationDetectionResultConverter.isKeyChain(tree, PDF_PATH_ACROFROM_DR, true);
    }

    static boolean isStructTreeRootKeyChain(PdfObjectTree tree) {
        return PdfModificationDetectionResultConverter.isKeyChain(tree, PDF_PATH_STRUCTTREEROOT, true);
    }

    public static void moveStructTreeRootChanges(List<ObjectModification> secureChanges, List<ObjectModification> insecureChanges) {
        ArrayList<ObjectModification> moveList = new ArrayList<ObjectModification>();
        for (ObjectModification change : insecureChanges) {
            PdfObjectTree objectTree = change.getObjectTree();
            if (objectTree == null || !PdfModificationDetectionResultConverter.isStructTreeRootKeyChain(objectTree)) continue;
            moveList.add(change);
        }
        if (insecureChanges.removeAll(moveList)) {
            secureChanges.addAll(moveList);
        }
    }

    public static void moveFontChanges(List<ObjectModification> secureChanges, List<ObjectModification> insecureChanges) {
        ArrayList<ObjectModification> moveList = new ArrayList<ObjectModification>();
        for (ObjectModification change : insecureChanges) {
            PdfObjectTree objectTree = change.getObjectTree();
            if (objectTree == null || !PdfModificationDetectionResultConverter.isDAKeyChain(objectTree) && !PdfModificationDetectionResultConverter.isDRKeyChain(objectTree)) continue;
            moveList.add(change);
        }
        if (insecureChanges.removeAll(moveList)) {
            secureChanges.addAll(moveList);
        }
    }

    public static void moveSigFlagChanges(List<ObjectModification> secureChanges, List<ObjectModification> insecureChanges) {
        ArrayList<ObjectModification> moveList = new ArrayList<ObjectModification>();
        for (ObjectModification change : insecureChanges) {
            PdfObjectTree objectTree;
            if (PdfObjectModificationType.DELETION.equals((Object)change.getActionType()) || (objectTree = change.getObjectTree()) == null || !PdfModificationDetectionResultConverter.isSigFlagsKeyChain(objectTree)) continue;
            moveList.add(change);
        }
        if (insecureChanges.removeAll(moveList)) {
            secureChanges.addAll(moveList);
        }
    }

    public static void moveTypeChanges(List<ObjectModification> secureChanges, List<ObjectModification> insecureChanges) {
        ArrayList<ObjectModification> moveList = new ArrayList<ObjectModification>();
        for (ObjectModification change : insecureChanges) {
            if (!PdfObjectModificationType.MODIFICATION.equals((Object)change.getActionType())) continue;
            Object origObj = change.getOriginalObject();
            Object finalObj = change.getFinalObject();
            if (!(origObj instanceof Number) || !(finalObj instanceof Number)) continue;
            Number integral = PdfModificationDetectionResultConverter.getNumberThatIs((Number)origObj, (Number)finalObj, Arrays.asList(Integer.class, Long.class));
            Number decimal = PdfModificationDetectionResultConverter.getNumberThatIs((Number)origObj, (Number)finalObj, Arrays.asList(Float.class, Double.class));
            if (integral == null || decimal == null || integral == decimal || !PdfModificationDetectionResultConverter.areEqual(integral.longValue(), decimal.doubleValue())) continue;
            moveList.add(change);
        }
        if (insecureChanges.removeAll(moveList)) {
            secureChanges.addAll(moveList);
        }
    }

    public static void moveAnnotationChanges(List<ObjectModification> secureChanges, List<ObjectModification> insecureChanges, List<Long> signatureIDs) {
        ArrayList<ObjectModification> moveList = new ArrayList<ObjectModification>();
        for (ObjectModification change : insecureChanges) {
            List newObjIDs;
            Object finalObject;
            if (!PdfObjectModificationType.CREATION.equals((Object)change.getActionType()) || (finalObject = change.getFinalObject()) == null || (newObjIDs = DSSPdfBoxUtil.getSigObjIDsForAnnotChange((Object)finalObject)).isEmpty() || !newObjIDs.stream().allMatch(signatureIDs::contains)) continue;
            moveList.add(change);
        }
        if (insecureChanges.removeAll(moveList)) {
            secureChanges.addAll(moveList);
        }
    }
}

