/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import de.governikus.csl.pades.PAdESPlugin;
import de.governikus.csl.pades.revision.KMPPatternMatch;
import de.governikus.csl.pades.revision.LimitedRandomAccessRead;
import de.governikus.csl.pades.revision.PdfModificationDetectionUtil;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.revision.RevisionScannerResult;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.util.SwapFileDocument;
import de.governikus.csl.uom.util.TempDataManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.ScratchFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFRevisionScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFRevisionScanner.class);
    private static final String REVISION_WITH_MULTIPLE_SIGS = "Another signature found for one revision. This shouldn't be possible. Very likely the signature detection failed.";
    private static final long DEFAULT_MEMORY_USAGE = 0xA00000L;
    private static final String EOF_PATTERN = "%%EOF";
    private static final String LINEARIZED_PATTERN = "/Linearized";
    private static final Charset BYTE_ENCODING = StandardCharsets.UTF_8;
    private static final byte[] EOF_BYTES = "%%EOF".getBytes(BYTE_ENCODING);
    private static final byte[] LINEARIZED_PATTERN_BYTES = "/Linearized".getBytes(BYTE_ENCODING);
    private Exception decryptExecption = null;

    public Exception getDecryptExecption() {
        return this.decryptExecption;
    }

    public RevisionScannerResult getRevisions(Document document, TempDataManager tempDataManager) throws IOException, CoreException {
        SwapFileDocument doc;
        File documentFile = null;
        byte[] data = null;
        if (document instanceof FileDocumentImpl) {
            FileDocumentImpl fileDoc = (FileDocumentImpl)document;
            documentFile = fileDoc.getFile();
        } else if (document instanceof SwapFileDocument) {
            doc = (SwapFileDocument)document;
            if (!doc.isInMemory()) {
                documentFile = doc.getFile();
            } else {
                data = doc.getData();
            }
        } else if (document instanceof ByteArrayDocument) {
            doc = (ByteArrayDocument)document;
            data = doc.getData();
        }
        RandomAccessReadSupplier randomAccessSupplier = PDFRevisionScanner.getRandomAccessReadSupplier(document, tempDataManager, documentFile, data);
        return this.getRevisions(randomAccessSupplier, document, tempDataManager);
    }

    public static RandomAccessReadSupplier getRandomAccessReadSupplier(Document document, TempDataManager tempDataManager, File documentFile, byte[] data) throws IOException {
        RandomAccessReadSupplier randomAccessSupplier;
        if (documentFile != null) {
            File f = documentFile;
            randomAccessSupplier = () -> new RandomAccessBufferedFileInputStream(f);
        } else if (data != null) {
            byte[] b = data;
            randomAccessSupplier = () -> new RandomAccessBuffer(b);
        } else {
            File tmpFile = tempDataManager.createTempFile("gov4_pades", ".pdf");
            try (InputStream in = document.getInputStream();
                 FileOutputStream fos = new FileOutputStream(tmpFile);){
                IOUtils.copy((InputStream)in, (OutputStream)fos);
            }
            randomAccessSupplier = () -> new RandomAccessBufferedFileInputStream(tmpFile);
        }
        return randomAccessSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevisionScannerResult getRevisions(RandomAccessReadSupplier randomAccessSupplier, Document document, TempDataManager tempDataManager) throws IOException, CoreException {
        ArrayList<RevisionResult> revisions = new ArrayList<RevisionResult>();
        try (RandomAccessRead raf = randomAccessSupplier.getRandomAccessRead();){
            long eofIndex = 0L;
            while ((eofIndex = KMPPatternMatch.endIndexOf(raf, eofIndex, EOF_BYTES)) != -1L) {
                block35: {
                    LOGGER.debug("Revision end index = {}", (Object)eofIndex);
                    PDDocument pdDocument = null;
                    try {
                        LimitedRandomAccessRead lrar = new LimitedRandomAccessRead(randomAccessSupplier.getRandomAccessRead(), eofIndex);
                        Throwable throwable = null;
                        try {
                            pdDocument = PDFRevisionScanner.load(lrar, tempDataManager);
                            tempDataManager.add((Closeable)pdDocument);
                            RevisionResult revisionResult = new RevisionResult(pdDocument, (int)eofIndex);
                            revisions.add(revisionResult);
                            COSDictionary trailer = pdDocument.getDocument().getTrailer();
                            if (trailer == null) {
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug("Could not find trailer, skipping signature field copying and embedded revision parsing");
                                continue;
                            }
                            if (this.transferSignatureFields(revisionResult, pdDocument, revisions)) {
                                this.optionallyExpandRevisionSize(revisions, eofIndex, pdDocument, revisionResult);
                            }
                            this.parseAndAddEmbeddedRevisions(pdDocument, revisionResult, tempDataManager);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (lrar == null) continue;
                            if (throwable != null) {
                                try {
                                    lrar.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            lrar.close();
                            continue;
                        }
                    }
                    catch (IOException ioe) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("#0-{}: skip because it is not valid pdf ({}).", new Object[]{eofIndex, document.getName(), ioe});
                        }
                        if (ioe.getMessage() == null || !ioe.getMessage().contains("decrypt")) break block35;
                        this.decryptExecption = ioe;
                    }
                    finally {
                        if (pdDocument == null || !LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("#0-{}: Loaded revision ({}).", (Object)eofIndex, (Object)document.getName());
                        continue;
                    }
                }
                eofIndex = KMPPatternMatch.skipWhiteSpace(eofIndex, raf);
            }
            PdfModificationDetectionUtil.checkModifications(revisions, randomAccessSupplier, tempDataManager);
            RevisionScannerResult rrs = new RevisionScannerResult();
            rrs.setDocument(document);
            rrs.setRevisions(revisions);
            RevisionScannerResult revisionScannerResult = rrs;
            return revisionScannerResult;
        }
    }

    private void optionallyExpandRevisionSize(List<RevisionResult> revisions, long eofIndex, PDDocument pdDocument, RevisionResult revisionResult) {
        int[] byteRange = revisionResult.getPdSignature().getByteRange();
        if (byteRange != null && byteRange.length > 0) {
            long sizeDiff;
            int signatureSize = byteRange[2] + byteRange[3];
            if ((long)signatureSize > eofIndex) {
                int replaceIndex = revisions.size() - 1;
                RevisionResult replaced = revisions.get(replaceIndex);
                RevisionResult expandedRevision = new RevisionResult(pdDocument, signatureSize);
                expandedRevision.setPdSignature(replaced.getPdSignature());
                expandedRevision.setSignatureField(replaced.getSignatureField());
                revisions.set(replaceIndex, expandedRevision);
            }
            if ((sizeDiff = (long)signatureSize - eofIndex) > 2L) {
                LOGGER.debug("The signature byte range includes more than 2 trailing whitespaces after EOF: {}", (Object)sizeDiff);
            }
        }
    }

    public boolean transferSignatureFields(RevisionResult revisionResult, PDDocument pdDocument, List<RevisionResult> revisions) throws IOException, CoreException {
        List signatureFields = pdDocument.getSignatureFields();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("signatureField.size = {}", (Object)signatureFields.size());
        }
        for (PDSignatureField pdSignatureField : signatureFields) {
            PDSignature pdSignature;
            COSBase value = pdSignatureField.getCOSObject().getDictionaryObject(COSName.V);
            if (!(value instanceof COSDictionary) || (pdSignature = pdSignatureField.getSignature()) == null || this.isSignatureInRevision(revisions, pdSignatureField)) continue;
            if (revisionResult.getSignatureField() == null) {
                revisionResult.setSignatureField(pdSignatureField);
                revisionResult.setPdSignature(pdSignature);
                return true;
            }
            LOGGER.debug(REVISION_WITH_MULTIPLE_SIGS);
            throw new CoreException(REVISION_WITH_MULTIPLE_SIGS);
        }
        return false;
    }

    public static PDDocument load(RandomAccessRead signatureFile, TempDataManager tempDataManager) throws IOException {
        long memoryUsageSetting = PDFRevisionScanner.getMemoryUsageSetting();
        MemoryUsageSetting memUsageSetting = MemoryUsageSetting.setupMixed((long)memoryUsageSetting);
        if (signatureFile.length() >= memoryUsageSetting) {
            memUsageSetting.setTempDir(tempDataManager.createTempFolder("pdfbox_temp_data"));
        }
        ScratchFile scratchFile = new ScratchFile(memUsageSetting);
        tempDataManager.add((Closeable)scratchFile);
        PDFParser parser = new PDFParser(signatureFile, null, null, null, scratchFile);
        parser.parse();
        return parser.getPDDocument();
    }

    private static long getMemoryUsageSetting() {
        String maxMemory = System.getProperty("de.governikus.csl.pdf.max.memory");
        if (maxMemory != null) {
            try {
                return Long.parseLong(maxMemory);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Can't read max memory usage setting. Will use default value of 10MB", (Throwable)e);
            }
        }
        return 0xA00000L;
    }

    private void parseAndAddEmbeddedRevisions(PDDocument pdDocument, RevisionResult revisionResult, TempDataManager tempDataManager) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("--- #{}-{}: Loading attachments.", (Object)revisionResult.getRevisionStart(), (Object)revisionResult.getRevisionLength());
            }
            List<RevisionScannerResult> embeddedRevisions = this.parseEmbeddedRevisionsDump(pdDocument, tempDataManager);
            if (LOGGER.isDebugEnabled()) {
                if (embeddedRevisions == null || embeddedRevisions.isEmpty()) {
                    LOGGER.debug("--- #{}-{}: No attachments in revision.", (Object)revisionResult.getRevisionStart(), (Object)revisionResult.getRevisionLength());
                } else {
                    LOGGER.debug("--- #{}-{}: Loaded {} attachments in revision.", new Object[]{revisionResult.getRevisionStart(), revisionResult.getRevisionLength(), embeddedRevisions.size()});
                }
            }
            if (embeddedRevisions != null) {
                revisionResult.setEmbeddedRevisions(embeddedRevisions);
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("--- #{}-{}: Couldn't parse embedded revision.", new Object[]{revisionResult.getRevisionStart(), revisionResult.getRevisionLength(), ioe});
        }
    }

    private List<RevisionScannerResult> parseEmbeddedRevisionsDump(PDDocument doc, TempDataManager tempDataManager) throws IOException {
        ArrayList<RevisionScannerResult> result = null;
        PDDocumentNameDictionary namesDict = doc.getDocumentCatalog().getNames();
        if (namesDict == null) {
            return Collections.emptyList();
        }
        PDEmbeddedFilesNameTreeNode embeddedFiles = namesDict.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return Collections.emptyList();
        }
        Map names = embeddedFiles.getNames();
        if (names == null) {
            return Collections.emptyList();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Attachments found in dictionary({}): {}", (Object)names.size(), (Object)java.util.Arrays.toString(names.keySet().toArray()));
        }
        for (Map.Entry attachment : names.entrySet()) {
            RevisionScannerResult revision = this.parsePDComplexFileSpecification(attachment.getValue(), (String)attachment.getKey(), tempDataManager);
            if (revision == null) continue;
            if (result == null) {
                result = new ArrayList<RevisionScannerResult>();
            }
            result.add(revision);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private RevisionScannerResult parsePDComplexFileSpecification(Object object, String key, TempDataManager tempDataManager) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getSignatureHashcode(PDSignatureField field) {
        PDSignature signature = field.getSignature();
        COSDictionary dictionary = signature.getCOSObject();
        COSBase contents = dictionary.getItem(COSName.CONTENTS);
        return contents != null ? contents.hashCode() : -1;
    }

    private boolean isSignatureInRevision(List<RevisionResult> revisions, PDSignatureField field) {
        for (RevisionResult revisionResult : revisions) {
            PDSignatureField signatureField = revisionResult.getSignatureField();
            if (field == null || signatureField == null || this.getSignatureHashcode(signatureField) != this.getSignatureHashcode(field)) continue;
            return true;
        }
        return false;
    }

    private boolean isRevisionOfTypePDF(File file) throws IOException {
        int bytesToRead = 4;
        try (FileInputStream is = new FileInputStream(file);){
            byte[] data = new byte[bytesToRead];
            org.apache.commons.io.IOUtils.read((InputStream)is, (byte[])data, (int)0, (int)bytesToRead);
            boolean bl = Arrays.areEqual((byte[])data, (byte[])PAdESPlugin.getPDFMagicBytes());
            return bl;
        }
    }

    public static interface RandomAccessReadSupplier {
        public RandomAccessRead getRandomAccessRead() throws IOException;
    }
}

