/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccessRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedRandomAccessRead
implements RandomAccessRead {
    private static Logger LOGGER = LoggerFactory.getLogger(LimitedRandomAccessRead.class);
    private RandomAccessRead delegate;
    private long maxBytes;
    private int readAttempts;

    public LimitedRandomAccessRead(RandomAccessRead delegate, long maxBytes) {
        this(delegate, maxBytes, 1);
    }

    LimitedRandomAccessRead(RandomAccessRead delegate, long maxBytes, int readAttempts) {
        this.delegate = delegate;
        this.maxBytes = maxBytes;
        this.readAttempts = readAttempts;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public int read() throws IOException {
        if (this.delegate.getPosition() >= this.maxBytes) {
            return -1;
        }
        return this.delegate.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int remainingLen;
        long position = this.delegate.getPosition();
        if (position >= this.maxBytes) {
            return -1;
        }
        int len = Integer.min(length, (int)(this.maxBytes - position));
        int read = this.delegate.read(b, offset, len);
        int attemptsCtr = this.readAttempts;
        for (remainingLen = len - read; remainingLen > 0 && attemptsCtr-- >= 0; remainingLen -= read) {
            read += this.delegate.read(b, read, remainingLen);
        }
        if (remainingLen > 0) {
            LOGGER.error("Tried to read {} bytes but could not read last {} bytes", (Object)len, (Object)remainingLen);
        }
        return read;
    }

    public long getPosition() throws IOException {
        return this.delegate.getPosition();
    }

    public void seek(long position) throws IOException {
        if (position != 0L && position > this.maxBytes) {
            throw new IOException("The file is limited to " + this.maxBytes + " bytes. Can't seek to position " + position);
        }
        this.delegate.seek(position);
    }

    public long length() throws IOException {
        return Long.min(this.maxBytes, this.delegate.length());
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public int peek() throws IOException {
        if (this.delegate.getPosition() >= this.maxBytes) {
            return -1;
        }
        return this.delegate.peek();
    }

    public void rewind(int bytes) throws IOException {
        this.delegate.rewind(bytes);
    }

    public byte[] readFully(int length) throws IOException {
        byte[] b = new byte[length];
        int bytesRead = this.read(b);
        if (bytesRead < length) {
            throw new IOException("Couldn't read " + length + " bytes from file");
        }
        return b;
    }

    public boolean isEOF() throws IOException {
        int peek = this.peek();
        return peek == -1;
    }

    public int available() throws IOException {
        return Integer.min(this.delegate.available(), (int)(this.maxBytes - this.delegate.getPosition()));
    }
}

