/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccessRead;

class KMPPatternMatch {
    KMPPatternMatch() {
    }

    static long endIndexOf(RandomAccessRead raf, long start, byte[] pattern) throws IOException {
        raf.seek(start);
        int[] failure = KMPPatternMatch.computeFailure(pattern);
        int j = 0;
        for (long i = 0L; i < raf.length() - start; ++i) {
            byte dataI = (byte)raf.read();
            while (j > 0 && pattern[j] != dataI) {
                j = failure[j - 1];
            }
            if (pattern[j] == dataI) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i + 1L + start;
        }
        return -1L;
    }

    private static int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    public static long skipWhiteSpace(long offset, RandomAccessRead raf) throws IOException {
        byte readByte;
        long ffst;
        raf.seek(ffst);
        for (ffst = offset; raf.length() > ffst && ((readByte = (byte)raf.read()) == 0 || readByte == 9 || readByte == 10 || readByte == 12 || readByte == 13 || readByte == 32); ++ffst) {
        }
        return ffst;
    }
}

