/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.revision;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedReadRandomAccessFile
extends RandomAccessFile {
    static final int BUFFER_SIZE = 32768;
    byte[] buffer = new byte[32768];
    long bufferOffset = -1L;
    int bufferLength = -1;
    int bufferPosition = -1;
    long length;

    public BufferedReadRandomAccessFile(File file, String mode) throws IOException {
        super(file, mode);
        if (!"r".equals(mode)) {
            this.close();
            throw new IOException("only read supported!");
        }
        this.length = super.length();
        this.bufferSeek(0L);
    }

    public BufferedReadRandomAccessFile(String path, String mode) throws IOException {
        super(path, mode);
        if (!"r".equals(mode)) {
            this.close();
            throw new IOException("only read supported!");
        }
        this.length = super.length();
        this.bufferSeek(0L);
    }

    @Override
    public long getFilePointer() {
        return this.bufferOffset + (long)this.bufferPosition;
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.bufferSeek(pos);
    }

    private void bufferSeek(long seekOffset) throws IOException {
        long newOffset = seekOffset - (seekOffset & 0x7FFFL);
        if (newOffset == this.bufferOffset) {
            this.bufferPosition = (int)(seekOffset - this.bufferOffset);
            return;
        }
        this.bufferOffset = newOffset;
        this.bufferLength = (int)Math.min(32768L, this.length() - this.bufferOffset);
        if (this.bufferLength < 0) {
            this.bufferLength = 0;
        }
        this.bufferPosition = (int)(seekOffset - this.bufferOffset);
        super.seek(this.bufferOffset);
        super.readFully(this.buffer, 0, this.bufferLength);
    }

    @Override
    public final int read() throws IOException {
        if (this.bufferOffset + (long)this.bufferPosition >= this.length()) {
            throw new EOFException("EOF");
        }
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferSeek(this.bufferOffset + (long)this.bufferPosition);
        }
        return this.buffer[this.bufferPosition++] & 0xFF;
    }
}

