/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.functional;

import de.governikus.csl.pades.functional.WholeDocumentSignedCheck;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import java.util.Locale;
import java.util.ResourceBundle;

public class WholeDocumentSignedOrSecureChangesCheck
implements ResultInterpreter {
    public String getDescriptionMsgCode() {
        return "functional.test.wholeOrSecurePDF.signed.description";
    }

    public ValidationResult getInterpretedResult(ObjectValidationResult validationResult) {
        PAdESDocumentValidationResult padesResult;
        PAdESRevisionValidationResult lastSignedRevision;
        if (validationResult instanceof PAdESDocumentValidationResult && (lastSignedRevision = WholeDocumentSignedCheck.getLastSignedRevision(padesResult = (PAdESDocumentValidationResult)validationResult)) != null) {
            boolean wholeDocumentSigned = Boolean.TRUE.equals(lastSignedRevision.isWholeDocumentSigned());
            boolean lastHavingOnlySecureChanges = Boolean.TRUE.equals(lastSignedRevision.isLastHavingOnlySecureChanges());
            if (wholeDocumentSigned) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.whole"});
            }
            if (!wholeDocumentSigned && lastHavingOnlySecureChanges) {
                return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_PASSED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.secure"});
            }
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, null, (String[])new String[]{"functional.test.wholeOrSecurePDF.signed.neither"});
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null);
    }

    public ResourceBundle getResourceBundle(Locale l) {
        return ResourceBundle.getBundle("i18n.functional_validations", l);
    }

    public boolean useResourceBundleForMajorResult() {
        return true;
    }
}

