/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.functional;

import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.ObjectValidationResult;
import de.governikus.csl.uom.validate.ResultInterpreter;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class WholeDocumentSignedCheck
implements ResultInterpreter {
    public String getDescriptionMsgCode() {
        return "functional.test.wholePDF.signed.description";
    }

    public ValidationResult getInterpretedResult(ObjectValidationResult validationResult) {
        PAdESDocumentValidationResult padesResult;
        PAdESRevisionValidationResult lastSignedRevision;
        if (validationResult instanceof PAdESDocumentValidationResult && (lastSignedRevision = WholeDocumentSignedCheck.getLastSignedRevision(padesResult = (PAdESDocumentValidationResult)validationResult)) != null) {
            if (Boolean.TRUE.equals(lastSignedRevision.isWholeDocumentSigned())) {
                return SVPFactory.createResultOk();
            }
            return SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, null, (String[])new String[]{"functional.test.wholePDF.signed.failed"});
        }
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.NOT_VALIDATED, (MinorResult)null);
    }

    public static PAdESRevisionValidationResult getLastSignedRevision(PAdESDocumentValidationResult padesResult) {
        ObjectValidationResult objectValidationResult;
        SignatureValidationResult signatureValidationResult;
        if (padesResult == null) {
            return null;
        }
        List signatureValidationResults = padesResult.getSignatureValidationResults();
        if (signatureValidationResults != null && !signatureValidationResults.isEmpty() && (signatureValidationResult = (SignatureValidationResult)signatureValidationResults.get(signatureValidationResults.size() - 1)) instanceof PAdESRevisionValidationResult) {
            return (PAdESRevisionValidationResult)signatureValidationResult;
        }
        List resultsForContainedObjects = padesResult.getResultsForContainedObjects();
        if (resultsForContainedObjects != null && !resultsForContainedObjects.isEmpty() && (objectValidationResult = (ObjectValidationResult)resultsForContainedObjects.get(resultsForContainedObjects.size() - 1)) instanceof PAdESDocumentValidationResult) {
            return WholeDocumentSignedCheck.getLastSignedRevision((PAdESDocumentValidationResult)objectValidationResult);
        }
        return null;
    }

    public ResourceBundle getResourceBundle(Locale l) {
        return ResourceBundle.getBundle("i18n.functional_validations", l);
    }

    public boolean useResourceBundleForMajorResult() {
        return true;
    }
}

