/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.criteria;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.cms.CMSSignedData;
import de.governikus.csl.pades.PAdESDocumentTimestamp;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvelopedContentNotAllowed
extends AbstractValidationCriterion<PAdESSignature, PAdESRevisionValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvelopedContentNotAllowed.class);

    public void verify(PAdESSignature signature, PAdESRevisionValidationResult result, SignatureValidationContext context) {
        LOGGER.info("Checking PAdES-signature for enveloped content");
        try {
            byte[] signatureBytes = signature.getSignatureBytes();
            if (signatureBytes == null) {
                LOGGER.info("Check failed. No signature bytes found!");
                result.setEnvelopedContent(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE));
            } else {
                CMSSignedData cms = new CMSSignedData((Source)new BSource(signatureBytes));
                if (cms.hasEnvelopedContent()) {
                    LOGGER.warn("Check failed. Enveloped content found!");
                    result.setEnvelopedContent(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE));
                } else {
                    result.setEnvelopedContent(SVPFactory.createResultOk());
                }
            }
        }
        catch (ParseException e) {
            LOGGER.warn("Check failed.", (Throwable)e);
            return;
        }
    }

    public boolean isApplicable(PAdESSignature signature, PAdESRevisionValidationResult result, SignatureValidationContext context) {
        return !(signature instanceof PAdESDocumentTimestamp);
    }
}

