/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.criteria;

import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckWholeDocumentSigned
extends AbstractValidationCriterion<PAdESSignature, PAdESRevisionValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckWholeDocumentSigned.class);

    public void verify(PAdESSignature signature, PAdESRevisionValidationResult result, SignatureValidationContext context) {
        LOGGER.info("Checking if pades signature signs the whole document");
        int[] byteRange = signature.getByteRange();
        if (byteRange == null) {
            result.setWholeDocumentSigned(Boolean.valueOf(false));
            return;
        }
        if (byteRange.length == 4 && byteRange[0] == 0 && (long)(byteRange[2] + byteRange[3]) == signature.getDocumentSize()) {
            result.setWholeDocumentSigned(Boolean.valueOf(true));
            return;
        }
        result.setWholeDocumentSigned(Boolean.valueOf(false));
    }
}

