/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.criteria;

import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSecureChanges
extends AbstractValidationCriterion<PAdESSignature, PAdESRevisionValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckSecureChanges.class);

    public void verify(PAdESSignature signature, PAdESRevisionValidationResult result, SignatureValidationContext context) {
        LOGGER.info("Checking if last pades signature is not followed by revisions that change the signed document.");
        Boolean changesResult = signature.getLastHavingOnlySecureChanges();
        if (changesResult != null) {
            LOGGER.debug("Last revision only followed by secure changes: {}", (Object)changesResult);
            result.setLastHavingOnlySecureChanges(changesResult);
        }
    }
}

