/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades.criteria;

import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.AbstractValidationCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteRangeChecks
extends AbstractValidationCriterion<PAdESSignature, PAdESRevisionValidationResult, SignatureValidationContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteRangeChecks.class);

    public void verify(PAdESSignature signature, PAdESRevisionValidationResult result, SignatureValidationContext context) {
        LOGGER.info("Checking constraints on the byte range of the signed PDF");
        int[] byteRange = signature.getByteRange();
        if (byteRange == null) {
            result.setSignatureSizeCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE));
            return;
        }
        if (byteRange == null || byteRange.length != 4 || byteRange[0] != 0 || byteRange[1] <= 0 || byteRange[2] <= byteRange[1] || byteRange[3] <= 0) {
            result.setSignatureSizeCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"pades_potential_signature_bypassing_attack"}));
            return;
        }
        int byteRangeGapSize = (byteRange[2] - byteRange[1] - byteRange[0] - 1) / 2;
        byte[] signatureBytes = signature.getSignatureBytes();
        if (signatureBytes == null || signatureBytes.length == 0) {
            result.setSignatureSizeCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"pades_potential_signature_bypassing_attack"}));
            return;
        }
        if (byteRangeGapSize != signatureBytes.length) {
            result.setSignatureSizeCheck(SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE));
        } else {
            result.setSignatureSizeCheck(SVPFactory.createResultOk());
        }
    }
}

