/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades;

import de.governikus.csl.ades.AdESDataExtractor;
import de.governikus.csl.pades.PAdESDocument;
import de.governikus.csl.pades.PAdESDocumentDataExtractor;
import de.governikus.csl.pades.PAdESParser;
import de.governikus.csl.pades.PAdESRevision;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.ParseException;
import de.governikus.csl.pades.criteria.ByteRangeChecks;
import de.governikus.csl.pades.criteria.CheckSecureChanges;
import de.governikus.csl.pades.criteria.CheckWholeDocumentSigned;
import de.governikus.csl.pades.criteria.EnvelopedContentNotAllowed;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PluginType;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.ObjectToValidate;
import de.governikus.csl.utils.MagicBytes;
import de.governikus.csl.validate.svp.PAdESDocumentValidationResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validate.svp.ValidationResult;
import de.governikus.csl.validation.AbstractContainerDocumentPlugin;
import de.governikus.csl.validation.ValidatePlugin;
import de.governikus.csl.validation.ValidatePluginException;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.criteria.CheckSigningCertificateReferences;
import de.governikus.csl.validation.dataExtractor.DataExtractor;
import de.governikus.csl.validation.policy.ValidationPolicyType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;

@PluginType(id=Plugin.PluginID.VALIDATE_PADES, type=ValidatePlugin.class)
public class PAdESPlugin
extends AbstractContainerDocumentPlugin<PAdESDocument, PAdESSignature, PAdESDocumentValidationResult, PAdESRevisionValidationResult, SignatureValidationContext> {
    private static DataExtractor<? super PAdESDocument, ? super PAdESDocumentValidationResult> docDataExtractor;

    public PAdESPlugin() {
        super(PAdESSignature.class, SignatureValidationContext.class);
    }

    public PAdESDocument parseDocument(SignedData sda, TempDataManager tempDataManager) throws ValidatePluginException {
        try {
            if (!this.startsWithMagicBytes(sda.getSignature())) {
                throw new ValidatePluginException((ValidatePlugin)this, "Document cannot be parsed as an PDF message!");
            }
            PAdESParser padesParser = new PAdESParser(tempDataManager, this.configuration.getAlgorithmManager());
            return padesParser.loadDocument(sda);
        }
        catch (ParseException e) {
            String message = e.getMessage();
            if (message != null && message.contains("decrypt")) {
                return this.createEncryptionNotSupportedResult(sda);
            }
            throw this.createPluginException(e);
        }
        catch (IOException e) {
            throw this.createPluginException(e);
        }
    }

    private ValidatePluginException createPluginException(Exception e) {
        String message = e.getMessage();
        String errorMessage = "Can't parse document";
        if (message != null && !message.isEmpty()) {
            errorMessage = errorMessage + ": " + message;
        }
        return new ValidatePluginException((ValidatePlugin)this, errorMessage, (Throwable)e);
    }

    private PAdESDocument createEncryptionNotSupportedResult(SignedData doc) {
        PAdESDocument result = new PAdESDocument();
        ValidationResult parserResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"pades_encrypted_not_supported"});
        PAdESSignature pAdESSignature = new PAdESSignature();
        pAdESSignature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)parserResult);
        result.setSignatures(Collections.singletonList(pAdESSignature));
        result.setContainedObjectsToValidate(Collections.emptyList());
        result.setRevisions(Collections.emptyList());
        result.setName(doc.getSignature().getName());
        return result;
    }

    protected PAdESDocumentValidationResult createResultStructure(ObjectToValidate<?> objectToValidate) {
        PAdESDocumentValidationResult res = new PAdESDocumentValidationResult();
        res.setObjectTypeID(Plugin.PluginID.VALIDATE_PADES.getID());
        res.setRevisionResult(objectToValidate instanceof PAdESRevision);
        return res;
    }

    protected PAdESRevisionValidationResult createSignatureValidationResultStructure() {
        return new PAdESRevisionValidationResult();
    }

    public SignatureValidationContext createContext(PAdESSignature signature, ValidationPolicyType policy) {
        return new SignatureValidationContext(policy);
    }

    public MagicBytes getMagicBytesOfDocumentFormat() {
        return MagicBytes.MAGIC_BYTES_PDF;
    }

    public static byte[] getPDFMagicBytes() {
        return MagicBytes.MAGIC_BYTES_PDF.getBytes();
    }

    public static List<ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>> getAllKnownCustomPlugins() {
        ArrayList<ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>> result = new ArrayList<ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>>();
        result.add((ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>)new ByteRangeChecks());
        result.add((ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>)new EnvelopedContentNotAllowed());
        result.add((ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>)new CheckWholeDocumentSigned());
        result.add((ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>)new CheckSecureChanges());
        result.add((ValidationCriterion<? super PAdESSignature, ? super PAdESRevisionValidationResult, ? super SignatureValidationContext>)new CheckSigningCertificateReferences());
        return result;
    }

    public synchronized DataExtractor<? super PAdESDocument, ? super PAdESDocumentValidationResult> getDocumentDataExtractor() {
        if (docDataExtractor == null) {
            docDataExtractor = new PAdESDocumentDataExtractor();
        }
        return docDataExtractor;
    }

    public DataExtractor<? super PAdESSignature, ? super PAdESRevisionValidationResult> getSignatureDataExtractor() {
        return new AdESDataExtractor();
    }

    private boolean startsWithMagicBytes(Document doc) throws IOException {
        int bytesToRead = this.getMagicBytesOfDocumentFormat().getBytes().length;
        if (doc == null) {
            throw new IOException("SignedData does not contain a signature document!");
        }
        try (InputStream is = doc.getInputStream();){
            if (is == null) {
                throw new IOException("Cannot get input data for signature document '" + doc.getName() + "' with id '" + doc.getId() + "'!");
            }
            byte[] data = new byte[bytesToRead];
            IOUtils.read((InputStream)is, (byte[])data, (int)0, (int)bytesToRead);
            boolean bl = Arrays.equals(data, this.getMagicBytesOfDocumentFormat().getBytes());
            return bl;
        }
    }
}

