/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades;

import de.governikus.csl.pades.DocumentSecurityStore;
import de.governikus.csl.pades.PAdESAttachmentParser;
import de.governikus.csl.pades.PAdESContainer;
import de.governikus.csl.pades.PAdESDocument;
import de.governikus.csl.pades.PAdESDocumentTimestamp;
import de.governikus.csl.pades.PAdESRevision;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.ParseException;
import de.governikus.csl.pades.functional.ShadowUtil;
import de.governikus.csl.pades.revision.PDFRevisionScanner;
import de.governikus.csl.pades.revision.RevisionResult;
import de.governikus.csl.pades.revision.RevisionScannerResult;
import de.governikus.csl.pades.verification.ADBE_PKCS7DetachedParser;
import de.governikus.csl.pades.verification.ADBE_PKCS7Sha1Parser;
import de.governikus.csl.pades.verification.ADBE_X509RsaSha1;
import de.governikus.csl.pades.verification.ETSI_CAdESDetachedParser;
import de.governikus.csl.pades.verification.ETSI_RFC3161Parser;
import de.governikus.csl.pades.verification.PDFSignatureParser;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.LogHelper;
import de.governikus.csl.uom.SignedData;
import de.governikus.csl.uom.core.impl.SimpleSignedData;
import de.governikus.csl.uom.util.TempDataManager;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.utils.AbstractDocumentParser;
import de.governikus.csl.validate.svp.ValidationResult;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESParser
extends AbstractDocumentParser<PAdESDocument> {
    private static final List<PDFSignatureParser> SIGNATURE_PARSER = new ArrayList<PDFSignatureParser>();
    private static final Logger LOGGER = LoggerFactory.getLogger(PAdESParser.class);
    private TempDataManager tempDataManager;
    private AlgorithmManager algorithmManager;
    private boolean isVulnerable = false;
    private DocumentSecurityStore documentSecurityStore;

    public PAdESParser(TempDataManager tempDataManager, AlgorithmManager algorithmManager) {
        this.tempDataManager = tempDataManager;
        this.algorithmManager = algorithmManager;
    }

    public PAdESDocument loadDocument(SignedData sda) throws ParseException {
        Document signedDocument = sda.getSignature();
        PAdESDocument result = new PAdESDocument();
        RevisionScannerResult pdfRevisionResult = this.parseRevisions(signedDocument);
        if (pdfRevisionResult == null) {
            throw new ParseException(true);
        }
        List<RevisionResult> pdfRevisions = pdfRevisionResult.getRevisions();
        if (pdfRevisions == null || pdfRevisions.isEmpty()) {
            throw new ParseException(true);
        }
        this.isVulnerable = ShadowUtil.isVulnerable(pdfRevisionResult);
        try {
            this.processRevisions(pdfRevisions, signedDocument, result);
        }
        catch (Exception e) {
            ValidationResult parserResult = SVPFactory.create((MajorTotalResult)MajorTotalResult.TOTAL_FAILED, (MinorResult)MinorResult.FORMAT_FAILURE, (String[])new String[]{"pades_general_parse_error"});
            PAdESSignature pAdESSignature = new PAdESSignature();
            pAdESSignature.setParseError((de.governikus.csl.uom.validate.commons.ValidationResult)parserResult);
            result.setSignatures(Collections.singletonList(pAdESSignature));
            result.setRevisions(Collections.emptyList());
            result.setName(signedDocument.getName());
        }
        return result;
    }

    private RevisionScannerResult parseRevisions(Document signedDocument) throws ParseException {
        PDFRevisionScanner pdfRevisionScanner = new PDFRevisionScanner();
        try {
            RevisionScannerResult revisionScannerResult = pdfRevisionScanner.getRevisions(signedDocument, this.tempDataManager);
            Exception decryptExecption = pdfRevisionScanner.getDecryptExecption();
            if (decryptExecption != null && revisionScannerResult.getRevisions().isEmpty()) {
                throw new ParseException(false, decryptExecption);
            }
            return revisionScannerResult;
        }
        catch (Exception e) {
            throw new ParseException(true, e);
        }
    }

    private void processRevisions(List<RevisionResult> pdfRevisions, Document signedDocument, PAdESDocument result) throws Exception {
        ArrayList<PAdESContainer> revisions = new ArrayList<PAdESContainer>();
        int revisionCtr = 1;
        RevisionResult lastSignedPAdESRevision = ShadowUtil.getLastSignedPAdESRevision(pdfRevisions);
        RevisionResult lastRevision = pdfRevisions.get(pdfRevisions.size() - 1);
        long documentSize = lastRevision.getRevisionStart() + lastRevision.getRevisionLength();
        for (RevisionResult revisionResult : pdfRevisions) {
            boolean b = this.isVulnerable && revisionResult.equals(lastSignedPAdESRevision);
            revisionCtr = this.loadRevision(signedDocument, revisions, revisionCtr, revisionResult, documentSize, b);
        }
        PAdESContainer last = null;
        boolean hasAttachments = this.documentSecurityStore != null;
        for (int i = revisions.size() - 1; i >= 0; --i) {
            PAdESContainer revision = (PAdESContainer)revisions.get(i);
            if (hasAttachments) {
                this.documentSecurityStore.addSignatureAttributes(revision);
            }
            if (last != null) {
                last.setContainedObjectsToValidate(Collections.singletonList(revision));
            } else {
                result.setContainedObjectsToValidate(Collections.singletonList(revision));
            }
            last = revision;
        }
        result.setName(signedDocument.getName());
        result.setRevisions(pdfRevisions);
        if (this.documentSecurityStore != null) {
            this.documentSecurityStore.insertAttachments(revisions);
            LOGGER.debug("Finished processing revisions. DocumentSecurityStore contain {} certificates, {} OCSPs and {} CRLs.", new Object[]{this.documentSecurityStore.getDssCerts().size(), this.documentSecurityStore.getDssOCSPs().size(), this.documentSecurityStore.getDssCRLs().size()});
        } else {
            LOGGER.debug("No DocumentSecurityStore available.");
        }
    }

    private int loadRevision(Document signedDocument, List<PAdESContainer> revisions, int revisionCtr, RevisionResult revisionResult, long documentSize, boolean isVulnerable) throws Exception {
        PDDocument doc = revisionResult.getRevisionDocument();
        PDDocumentCatalog documentCatalog = doc.getDocumentCatalog();
        this.readValidationData(documentCatalog);
        PAdESSignature padesSignature = null;
        PAdESRevision revision = null;
        PDSignature sig = revisionResult.getPdSignature();
        if (sig != null) {
            for (PDFSignatureParser parser : SIGNATURE_PARSER) {
                if (!parser.canHandle(sig)) continue;
                padesSignature = parser.parseSignature(revisionResult, signedDocument, this.tempDataManager, this.algorithmManager);
                if (padesSignature instanceof PAdESDocumentTimestamp) {
                    PAdESDocumentTimestamp timestamp = (PAdESDocumentTimestamp)padesSignature;
                    this.appendTimestampToRevisions(timestamp, revisions);
                    if (revisions.isEmpty()) {
                        revision = new PAdESRevision();
                        revision.setSignatures(Collections.singletonList(timestamp));
                        revisions.add(revision);
                    }
                } else {
                    revision = new PAdESRevision();
                    revision.setSignatures(Collections.singletonList(padesSignature));
                    revisions.add(revision);
                    revision.setPdSignature(sig);
                }
                padesSignature.setDocumentSize(documentSize);
                Boolean onlySecureChanges = revisionResult.getLastSignedHavingOnlySecureChanges();
                if (onlySecureChanges == null) break;
                padesSignature.setLastHavingOnlySecureChanges(onlySecureChanges);
                break;
            }
        }
        if (revision == null) {
            revision = new PAdESRevision();
            revisions.add(revision);
        }
        revision.setRevisionNr(revisionCtr);
        revision.setName(this.createName(signedDocument.getName(), revisionCtr));
        this.loadIncludedFiles(documentCatalog, revision);
        this.parseEmbeddedRevisions(revision, revisionResult.getEmbeddedRevisions());
        revision.setVulnerable(isVulnerable);
        doc.close();
        return ++revisionCtr;
    }

    private void readValidationData(PDDocumentCatalog documentCatalog) {
        COSDictionary catalogDictionary = documentCatalog.getCOSObject();
        COSDictionary dssDictionary = (COSDictionary)catalogDictionary.getDictionaryObject("DSS");
        DocumentSecurityStore tmp = PAdESAttachmentParser.readDss(dssDictionary);
        if (tmp != null) {
            if (this.documentSecurityStore == null) {
                LOGGER.debug("Initialize DocumentSecurityStore with {} certificates, {} OCSPs and {} CRLs.", new Object[]{tmp.getDssCerts().size(), tmp.getDssOCSPs().size(), tmp.getDssCRLs().size()});
                this.documentSecurityStore = tmp;
            } else {
                this.documentSecurityStore.add(tmp);
            }
        }
    }

    private void loadIncludedFiles(PDDocumentCatalog documentCatalog, PAdESRevision revision) throws IOException {
        PDDocumentNameDictionary names = documentCatalog.getNames();
        if (names == null) {
            return;
        }
        PDEmbeddedFilesNameTreeNode embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            return;
        }
        Map names2 = embeddedFiles.getNames();
        if (names2 == null) {
            return;
        }
        for (Map.Entry entry : names2.entrySet()) {
            PDComplexFileSpecification file = (PDComplexFileSpecification)entry.getValue();
            PDEmbeddedFile embeddedFile = file.getEmbeddedFile();
            COSStream cosStream = embeddedFile.getCOSObject();
            Document embeddedDocument = this.copyToDisc(cosStream, file.getFile());
            ArrayList<Document> includedFilesToValidate = revision.getIncludedFilesToValidate();
            if (includedFilesToValidate == null) {
                includedFilesToValidate = new ArrayList<Document>();
                revision.setIncludedFilesToValidate(includedFilesToValidate);
            }
            includedFilesToValidate.add(embeddedDocument);
        }
    }

    private void parseEmbeddedRevisions(PAdESRevision revision, List<RevisionScannerResult> embeddedRevisions) {
        if (embeddedRevisions != null) {
            ArrayList<PAdESDocument> embeddedDocuments = new ArrayList<PAdESDocument>();
            for (RevisionScannerResult rsr : embeddedRevisions) {
                Document document = rsr.getDocument();
                SimpleSignedData embeddedData = new SimpleSignedData((Document)null, document);
                try {
                    PAdESDocument embeddedDocument = this.loadDocument((SignedData)embeddedData);
                    boolean isIncludedFile = false;
                    for (Document d : revision.getIncludedFilesToValidate()) {
                        if (!d.getName().equals(embeddedDocument.getName())) continue;
                        isIncludedFile = true;
                        break;
                    }
                    if (embeddedDocument == null || isIncludedFile) continue;
                    embeddedDocuments.add(embeddedDocument);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not load embedded document.", (Throwable)e);
                }
            }
            if (!embeddedDocuments.isEmpty()) {
                revision.setContainedObjectsToValidate(embeddedDocuments);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Document copyToDisc(COSStream cosStream, String filename) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String createName(String baseName, int index) {
        StringBuilder sb = new StringBuilder();
        int lastIndexOf = baseName.lastIndexOf(46);
        if (lastIndexOf > 0) {
            sb.append(baseName.substring(0, lastIndexOf));
            sb.append("_Revision");
            sb.append(index);
            sb.append(baseName.substring(lastIndexOf));
        } else {
            sb.append(baseName);
            sb.append("_Revision");
            sb.append(index);
        }
        return sb.toString();
    }

    private void appendTimestampToRevisions(PAdESDocumentTimestamp timestamp, List<PAdESContainer> revisions) {
        for (PAdESContainer revision : revisions) {
            this.appendTimestampToRevision(timestamp, revision);
        }
    }

    private void appendTimestampToRevision(PAdESDocumentTimestamp timestamp, PAdESContainer revision) {
        if (timestamp == null || revision == null) {
            return;
        }
        List signatures = revision.getSignatures();
        if (signatures == null) {
            return;
        }
        for (PAdESSignature sig : signatures) {
            this.appendTimestampsToSignature(sig, timestamp, revision);
        }
    }

    public void appendTimestampsToSignature(PAdESSignature sig, PAdESDocumentTimestamp timestamp, PAdESContainer revision) {
        ArrayList<PAdESDocumentTimestamp> signatureTimestamps = sig.getArchiveTimestamps();
        if (signatureTimestamps == null) {
            signatureTimestamps = new ArrayList<PAdESDocumentTimestamp>();
            sig.setArchiveTimestamps(signatureTimestamps);
        }
        signatureTimestamps.add(timestamp);
        List<PAdESContainer> embeddedDocuments = revision.getContainedObjectsToValidate();
        if (embeddedDocuments != null) {
            for (PAdESContainer embeddedDocument : embeddedDocuments) {
                List<PAdESContainer> revisions = embeddedDocument.getContainedObjectsToValidate();
                if (revisions == null) continue;
                for (PAdESContainer pr : revisions) {
                    this.appendTimestampToRevision(timestamp, pr);
                }
            }
        }
    }

    static {
        try {
            SIGNATURE_PARSER.add(new ETSI_CAdESDetachedParser());
            SIGNATURE_PARSER.add(new ETSI_RFC3161Parser());
            SIGNATURE_PARSER.add(new ADBE_PKCS7DetachedParser());
            SIGNATURE_PARSER.add(new ADBE_PKCS7Sha1Parser());
            SIGNATURE_PARSER.add(new ADBE_X509RsaSha1());
        }
        catch (NoSuchProviderException | CertificateException e) {
            LogHelper.fatal((String)"Can't instantiate pdf signature parsers", (Exception)e, (Logger)LOGGER);
        }
    }
}

