/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.asn1.cms.AtsHashIndex;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.validate.commons.Signature;
import de.governikus.csl.uom.validate.commons.SignatureClass;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.Timestamp;
import de.governikus.csl.uom.validate.commons.WritableTimestamp;
import de.governikus.csl.validate.svp.TimestampValidationResult;
import de.governikus.csl.validation.ValidationCriterion;
import de.governikus.csl.validation.context.SignatureValidationContext;
import de.governikus.csl.validation.tsp.ArchiveTimestamp;
import java.math.BigInteger;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.cert.ocsp.OCSPResp;

public class PAdESDocumentTimestamp
extends PAdESSignature
implements WritableTimestamp<PAdESSignature>,
ArchiveTimestamp {
    private byte[] messageImprint;
    private DigestAlgorithm messageImprintHashAlgorithm;
    private Long accuracy;
    private Boolean ordering;
    private Date generationTime;
    private byte[] timestampedData;
    private byte[] timestampedContentHash;
    private boolean EUQCStatement;
    private List<AtsHashIndex> atsHashIndizes;
    private BigInteger serial;

    public byte[] getMessageImprint() {
        return this.messageImprint;
    }

    public void setMessageImprint(byte[] messageImprint) {
        this.messageImprint = messageImprint;
    }

    public DigestAlgorithm getMessageImprintHashAlgorithm() {
        return this.messageImprintHashAlgorithm;
    }

    public void setMessageImprintHashAlgorithm(DigestAlgorithm messageImprintHashAlgorithm) {
        this.messageImprintHashAlgorithm = messageImprintHashAlgorithm;
    }

    public StreamProvider getTimestampedContent() {
        return new ByteArrayStreamProvider(this.timestampedData);
    }

    public void setTimestampedContent(StreamProvider timestampedContent) {
    }

    public Boolean getOrdering() {
        return this.ordering;
    }

    public void setOrdering(Boolean ordering) {
        this.ordering = ordering;
    }

    public Long getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Long accuracy) {
        this.accuracy = accuracy;
    }

    public Date getGenerationTime() {
        return this.generationTime;
    }

    public void setGenerationTime(Date generationTime) {
        this.generationTime = generationTime;
    }

    public byte[] getTimestampedData() {
        return this.timestampedData;
    }

    public void setTimestampedData(byte[] timestampedData) {
        this.timestampedData = timestampedData;
    }

    public boolean hasEUQCStatement() {
        return this.EUQCStatement;
    }

    public void setEUQCStatement(boolean eUQCStatement) {
        this.EUQCStatement = eUQCStatement;
    }

    public List<AtsHashIndex> getAtsHashIndizes() {
        return this.atsHashIndizes;
    }

    public void setAtsHashIndizes(List<AtsHashIndex> atsHashIndizes) {
        this.atsHashIndizes = atsHashIndizes;
    }

    public byte[] getTimestampedContentHash() {
        return this.timestampedContentHash;
    }

    public void setTimestampedContentHash(byte[] timestampedContentHash) {
        this.timestampedContentHash = timestampedContentHash;
    }

    public boolean isProtectedBy(ArchiveTimestamp next) {
        if (!PAdESDocumentTimestamp.class.isInstance(next)) {
            return false;
        }
        PAdESDocumentTimestamp other = (PAdESDocumentTimestamp)((Object)PAdESDocumentTimestamp.class.cast(next));
        int[] otherByteRange = other.getByteRange();
        int[] byteRange = this.getByteRange();
        int from = byteRange[0];
        int to = byteRange[2] + byteRange[3];
        return otherByteRange[0] <= from && otherByteRange[0] + otherByteRange[1] >= to;
    }

    public boolean isSignatureTimestampProtected(Timestamp signatureTimestamp, Signature signature) {
        if (!PAdESSignature.class.isInstance(signature)) {
            return false;
        }
        PAdESSignature sig = (PAdESSignature)((Object)PAdESSignature.class.cast(signature));
        int[] sigByteRange = sig.getByteRange();
        int[] byteRange = this.getByteRange();
        int from = sigByteRange[0];
        int to = sigByteRange[2] + sigByteRange[3];
        return byteRange[0] <= from && byteRange[0] + byteRange[1] >= to;
    }

    public List<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>> getCustomPlugins() {
        ArrayList<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>> result = new ArrayList<ValidationCriterion<? super Timestamp, ? super TimestampValidationResult, ? super SignatureValidationContext>>();
        return result;
    }

    public BigInteger getSerial() {
        return this.serial;
    }

    public void setSerial(BigInteger serial) {
        this.serial = serial;
    }

    public boolean isOCSPValueProtected(SignatureValidationDataAttachment<OCSPResp> attachedOCSP) {
        return false;
    }

    public boolean isCRLProtected(SignatureValidationDataAttachment<CRL> attachedCRL) {
        return false;
    }

    public boolean isCertProtected(SignatureValidationDataAttachment<X509Certificate> attachedCert) {
        return false;
    }

    public SignatureClass getSignatureClass() {
        return SignatureClass.SIG_DTS;
    }
}

