/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.cms.CertificateSet;
import de.bos_bremen.ci.asn1.cms.ContentType;
import de.bos_bremen.ci.asn1.cms.SignedAttribute;
import de.bos_bremen.ci.asn1.cms.SignedAttributes;
import de.bos_bremen.ci.asn1.cms.SignedData;
import de.bos_bremen.ci.asn1.cms.SignerInfo;
import de.bos_bremen.ci.asn1.cms.UnsignedAttributes;
import de.bos_bremen.ci.asn1.tsp.SignatureTimeStampToken;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.governikus.csl.core.impl.BaseSignedContentPart;
import de.governikus.csl.pades.PAdESValidationData;
import de.governikus.csl.pades.verification.COSFilterDocument;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.uom.docs.ByteArrayDocument;
import de.governikus.csl.uom.impl.ByteArrayStreamProvider;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.commons.AlgorithmManager;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.uom.validate.commons.SignedContentPart;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validation.tsp.TSPParser;
import de.governikus.csl.validation.tsp.TimestampedObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESCMSUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PAdESCMSUtil.class);
    private static CertificateFactory certificateFactory;

    private PAdESCMSUtil() {
    }

    public static List<TimestampedObject> parseSignatureTimestamps(SignerInfo signerInfo, AlgorithmManager algorithmManager) {
        List<TimestampedObject> timestamps = PAdESCMSUtil.parseTimestamps(signerInfo, ContentType.id_aa_timeStampToken, algorithmManager);
        if (timestamps != null) {
            for (TimestampedObject to : timestamps) {
                ByteArrayStreamProvider bais = new ByteArrayStreamProvider(signerInfo.getSignature().getOctets());
                to.setTimestampedContent((StreamProvider)bais);
            }
        }
        return timestamps;
    }

    public static List<TimestampedObject> parseContentTimestamps(SignerInfo signerInfo, int[] byteRange, Document document, AlgorithmManager algorithmManager) throws IOException {
        List<TimestampedObject> timestamps = PAdESCMSUtil.parseTimestamps(signerInfo, ContentType.id_aa_content_timeStampToken, algorithmManager);
        if (timestamps != null) {
            for (TimestampedObject to : timestamps) {
                Document signedContent = PAdESCMSUtil.getSignedContent(document, byteRange);
                to.setTimestampedContent((StreamProvider)signedContent);
            }
        }
        return timestamps;
    }

    public static Document getSignedContent(Document document, int[] byteRange) {
        return new COSFilterDocument(document, byteRange);
    }

    public static Document getSignedAttributeStream(SignerInfo signerInfo) {
        if (signerInfo.getSignedAttributes() == null) {
            return null;
        }
        byte[] bytes = signerInfo.getSignedAttributes().asByteArray();
        if (bytes.length > 0 && signerInfo.getSignedAttributes().isImplicit()) {
            bytes[0] = 49;
        }
        return new ByteArrayDocument(bytes);
    }

    public static List<SignedContentPart> getSignedContentParts(SignerInfo signerInfo, Document document, int[] byteRange, AlgorithmManager algorithmManager) {
        ArrayList<SignedContentPart> parts = new ArrayList<SignedContentPart>();
        DigestAlgorithm digestAlgorithm = PAdESCMSUtil.getDigestAlgorithm(signerInfo, algorithmManager);
        byte[] digest = null;
        SignedAttributes signedAttributes = signerInfo.getSignedAttributes();
        if (signedAttributes != null) {
            OCTETSTRING os = (OCTETSTRING)signedAttributes.getValue(SignedAttribute.messageDigest);
            digest = os.getOctets();
        }
        Document signedContent = PAdESCMSUtil.getSignedContent(document, byteRange);
        parts.add((SignedContentPart)new BaseSignedContentPart((StreamProvider)signedContent, digest, digestAlgorithm));
        return parts;
    }

    public static Date getSigningTime(PDSignature signature, SignerInfo signerInfo) {
        if (signerInfo.getSignedAttributes() == null) {
            return PAdESCMSUtil.getSigningTime(signature);
        }
        Time time = (Time)signerInfo.getSignedAttributeValue(SignedAttribute.signingTime);
        if (time != null) {
            return time.getDate();
        }
        return PAdESCMSUtil.getSigningTime(signature);
    }

    public static Date getSigningTime(PDSignature signature) {
        Calendar signDate = signature.getSignDate();
        if (signDate != null) {
            return signDate.getTime();
        }
        return null;
    }

    public static SignatureAlgorithm getSignatureAlgorithm(SignerInfo signerInfo, AlgorithmManager algorithmManager) {
        try {
            return PAdESCMSUtil.getSignatureAlgorithm(signerInfo.getSignatureAlgorithm(), algorithmManager);
        }
        catch (ParseException | NoSuchAlgorithmException e) {
            LOGGER.warn("Can't get signature algorithm", e);
            return null;
        }
    }

    public static DigestAlgorithm getDigestAlgorithm(SignerInfo signerInfo, AlgorithmManager algorithmManager) {
        return PAdESCMSUtil.getDigestAlgorithm(signerInfo.getDigestAlgorithm(), algorithmManager);
    }

    public static Set<SignatureValidationDataAttachment<X509Certificate>> getCertificates(SignerInfo signerInfo, SignedData signedData) {
        return Optional.ofNullable(signedData.getCertificates()).map(CertificateSet::getCertificateChoices).orElse(Collections.emptyList()).stream().map(PAdESCMSUtil::toX509Certificate).map(PAdESValidationData::new).collect(Collectors.toSet());
    }

    public static X509CertificateImpl getSigningCertificate(SignerInfo signerInfo, SignedData signedData) {
        return Optional.ofNullable(signedData.getCertificates()).map(s -> s.getMatchingCertificates(signerInfo.getSignerIdentifier())).map(Collection::stream).flatMap(Stream::findFirst).map(PAdESCMSUtil::toX509Certificate).map(X509CertificateImpl::new).orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static X509Certificate toX509Certificate(FlatCertificate fc) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(fc.getEncoded());){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(bais);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            LOGGER.error("Can't parse certificate", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static SignatureAlgorithm getSignatureAlgorithm(AlgorithmIdentifier algorithm, AlgorithmManager algorithmManager) {
        if (algorithm == null) {
            return null;
        }
        String jcaName = algorithm.getJCAName();
        String oid = null;
        OBJECTIDENTIFIER aoid = algorithm.getOID();
        if (aoid != null) {
            oid = aoid.getOID();
        }
        return algorithmManager.getSignatureAlgorithmByJcaOidOrUrl(jcaName, oid, null);
    }

    public static DigestAlgorithm getDigestAlgorithm(AlgorithmIdentifier algorithm, AlgorithmManager algorithmManager) {
        if (algorithm == null) {
            return null;
        }
        String jcaName = algorithm.getJCAName();
        String oid = null;
        OBJECTIDENTIFIER aoid = algorithm.getOID();
        if (aoid != null) {
            oid = aoid.getOID();
        }
        return algorithmManager.getDigestAlgorithmByJcaOidOrUrl(jcaName, oid, null);
    }

    public static List<TimestampedObject> parseTimestamps(SignerInfo signerInfo, OBJECTIDENTIFIER timestampType, AlgorithmManager algorithmManager) {
        ANY timestampToken;
        UnsignedAttributes unsignedAttributes = signerInfo.getUnsignedAttributes();
        if (unsignedAttributes != null && (timestampToken = unsignedAttributes.getValue(timestampType)) instanceof SignatureTimeStampToken) {
            SignatureTimeStampToken stst = (SignatureTimeStampToken)timestampToken;
            TSPParser parser = new TSPParser(algorithmManager);
            return parser.parse(stst.getSignedData(), null);
        }
        return null;
    }

    public static Set<AttributeCertificate> getAttributeCertificates(SignerInfo signerInfo) {
        List values;
        SignedAttributes signedAttributes = signerInfo.getSignedAttributes();
        LinkedHashSet<AttributeCertificate> attributeCertSet = new LinkedHashSet<AttributeCertificate>();
        if (signedAttributes != null && (values = signedAttributes.getValues(SignedAttribute.attributeCertificate)) != null) {
            for (ANY attributeCert : values) {
                AttributeCertificate bcAttributeCert = AttributeCertificate.getInstance((Object)attributeCert.getEncoded());
                attributeCertSet.add(bcAttributeCert);
            }
        }
        return attributeCertSet;
    }

    static {
        try {
            certificateFactory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X.509");
        }
        catch (NoSuchProviderException | CertificateException e) {
            LOGGER.error("Cannot create x509 certificate factory", (Throwable)e);
        }
    }
}

