/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades;

import de.governikus.csl.pades.DocumentSecurityStore;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.PAdESValidationData;
import de.governikus.csl.pades.ValidationRelatedInfo;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import de.governikus.csl.utils.CollectionUtil;
import de.governikus.csl.utils.CryptoProviderUtil;
import de.governikus.csl.validate.svp.AttributeBaseType;
import de.governikus.csl.validate.svp.DSSType;
import de.governikus.csl.validate.svp.ObjectFactory;
import de.governikus.csl.validate.svp.VRIType;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.bind.JAXBElement;
import org.apache.commons.codec.binary.Base16;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAdESAttachmentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PAdESAttachmentParser.class);
    private static final ObjectFactory svpFactory = new ObjectFactory();

    private PAdESAttachmentParser() {
    }

    private static <A, T extends Collection<SignatureValidationDataAttachment<A>>> void setIfNotNullAndNotEmpty(Consumer<T> setter, T add) {
        if (add != null && !add.isEmpty()) {
            setter.accept(add);
        }
    }

    public static DocumentSecurityStore readDss(COSDictionary dssDict) {
        if (dssDict == null) {
            return null;
        }
        Set<SignatureValidationDataAttachment<X509Certificate>> dssCerts = PAdESAttachmentParser.readAttachedCertificates(dssDict, "Certs");
        Set<SignatureValidationDataAttachment<OCSPResp>> dssOCSPs = PAdESAttachmentParser.readAttachedOCSPs(dssDict, "OCSPs");
        Set<SignatureValidationDataAttachment<CRL>> dssCRLs = PAdESAttachmentParser.readAttachedCRLs(dssDict, "CRLs");
        List<ValidationRelatedInfo> vris = null;
        try {
            vris = PAdESAttachmentParser.readValidationRelatedInfos(dssDict);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse VRI", (Throwable)e);
        }
        if (CollectionUtil.isNotEmpty(dssCerts) || CollectionUtil.isNotEmpty(dssOCSPs) || CollectionUtil.isNotEmpty(dssCRLs) || CollectionUtil.isNotEmpty(vris)) {
            DocumentSecurityStore parsedDss = new DocumentSecurityStore();
            PAdESAttachmentParser.setIfNotNullAndNotEmpty(parsedDss::setDssCerts, dssCerts);
            PAdESAttachmentParser.setIfNotNullAndNotEmpty(parsedDss::setDssOCSPs, dssOCSPs);
            PAdESAttachmentParser.setIfNotNullAndNotEmpty(parsedDss::setDssCRLs, dssCRLs);
            if (CollectionUtil.isNotEmpty(vris)) {
                for (ValidationRelatedInfo vri : vris) {
                    parsedDss.getValidationRelatedInfoMap().put(vri.getSigB16EncSha1Hash(), vri);
                }
            }
            return parsedDss;
        }
        return null;
    }

    private static List<ValidationRelatedInfo> readValidationRelatedInfos(COSDictionary dssDict) {
        ArrayList<ValidationRelatedInfo> parsedVris = new ArrayList<ValidationRelatedInfo>();
        COSDictionary vriDictOfVriDicts = dssDict.getCOSDictionary(COSName.getPDFName((String)"VRI"));
        if (vriDictOfVriDicts != null) {
            for (COSName vriSignatureKey : vriDictOfVriDicts.keySet()) {
                String sigB16EncSha1Hash = vriSignatureKey.getName();
                COSDictionary vriDict = vriDictOfVriDicts.getCOSDictionary(COSName.getPDFName((String)sigB16EncSha1Hash));
                if (vriDict == null) continue;
                Set<SignatureValidationDataAttachment<X509Certificate>> vriCerts = PAdESAttachmentParser.readAttachedCertificates(vriDict, "Cert");
                Set<SignatureValidationDataAttachment<OCSPResp>> vriOCSPs = PAdESAttachmentParser.readAttachedOCSPs(vriDict, "OCSP");
                Set<SignatureValidationDataAttachment<CRL>> vriCRLs = PAdESAttachmentParser.readAttachedCRLs(vriDict, "CRL");
                ValidationRelatedInfo parsedVri = new ValidationRelatedInfo(sigB16EncSha1Hash);
                PAdESAttachmentParser.setIfNotNullAndNotEmpty(parsedVri::setVriCerts, vriCerts);
                PAdESAttachmentParser.setIfNotNullAndNotEmpty(parsedVri::setVriOCSPs, vriOCSPs);
                PAdESAttachmentParser.setIfNotNullAndNotEmpty(parsedVri::setVriCRLs, vriCRLs);
                parsedVris.add(parsedVri);
            }
        }
        return parsedVris;
    }

    private static Set<SignatureValidationDataAttachment<CRL>> readAttachedCRLs(COSDictionary dict, String key) {
        HashSet<PAdESValidationData<CRL>> result;
        block13: {
            result = null;
            try {
                COSBase crlItem;
                if (dict == null || (crlItem = dict.getItem(key)) == null) break block13;
                CertificateFactory factory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
                List<InputStream> streams = PAdESAttachmentParser.getStreamsFromArray(crlItem);
                result = new HashSet<PAdESValidationData<CRL>>();
                Iterator<InputStream> iterator = streams.iterator();
                while (iterator.hasNext()) {
                    InputStream is;
                    InputStream tmp = is = iterator.next();
                    Throwable throwable = null;
                    try {
                        CRL cert = factory.generateCRL(tmp);
                        result.add(new PAdESValidationData<CRL>(cert));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tmp == null) continue;
                        if (throwable != null) {
                            try {
                                tmp.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tmp.close();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't parse CRL values", (Throwable)e);
            }
        }
        return result;
    }

    private static Set<SignatureValidationDataAttachment<OCSPResp>> readAttachedOCSPs(COSDictionary dict, String key) {
        HashSet<PAdESValidationData<OCSPResp>> result;
        block13: {
            result = null;
            try {
                COSBase ocspItem;
                if (dict == null || (ocspItem = dict.getItem(key)) == null) break block13;
                List<InputStream> streams = PAdESAttachmentParser.getStreamsFromArray(ocspItem);
                result = new HashSet<PAdESValidationData<OCSPResp>>();
                Iterator<InputStream> iterator = streams.iterator();
                while (iterator.hasNext()) {
                    InputStream is;
                    InputStream tmp = is = iterator.next();
                    Throwable throwable = null;
                    try {
                        OCSPResp ocsp = new OCSPResp(tmp);
                        result.add(new PAdESValidationData<OCSPResp>(ocsp));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tmp == null) continue;
                        if (throwable != null) {
                            try {
                                tmp.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tmp.close();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't parse OCSP values", (Throwable)e);
            }
        }
        return result;
    }

    private static Set<SignatureValidationDataAttachment<X509Certificate>> readAttachedCertificates(COSDictionary dict, String key) {
        HashSet<PAdESValidationData<X509Certificate>> result;
        block13: {
            result = null;
            try {
                COSBase certificateItem;
                if (dict == null || (certificateItem = dict.getItem(key)) == null) break block13;
                CertificateFactory factory = CryptoProviderUtil.getCertificateFactoryInstance((String)"X509");
                List<InputStream> streams = PAdESAttachmentParser.getStreamsFromArray(certificateItem);
                result = new HashSet<PAdESValidationData<X509Certificate>>();
                Iterator<InputStream> iterator = streams.iterator();
                while (iterator.hasNext()) {
                    InputStream is;
                    InputStream tmp = is = iterator.next();
                    Throwable throwable = null;
                    try {
                        X509Certificate cert = (X509Certificate)factory.generateCertificate(tmp);
                        result.add(new PAdESValidationData<X509Certificate>(cert));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tmp == null) continue;
                        if (throwable != null) {
                            try {
                                tmp.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tmp.close();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't parse certificates", (Throwable)e);
            }
        }
        return result;
    }

    private static List<InputStream> getStreamsFromArray(COSBase certificateItem) throws IOException {
        COSBase certItem = certificateItem;
        if (certItem instanceof COSObject) {
            COSObject cosObj = (COSObject)certItem;
            certItem = cosObj.getObject();
        }
        COSArray array = (COSArray)certItem;
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        for (int i = 0; i < array.size(); ++i) {
            COSObject obj = (COSObject)array.get(i);
            COSStream stream = (COSStream)obj.getObject();
            COSInputStream is = stream.createInputStream();
            result.add((InputStream)is);
        }
        return result;
    }

    public static void addAttachmentSignatureAttributes(PAdESSignature padesSignature, DocumentSecurityStore documentSecurityStore) {
        List elements = padesSignature.getSignatureAttributes().getSigningTimeOrSigningCertificateOrDataObjectFormat();
        DSSType dssType = new DSSType();
        dssType.setSigned(Boolean.valueOf(false));
        Set<SignatureValidationDataAttachment<X509Certificate>> certs = documentSecurityStore.getDssCerts();
        Set<SignatureValidationDataAttachment<OCSPResp>> ocsps = documentSecurityStore.getDssOCSPs();
        Set<SignatureValidationDataAttachment<CRL>> crls = documentSecurityStore.getDssCRLs();
        certs.forEach(x -> {
            try {
                dssType.getCerts().add(((X509Certificate)x.getValue()).getEncoded());
            }
            catch (CertificateEncodingException e) {
                LOGGER.error("Cannot encode certificate bytes", (Throwable)e);
            }
        });
        ocsps.forEach(x -> {
            try {
                dssType.getOcsps().add(((OCSPResp)x.getValue()).getEncoded());
            }
            catch (IOException e) {
                LOGGER.error("Cannot get ASN.1 encoded ocsp response.", (Throwable)e);
            }
        });
        crls.forEach(x -> {
            try {
                dssType.getCrls().add(((X509CRL)x.getValue()).getEncoded());
            }
            catch (CRLException e) {
                LOGGER.error("Cannot get CRL bytes", (Throwable)e);
            }
        });
        if (!(dssType.getCerts().isEmpty() && dssType.getOcsps().isEmpty() && dssType.getCrls().isEmpty())) {
            elements.add(svpFactory.createSignatureAttributesTypeDss(dssType));
        }
        PAdESAttachmentParser.addSignedAttributeVri(padesSignature, documentSecurityStore.getValidationRelatedInfoMap(), elements);
    }

    private static void addSignedAttributeVri(PAdESSignature padesSignature, Map<String, ValidationRelatedInfo> vriMap, List<JAXBElement<? extends AttributeBaseType>> elements) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Cannot get SHA1 message digest");
            return;
        }
        md.update(padesSignature.getSignatureBytes());
        String sigB16EncSha1Hash = new Base16(false).encodeToString(md.digest());
        ValidationRelatedInfo validationRelatedInfo = vriMap.get(sigB16EncSha1Hash);
        if (validationRelatedInfo != null) {
            PAdESAttachmentParser.fillVriTypeAndAddToElements(elements, validationRelatedInfo);
        }
    }

    private static void fillVriTypeAndAddToElements(List<JAXBElement<? extends AttributeBaseType>> elements, ValidationRelatedInfo validationRelatedInfo) {
        VRIType vriType = new VRIType();
        vriType.setSigned(Boolean.valueOf(false));
        Set<SignatureValidationDataAttachment<X509Certificate>> vriCerts = validationRelatedInfo.getVriCerts();
        Set<SignatureValidationDataAttachment<OCSPResp>> vriOCSPs = validationRelatedInfo.getVriOCSPs();
        Set<SignatureValidationDataAttachment<CRL>> vriCRLs = validationRelatedInfo.getVriCRLs();
        vriCerts.forEach(x -> {
            try {
                vriType.getCerts().add(((X509Certificate)x.getValue()).getEncoded());
            }
            catch (CertificateEncodingException e) {
                LOGGER.error("Cannot encode certficate bytes", (Throwable)e);
            }
        });
        vriOCSPs.forEach(x -> {
            try {
                vriType.getOcsps().add(((OCSPResp)x.getValue()).getEncoded());
            }
            catch (IOException e) {
                LOGGER.error("Cannot get ASN.1 encoded ocsp response.", (Throwable)e);
            }
        });
        vriCRLs.forEach(x -> {
            try {
                vriType.getCrls().add(((X509CRL)x.getValue()).getEncoded());
            }
            catch (CRLException e) {
                LOGGER.error("Cannot get CRL bytes", (Throwable)e);
            }
        });
        elements.add((JAXBElement<? extends AttributeBaseType>)svpFactory.createSignatureAttributesTypeVri(vriType));
    }
}

