/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.pades;

import de.governikus.csl.pades.PAdESAttachmentParser;
import de.governikus.csl.pades.PAdESContainer;
import de.governikus.csl.pades.PAdESSignature;
import de.governikus.csl.pades.ValidationRelatedInfo;
import de.governikus.csl.uom.validate.commons.SignatureValidationDataAttachment;
import java.security.cert.CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSecurityStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSecurityStore.class);
    private Map<String, ValidationRelatedInfo> validationRelatedInfoMap = new HashMap<String, ValidationRelatedInfo>();
    private Set<SignatureValidationDataAttachment<X509Certificate>> dssCerts = new HashSet<SignatureValidationDataAttachment<X509Certificate>>();
    private Set<SignatureValidationDataAttachment<OCSPResp>> dssOCSPs = new HashSet<SignatureValidationDataAttachment<OCSPResp>>();
    private Set<SignatureValidationDataAttachment<CRL>> dssCRLs = new HashSet<SignatureValidationDataAttachment<CRL>>();

    public Map<String, ValidationRelatedInfo> getValidationRelatedInfoMap() {
        return this.validationRelatedInfoMap;
    }

    public void setValidationRelatedInfoMap(Map<String, ValidationRelatedInfo> validationRelatedInfoMap) {
        this.validationRelatedInfoMap = validationRelatedInfoMap;
    }

    public Set<SignatureValidationDataAttachment<X509Certificate>> getDssCerts() {
        return this.dssCerts;
    }

    public void setDssCerts(Set<SignatureValidationDataAttachment<X509Certificate>> dssCerts) {
        this.dssCerts = dssCerts;
    }

    public boolean hasDssCerts() {
        return this.hasAttachments(this.dssCerts);
    }

    public Set<SignatureValidationDataAttachment<OCSPResp>> getDssOCSPs() {
        return this.dssOCSPs;
    }

    public void setDssOCSPs(Set<SignatureValidationDataAttachment<OCSPResp>> dssOCSPs) {
        this.dssOCSPs = dssOCSPs;
    }

    public boolean hasDssOCSPs() {
        return this.hasAttachments(this.dssOCSPs);
    }

    public Set<SignatureValidationDataAttachment<CRL>> getDssCRLs() {
        return this.dssCRLs;
    }

    public void setDssCRLs(Set<SignatureValidationDataAttachment<CRL>> dssCRLs) {
        this.dssCRLs = dssCRLs;
    }

    public boolean hasDssCRLs() {
        return this.hasAttachments(this.dssCRLs);
    }

    public <A> boolean hasAttachments(Collection<SignatureValidationDataAttachment<A>> attachmentToTest) {
        return attachmentToTest != null && !attachmentToTest.isEmpty();
    }

    public void add(DocumentSecurityStore otherDss) {
        this.validationRelatedInfoMap.putAll(otherDss.getValidationRelatedInfoMap());
        this.addCerts(otherDss);
        this.addCRLs(otherDss);
        this.addOCSPs(otherDss);
    }

    private void addCerts(DocumentSecurityStore otherDss) {
        Predicate<X509Certificate> isInDssCerts = otherElement -> this.dssCerts.stream().anyMatch(dssElement -> ((X509Certificate)dssElement.getValue()).equals(otherElement));
        Set duplicates = otherDss.getDssCerts().stream().filter(x -> isInDssCerts.test((X509Certificate)x.getValue())).collect(Collectors.toSet());
        otherDss.getDssCerts().removeAll(duplicates);
        this.dssCerts.addAll(otherDss.getDssCerts());
        if (!otherDss.getDssCerts().isEmpty()) {
            LOGGER.debug("Adding {} certificates. DocumentSecurityStore now contains {} certificates.", (Object)otherDss.getDssCerts().size(), (Object)this.dssCerts.size());
        }
    }

    private void addCRLs(DocumentSecurityStore otherDss) {
        Predicate<CRL> isInDssCRL = otherElement -> this.dssCRLs.stream().anyMatch(dssElement -> ((CRL)dssElement.getValue()).equals(otherElement));
        Set duplicates = otherDss.getDssCRLs().stream().filter(x -> isInDssCRL.test((CRL)x.getValue())).collect(Collectors.toSet());
        otherDss.getDssCRLs().removeAll(duplicates);
        this.dssCRLs.addAll(otherDss.getDssCRLs());
        if (!otherDss.getDssCRLs().isEmpty()) {
            LOGGER.debug("Adding {} CRLs. DocumentSecurityStore now contains {} CRLs.", (Object)otherDss.getDssCRLs().size(), (Object)this.dssOCSPs.size());
        }
    }

    private void addOCSPs(DocumentSecurityStore otherDss) {
        Predicate<OCSPResp> isInDssOcsp = otherElement -> this.dssOCSPs.stream().anyMatch(dssElement -> ((OCSPResp)dssElement.getValue()).equals(otherElement));
        Set duplicates = otherDss.getDssOCSPs().stream().filter(x -> isInDssOcsp.test((OCSPResp)x.getValue())).collect(Collectors.toSet());
        otherDss.getDssOCSPs().removeAll(duplicates);
        this.dssOCSPs.addAll(otherDss.getDssOCSPs());
        if (!otherDss.getDssOCSPs().isEmpty()) {
            LOGGER.debug("Adding {} OCSPs. DocumentSecurityStore now contains {} OCSPs.", (Object)otherDss.getDssOCSPs().size(), (Object)this.dssOCSPs.size());
        }
    }

    public void insertAttachments(List<PAdESContainer> revisions) {
        this.insertCerts(revisions);
        this.insertOCSPs(revisions);
        this.insertCRLs(revisions);
    }

    public void addSignatureAttributes(PAdESContainer revision) {
        if (revision == null) {
            return;
        }
        List signatures = revision.getSignatures();
        if (signatures == null) {
            return;
        }
        for (PAdESSignature sig : signatures) {
            PAdESAttachmentParser.addAttachmentSignatureAttributes(sig, this);
        }
    }

    private void insertCerts(List<PAdESContainer> revisions) {
        if (!this.dssCerts.isEmpty() || revisions != null) {
            for (PAdESContainer revision : revisions) {
                this.appendCertsToRevision(revision);
            }
        }
    }

    private void appendCertsToRevision(PAdESContainer revision) {
        if (revision == null) {
            return;
        }
        List signatures = revision.getSignatures();
        if (signatures == null) {
            return;
        }
        for (PAdESSignature sig : signatures) {
            this.appendCertsToSignature(sig);
        }
    }

    private void appendCertsToSignature(PAdESSignature sig) {
        Set attachedCertificates = sig.getAttachedCertificates();
        if (!this.hasAttachments(attachedCertificates)) {
            sig.setAttachedCertificates(this.dssCerts);
        } else {
            attachedCertificates.addAll(this.dssCerts);
        }
    }

    private void insertOCSPs(List<PAdESContainer> revisions) {
        if (!this.dssOCSPs.isEmpty() || revisions != null) {
            for (PAdESContainer revision : revisions) {
                this.appendOCSPsToRevision(revision);
            }
        }
    }

    private void appendOCSPsToRevision(PAdESContainer revision) {
        if (revision == null) {
            return;
        }
        List signatures = revision.getSignatures();
        if (signatures == null) {
            return;
        }
        for (PAdESSignature sig : signatures) {
            this.appendOCSPsToSignature(sig);
        }
    }

    private void appendOCSPsToSignature(PAdESSignature sig) {
        List attachedOCSPValues = sig.getAttachedOCSPValues();
        if (!this.hasAttachments(attachedOCSPValues)) {
            sig.setAttachedOCSPValues(new ArrayList<SignatureValidationDataAttachment<OCSPResp>>(this.dssOCSPs));
        } else {
            attachedOCSPValues.addAll(this.dssOCSPs);
        }
    }

    private void insertCRLs(List<PAdESContainer> revisions) {
        if (!this.dssCRLs.isEmpty() || revisions != null) {
            for (PAdESContainer revision : revisions) {
                this.appendCRLsToRevision(revision);
            }
        }
    }

    private void appendCRLsToRevision(PAdESContainer revision) {
        if (revision == null) {
            return;
        }
        List signatures = revision.getSignatures();
        if (signatures == null) {
            return;
        }
        for (PAdESSignature sig : signatures) {
            this.appendCRLsToSignature(sig);
        }
    }

    private void appendCRLsToSignature(PAdESSignature sig) {
        List attachedCrls = sig.getAttachedCRLs();
        if (!this.hasAttachments(attachedCrls)) {
            sig.setAttachedCRLs(new ArrayList<SignatureValidationDataAttachment<CRL>>(this.dssCRLs));
        } else {
            attachedCrls.addAll(this.dssCRLs);
        }
    }
}

