/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.tsp.service.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.governikus.csc.tsp.service.client.ProfileDetails;
import de.governikus.csc.tsp.service.client.TSPResponseData;
import de.governikus.csc.utils.rest.client.URIBuilder;
import de.governikus.csl.transport.AbstractHttpClient;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.transport.HttpHeader;
import de.governikus.csl.transport.HttpRequest;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.entity.ByteArrayRequest;
import de.governikus.csl.transport.entity.InputStreamRequest;
import de.governikus.csl.transport.exception.ResponseException;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTimestampServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTimestampServiceClient.class);
    protected static final String HEADER_RFCTSPRESPONSE = "rfcTSPResponse";
    protected URIBuilder baseUriBuilder;
    protected HttpClient httpClient;

    protected BaseTimestampServiceClient(HttpClient httpClient, URI baseURI) {
        this.httpClient = httpClient;
        this.baseUriBuilder = new URIBuilder(baseURI);
    }

    protected URI buildRequestURI(String profileID, boolean hashed) throws CoreException {
        Object path = "";
        if (profileID == null || profileID.isEmpty()) {
            LOGGER.error("missing parameter ProfileID !");
            throw new CoreException("missing paramerter ProfileID !");
        }
        path = (String)path + profileID;
        path = hashed ? (String)path + "/hash" : (String)path + "/file";
        return this.baseUriBuilder.clone().path((String)path).build();
    }

    protected byte[] getData(URI uri) throws CoreException {
        try {
            HttpResponse httpResponse = this.httpClient.get(uri, new HttpHeader[0]);
            AbstractHttpClient.checkResponseErrors((HttpResponse)httpResponse);
            return this.readResponse(httpResponse);
        }
        catch (ResponseException e) {
            throw new CoreException("Server returned error response Code: " + e.getStatus() + " - " + e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error get request: {}", (Object)e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    protected TSPResponseData postData(URI requestURI, HttpRequest entity) throws CoreException {
        try {
            HttpResponse httpResponse = this.httpClient.post(requestURI, entity, new HttpHeader[]{new HttpHeader("Accept", "application/octet-stream")});
            AbstractHttpClient.checkResponseErrors((HttpResponse)httpResponse);
            byte[] readRFCtspResponse = this.readRFCtspResponse(httpResponse.getHeader());
            byte[] readResponse = this.readResponse(httpResponse);
            return new TSPResponseData(readResponse, readRFCtspResponse);
        }
        catch (ResponseException e) {
            throw new CoreException("Server returned error response Code " + e.getStatus() + " - " + e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error post request: {}", (Object)e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    protected byte[] readResponse(HttpResponse httpResponse) throws CoreException {
        byte[] byArray;
        block8: {
            InputStream in = httpResponse.getContent();
            try {
                byArray = IOUtils.toByteArray((InputStream)in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("error while reading bytes from response {}", (Object)e.getMessage());
                    throw new CoreException((Throwable)e);
                }
            }
            in.close();
        }
        return byArray;
    }

    protected byte[] readRFCtspResponse(List<HttpHeader> headers) {
        byte[] rfctspresponse = null;
        if (headers != null && !headers.isEmpty()) {
            for (HttpHeader httpHeader : headers) {
                if (!HEADER_RFCTSPRESPONSE.equals(httpHeader.getName())) continue;
                rfctspresponse = Base64.getDecoder().decode(httpHeader.getValue());
                break;
            }
        }
        return rfctspresponse;
    }

    public TSPResponseData timestamp(byte[] data, String profileID, boolean hashed) throws CoreException {
        URI requestURI = this.buildRequestURI(profileID, hashed);
        return this.postData(requestURI, (HttpRequest)new ByteArrayRequest(data, "application/octet-stream", null));
    }

    public TSPResponseData timestamp(Document document, String profileID, boolean hashed) throws CoreException {
        TSPResponseData tSPResponseData;
        block10: {
            URI requestURI = this.buildRequestURI(profileID, hashed);
            InputStream is = document.getInputStream();
            try {
                tSPResponseData = this.postData(requestURI, (HttpRequest)new InputStreamRequest(is, "application/octet-stream", null));
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResponseException e) {
                    throw new CoreException("Server returned error response Code " + e.getStatus() + " - " + e.getMessage(), (Throwable)e);
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error("while requesting for timestamp with Document {}", (Object)e.getMessage());
                    throw new CoreException((Throwable)e);
                }
            }
            is.close();
        }
        return tSPResponseData;
    }

    public TSPResponseData timestamp(InputStream data, String profileID, boolean hashed) throws CoreException {
        URI requestURI = this.buildRequestURI(profileID, hashed);
        return this.postData(requestURI, (HttpRequest)new InputStreamRequest(data, "application/octet-stream", null));
    }

    public String[] getProfileNames() throws CoreException {
        try {
            URI requestURI = this.baseUriBuilder.clone().build();
            byte[] data = this.getData(requestURI);
            String profilesJson = new String(data);
            String[] fromJson = (String[])new Gson().fromJson(profilesJson, String[].class);
            String[] profilename = new String[fromJson.length];
            for (int i = 0; i < fromJson.length; ++i) {
                URI u = new URI(fromJson[i]);
                String[] split = u.getPath().split("/");
                profilename[i] = split[split.length - 1];
            }
            return profilename;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error getting ProfileNames {}", (Object)e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    public Map<String, ProfileDetails> getFullDetails() throws CoreException {
        try {
            URI requestURI = this.baseUriBuilder.query("allDetails=true").clone().build();
            byte[] data = this.getData(requestURI);
            String profilesJson = new String(data);
            Type type = new TypeToken<Map<String, ProfileDetails>>(){}.getType();
            return (Map)new Gson().fromJson(profilesJson, type);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error getting FullDetails {}", (Object)e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    public ProfileDetails getProfileDetails(String profileID) throws CoreException {
        if (profileID == null || profileID.isEmpty()) {
            LOGGER.error("missing parameter ProfileID !");
            throw new CoreException("missing paramerter ProfileID !");
        }
        try {
            URI requestURI = this.baseUriBuilder.clone().path("/" + profileID).build();
            byte[] data = this.getData(requestURI);
            String profilesJson = new String(data);
            return (ProfileDetails)new Gson().fromJson(profilesJson, ProfileDetails.class);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("error getting profile details {}", (Object)e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    public void setAuthToken(String token) {
        this.httpClient.addDefaultHeader("Authorization", "Bearer " + token);
    }
}

