/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.tsp.service.client;

import de.governikus.csc.authentication.keycloak.client.KeycloakAuthClient;
import de.governikus.csc.tsp.service.client.BaseTimestampServiceClient;
import de.governikus.csc.tsp.service.client.TSPResponseData;
import de.governikus.csl.transport.HttpClient;
import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.keycloak.jose.jws.JWSInputException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedTimestampServiceClient
extends BaseTimestampServiceClient {
    private static final String MESSAGE_PREFIX_AUTHENTICATION_FAILED = "authentication failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatedTimestampServiceClient.class);
    KeycloakAuthClient keycloakAuthClient;

    public AuthenticatedTimestampServiceClient(URI baseURI, HttpClient httpClient, KeycloakAuthClient keycloakAuthClient) {
        super(httpClient, baseURI);
        this.keycloakAuthClient = keycloakAuthClient;
        LOGGER.debug("AuthenticatedTimestampServiceClient created");
    }

    @Override
    public TSPResponseData timestamp(byte[] data, String profileID, boolean hashed) throws CoreException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (IOException | JWSInputException e) {
            throw new CoreException(MESSAGE_PREFIX_AUTHENTICATION_FAILED, e);
        }
        return super.timestamp(data, profileID, hashed);
    }

    @Override
    public TSPResponseData timestamp(Document document, String profileID, boolean hashed) throws CoreException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (IOException | JWSInputException e) {
            throw new CoreException(MESSAGE_PREFIX_AUTHENTICATION_FAILED, e);
        }
        return super.timestamp(document, profileID, hashed);
    }

    @Override
    public TSPResponseData timestamp(InputStream data, String profileID, boolean hashed) throws CoreException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (IOException | JWSInputException e) {
            throw new CoreException(MESSAGE_PREFIX_AUTHENTICATION_FAILED, e);
        }
        return super.timestamp(data, profileID, hashed);
    }

    @Override
    public String[] getProfileNames() throws CoreException {
        try {
            this.setAuthToken(this.keycloakAuthClient.getAccessToken());
        }
        catch (IOException | JWSInputException e) {
            throw new CoreException(MESSAGE_PREFIX_AUTHENTICATION_FAILED, e);
        }
        return super.getProfileNames();
    }
}

