/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.inspect.velocity;

import de.bos_bremen.algorithm_identifier.Algorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.governikus.csl.inspect.model.PreprocessedInternalLink;
import de.governikus.csl.inspect.model.PreprocessedMessageCode;
import de.governikus.csl.inspect.model.PreprocessedQualityInformation;
import de.governikus.csl.inspect.model.PreprocessedSignatureResult;
import de.governikus.csl.inspect.model.PreprocessedValidationReport;
import de.governikus.csl.inspect.velocity.HTMLEscapingResourceBundle;
import de.governikus.csl.result.LDAPEntry;
import de.governikus.csl.svp.SVPFactory;
import de.governikus.csl.uom.InternationalizedString;
import de.governikus.csl.uom.InternationalizedValue;
import de.governikus.csl.uom.Plugin;
import de.governikus.csl.uom.PolicyInformation;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import de.governikus.csl.uom.validate.CertificateLevel;
import de.governikus.csl.uom.validate.CertificateQualification;
import de.governikus.csl.uom.validate.CertificateQualityConstraints;
import de.governikus.csl.uom.validate.CertificateQualityResult;
import de.governikus.csl.uom.validate.CertificateType;
import de.governikus.csl.uom.validate.Quality;
import de.governikus.csl.uom.validate.QualityResult;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import de.governikus.csl.uom.validate.SignatureValidationResult;
import de.governikus.csl.uom.validate.TLType;
import de.governikus.csl.uom.validate.commons.CumulatedValidationResult;
import de.governikus.csl.uom.validate.commons.EUQualifiedCertificateType;
import de.governikus.csl.uom.validate.commons.MajorTotalResult;
import de.governikus.csl.uom.validate.commons.MinorResult;
import de.governikus.csl.uom.validate.commons.NestedResultCumulationInstruction;
import de.governikus.csl.uom.validate.commons.ResultAggregator;
import de.governikus.csl.uom.validate.commons.ValidationResult;
import de.governikus.csl.utils.SignalAggregateUtil;
import de.governikus.csl.validate.svp.CertificateQualificationInformation;
import de.governikus.csl.validate.svp.ERSValidationResult;
import de.governikus.csl.validate.svp.PAdESRevisionValidationResult;
import de.governikus.csl.validate.svp.PublicKeyCertificateValidationResult;
import de.governikus.csl.validate.svp.ValidationMessageCode;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VelocityHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(VelocityHelper.class);
    private static boolean isDevelopmentModeActive;
    private static Map<String, String> parameterDisplayNames;
    private static final String REG_EXP_URL = "(((https?|ftp|file)://)|(file:/))[-a-zA-Z0-9+&@#/%?=~_|!:,.;()]*[-a-zA-Z0-9+&@#/%?=~_|!:,;]";
    private static final Pattern URL_PATTERN;
    private static final String QcSSCD = "0.4.0.1862.1.4";
    private static final String QCPPLUS = "0.4.0.1456.1.1";
    private static final String QCWithSSCD = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithSSCD";
    private static final String QCWithQSCD = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCWithQSCD";
    private static final String QCQSCDManagedOnBehalf = "http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCQSCDManagedOnBehalf";
    private static final List<String> QSCD_QUALIFIERS;
    private static final String ACQC;
    private static final String WARN_HINT_KEY = "quality.certificate.warn.hint";

    public static boolean isDevelopmentModeActive() {
        return isDevelopmentModeActive;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static Object printCertQuality(HTMLEscapingResourceBundle rb, CertificateQualityResult qualityResult) {
        if (qualityResult == null) {
            return null;
        }
        Quality assumedQuality = qualityResult.getAssumedQuality();
        CertificateType certificateType = qualityResult.getCertificateType();
        MajorTotalResult result = qualityResult.getMajor();
        if (result == MajorTotalResult.INDETERMINATE) {
            return "quality.certificate." + result;
        }
        String qualityKey = "quality.certificate." + assumedQuality + "." + certificateType + "." + result;
        return VelocityHelper.checkWarningRequired(rb, qualityResult, qualityKey);
    }

    public static Object printSigQuality(HTMLEscapingResourceBundle rb, QualityResult qualityResult) {
        CertificateQualityResult certQualityResult = qualityResult.getCertificateQualityResult();
        MajorTotalResult result = certQualityResult.getMajor();
        String infix = "";
        if (VelocityHelper.isAdvancedBasedOnQualified(certQualityResult) || VelocityHelper.isQCPerspective(certQualityResult) && !VelocityHelper.hasQSCDInfo(certQualityResult)) {
            infix = "AC_BASED_ON.";
        } else if (Quality.QC.equals((Object)certQualityResult.getAssumedQuality())) {
            result = qualityResult.getOverallResult(true).getMajor();
        }
        Quality certQuality = certQualityResult.getQuality();
        if (Quality.INDETERMINATE.equals((Object)certQuality)) {
            certQuality = certQualityResult.getAssumedQuality();
        }
        CertificateType certType = certQualityResult.getCertificateType();
        String qualityKey = "quality.signature." + infix + certQuality + "." + certType + "." + result;
        return VelocityHelper.checkWarningRequired(rb, certQualityResult, qualityKey);
    }

    private static Object checkWarningRequired(HTMLEscapingResourceBundle rb, CertificateQualityResult qualityResult, String qualityKey) {
        if (!qualityResult.getQuality().equals((Object)Quality.AC)) {
            return qualityKey;
        }
        boolean requiresWarning = false;
        List messages = qualityResult.getMessages();
        for (de.governikus.csl.uom.validate.commons.ValidationMessageCode msgCode : messages) {
            if (!msgCode.getMessageCode().equals("quality_qc_overriden")) continue;
            requiresWarning = true;
            break;
        }
        if (requiresWarning) {
            ArrayList<String> qualityAndWarning = new ArrayList<String>(2);
            qualityAndWarning.add(qualityKey);
            qualityAndWarning.add(rb.getString(WARN_HINT_KEY));
            return qualityAndWarning;
        }
        return qualityKey;
    }

    public static Object getAssumedCertificateQuality(CertificateQualityResult qualityResult) {
        Quality quality = qualityResult.getAssumedQuality();
        if (Quality.INDETERMINATE.equals((Object)quality)) {
            quality = Quality.DC;
        }
        CertificateType certificateType = qualityResult.getCertificateType();
        if (!(quality.equals((Object)Quality.DC) || !MajorTotalResult.TOTAL_PASSED.equals((Object)qualityResult.getMajor()) && CertificateType.INDETERMINATE.equals((Object)certificateType))) {
            return "quality.certificate.assumed." + quality + "." + certificateType;
        }
        return "quality.certificate.assumed." + quality;
    }

    private static boolean isAdvancedBasedOnQualified(CertificateQualityResult certQualityResult) {
        TLType tlType = certQualityResult.getTLType();
        CertificateQualityConstraints constraints = certQualityResult.getConstraints();
        List qualifiers = constraints.getQualifiers();
        List qcStatements = constraints.getQCStatements();
        return tlType != null && !qcStatements.contains(QcSSCD) && (qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoQSCD") || qualifiers.contains("http://uri.etsi.org/TrstSvc/TrustedList/SvcInfoExt/QCNoSSCD"));
    }

    public static String getSignatureResultType(CertificateQualityResult certQualityResult) {
        String serviceTypeIdentifier;
        if (VelocityHelper.isAdvancedBasedOnQualified(certQualityResult)) {
            return ACQC;
        }
        TLType tlType = certQualityResult.getTLType();
        if (VelocityHelper.isQcPerspective(tlType, serviceTypeIdentifier = certQualityResult.getConstraints().getServiceTypeIdentifier())) {
            return VelocityHelper.hasQSCDInfo(certQualityResult) ? Quality.QC.name() : ACQC;
        }
        if (TLType.GOVERNIKUS.equals((Object)tlType) || TLType.CUSTOM.equals((Object)tlType) || TLType.OFFICIAL.equals((Object)tlType) && "http://uri.etsi.org/TrstSvc/Svctype/CA/PKC".equals(serviceTypeIdentifier)) {
            return Quality.AC.name();
        }
        return Quality.DC.name();
    }

    private static boolean isQCPerspective(CertificateQualityResult certQualityResult) {
        TLType tlType = certQualityResult.getTLType();
        String serviceTypeIdentifier = certQualityResult.getConstraints().getServiceTypeIdentifier();
        return VelocityHelper.isQcPerspective(tlType, serviceTypeIdentifier);
    }

    private static boolean isQcPerspective(TLType tlType, String serviceTypeIdentifier) {
        return TLType.OFFICIAL.equals((Object)tlType) && "http://uri.etsi.org/TrstSvc/Svctype/CA/QC".equals(serviceTypeIdentifier);
    }

    private static boolean hasQSCDInfo(CertificateQualityResult certQualityResult) {
        CertificateQualityConstraints constraints = certQualityResult.getConstraints();
        List qualifiers = constraints.getQualifiers();
        List qcStatements = constraints.getQCStatements();
        List policies = constraints.getCertificatePolicies();
        return qualifiers.stream().anyMatch(QSCD_QUALIFIERS::contains) || qcStatements.contains(QcSSCD) || policies.contains(QCPPLUS);
    }

    public static Class<?> getClass(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return null;
        }
    }

    public static boolean isInstanceOf(Object object, String type) {
        return VelocityHelper.isInstanceOf(object, VelocityHelper.getClass(type));
    }

    public static boolean isInstanceOf(Object object, Class<?> typeClass) {
        if (object == null || typeClass == null) {
            return false;
        }
        return typeClass.isInstance(object);
    }

    public static boolean isClass(Object object, String type) {
        if (object == null) {
            return false;
        }
        return object.getClass().getName().equalsIgnoreCase(type);
    }

    public static boolean isSimpleClass(Object object, String type) {
        if (object == null) {
            return false;
        }
        return object.getClass().getSimpleName().equalsIgnoreCase(type);
    }

    public static boolean isEnum(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().isEnum();
    }

    public static boolean containsURL(Object linkObject) {
        String value;
        if (linkObject == null) {
            return false;
        }
        if (linkObject instanceof URL || linkObject instanceof URI) {
            return true;
        }
        return linkObject instanceof String && ((value = ((String)linkObject).toLowerCase(Locale.ENGLISH)).indexOf("http://") >= 0 || value.indexOf("https://") >= 0 || value.indexOf("file:/") >= 0 || value.indexOf("ftp://") >= 0);
    }

    public Pattern getURLPattern() {
        return URL_PATTERN;
    }

    public String getAsLink(Object linkObject) {
        if (linkObject == null) {
            return "";
        }
        if (linkObject instanceof URL || linkObject instanceof URI) {
            return "#setExternalLink('" + linkObject.toString() + "')";
        }
        String linkData = linkObject instanceof String ? (String)linkObject : linkObject.toString();
        Matcher matcher = this.getURLPattern().matcher(linkData);
        int lastStartPos = 0;
        int cntMatches = 0;
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            ++cntMatches;
            if (lastStartPos < matcher.start()) {
                sb.append(linkData.substring(lastStartPos, matcher.start()));
            }
            sb.append("#setExternalLink('");
            sb.append(linkData.substring(matcher.start(), matcher.end()));
            sb.append("')");
            lastStartPos = matcher.end();
        }
        if (cntMatches > 0) {
            if (lastStartPos > 0) {
                sb.append(linkData.substring(lastStartPos));
            }
            return sb.toString();
        }
        return linkData;
    }

    public static List<String> getURLs(HTMLEscapingResourceBundle rb, Collection<String> urls) {
        ArrayList<String> res = new ArrayList<String>();
        for (String url : urls) {
            res.add(rb.getHTML(url));
            res.add("(" + url + ")");
        }
        return res;
    }

    public static String getNameFromURL(HTMLEscapingResourceBundle rb, String url) {
        if (rb.containsKey(url + ".name")) {
            return rb.getString(url + ".name");
        }
        if (url.contains("/")) {
            return url.substring(url.lastIndexOf(47)).replace("/", "");
        }
        return url;
    }

    public static String getTranslatedURL(HTMLEscapingResourceBundle rb, Object url) {
        if (url == null) {
            return null;
        }
        String urlText = url.toString();
        String[] splits = urlText.split(",");
        StringBuilder sb = new StringBuilder();
        for (String u : splits) {
            sb.append(VelocityHelper.getTranslatedURL(rb, u));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String getInBrackets(String text) {
        return "(" + text + ")";
    }

    public static String getDescription(HTMLEscapingResourceBundle rb, String urlText) {
        return VelocityHelper.getTranslatedURL(rb, urlText, true);
    }

    public static String getTranslatedURL(HTMLEscapingResourceBundle rb, String urlText) {
        return VelocityHelper.getTranslatedURL(rb, urlText, false);
    }

    private static String getTranslatedURL(HTMLEscapingResourceBundle rb, String urlText, boolean excludeUrl) {
        String keyName;
        Matcher matcher = URL_PATTERN.matcher(urlText);
        if (matcher.find() && rb.isKey(keyName = urlText.substring(matcher.start(), matcher.end()))) {
            if (!excludeUrl) {
                return rb.getHTML(keyName) + " (" + keyName + ")";
            }
            return rb.getHTML(keyName);
        }
        return HTMLEscapingResourceBundle.escapeHTML(urlText);
    }

    public static String getList(List<?> list) {
        return VelocityHelper.getList(list, ", ");
    }

    public static String getList(List<?> list, String seperator) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object item : list) {
            sb.append(seperator);
            sb.append(item.toString());
        }
        return sb.length() > 0 ? sb.substring(seperator.length()) : "";
    }

    public static String getCertificateSubject(HTMLEscapingResourceBundle rb, X509Certificate x509Cert) {
        if (x509Cert != null && x509Cert.getSubjectX500Principal() != null) {
            return VelocityHelper.getCertificateCN(x509Cert.getSubjectX500Principal());
        }
        return rb.getHTML("value.not.present");
    }

    public static String getCertificateCN(X500Principal principal) {
        if (principal == null) {
            return null;
        }
        String cn = new LDAPEntry(principal).getCommonName();
        if (cn != null) {
            return cn;
        }
        String dn = principal.toString();
        int cnPos = dn.indexOf("CN=") + 3;
        if (cnPos >= 3 && dn.length() > cnPos) {
            int endPos = -1;
            if (dn.charAt(cnPos) == '\"') {
                endPos = dn.indexOf("\"", ++cnPos);
            } else {
                endPos = dn.indexOf(",", cnPos + 1);
                if (endPos == -1) {
                    endPos = dn.length();
                }
            }
            if (endPos > cnPos) {
                cn = dn.substring(cnPos, endPos);
                if (cn.startsWith("#") && cn.length() >= 3 && cn.length() % 2 == 1) {
                    try {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        for (int cnt = 1; cnt < cn.length(); cnt += 2) {
                            baos.write(Integer.parseInt(cn.substring(cnt, cnt + 2), 16));
                        }
                        return baos.toString();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return cn;
            }
        }
        return dn;
    }

    public static String getIssuer(X509Certificate cert) {
        return VelocityHelper.getCertificateCN(cert.getIssuerX500Principal());
    }

    public static String getSubject(X509Certificate cert) {
        return VelocityHelper.getCertificateCN(cert.getSubjectX500Principal());
    }

    public static List<Flattable.Pair> getCertificateDetails(ResourceBundle rb, X509CertificateImpl x509CertImpl, boolean shortDetails) {
        try {
            Certificate viCert = Certificate.forX509((X509Certificate)((X509Certificate)x509CertImpl.getWrappedCertificate()));
            return viCert.flatten(rb, shortDetails);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static List<Flattable.Pair> getCertificateDetails(ResourceBundle rb, X509AttributeCertificateImpl attCertImpl, boolean shortDetails) {
        try {
            AttributeCertificate viAttCert = new AttributeCertificate(((org.bouncycastle.asn1.x509.AttributeCertificate)attCertImpl.getWrappedCertificate()).getEncoded());
            return viAttCert.flatten(rb, shortDetails);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getPairLabel(Flattable.Pair pair) {
        return pair.hasLabel() ? pair.label : "";
    }

    public static String getPairValue(Flattable.Pair pair) {
        return pair.hasValue() ? pair.value : "";
    }

    public static String getPolicyName(ResourceBundle rb, PolicyInformation policyInformation) {
        String defaultName = null;
        String lang = rb.getLocale().getLanguage();
        if (policyInformation != null) {
            for (InternationalizedString i18nName : policyInformation.getName()) {
                if (lang.equalsIgnoreCase(i18nName.getLang())) {
                    return i18nName.getValue();
                }
                if (!"en".equalsIgnoreCase(i18nName.getLang())) continue;
                defaultName = i18nName.getValue();
            }
        }
        return defaultName;
    }

    public static String trim(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString().trim();
    }

    public static void debug(Object ... objects) {
    }

    public static void log(Object ... logMessages) {
        if (!VelocityHelper.isDevelopmentModeActive()) {
            return;
        }
        if (logMessages.length > 1 && logMessages[0] instanceof String) {
            String templateString = (String)logMessages[0];
            Object[] templateParams = new Object[logMessages.length - 1];
            System.arraycopy(logMessages, 1, templateParams, 0, logMessages.length - 1);
            if (templateString.indexOf("%") >= 0) {
                LOGGER.info(String.format(templateString, templateParams));
                return;
            }
            if (((String)logMessages[0]).indexOf("{0") >= 0) {
                LOGGER.info(new MessageFormat(templateString).format(templateParams));
                return;
            }
        }
        for (Object obj : logMessages) {
            LOGGER.info(obj.toString());
        }
    }

    public static long getTimestamp() {
        return System.currentTimeMillis();
    }

    public String retrieveContent(HTMLEscapingResourceBundle rb, Object keyOrText) {
        if (keyOrText == null) {
            return "";
        }
        if (keyOrText instanceof String) {
            try {
                return rb.getHTML(keyOrText);
            }
            catch (MissingResourceException mr_ex) {
                return this.escapeContent((String)keyOrText);
            }
        }
        return this.escapeContent(keyOrText.toString());
    }

    public abstract String escapeContent(String var1);

    public static String getHTMLTooltip(HTMLEscapingResourceBundle rb, String key) {
        try {
            return rb.getHTML(key + ".tt");
        }
        catch (MissingResourceException mr_ex) {
            return null;
        }
    }

    private static void appendParameters(List<SignatureAlgorithmParameter> parameterList, StringBuffer name) {
        if (parameterList == null) {
            return;
        }
        for (SignatureAlgorithmParameter parameter : parameterList) {
            String parameterName = parameter.getName();
            name.append(" (");
            String shortName = parameterDisplayNames.get(parameterName);
            if (shortName != null) {
                name.append(shortName);
            } else {
                name.append(parameterName);
            }
            name.append(" = ");
            name.append(parameter.getValue());
            name.append(')');
        }
    }

    public static String getDisplayName(Algorithm algorithm, List<SignatureAlgorithmParameter> parameterList) {
        StringBuffer name = new StringBuffer(algorithm == null ? "UNKNOWN" : algorithm.getName());
        if (parameterList != null) {
            for (SignatureAlgorithmParameter parameter : parameterList) {
                name.append('-');
                name.append(parameter.getValue());
            }
        }
        return name.toString();
    }

    public static String getExtendedDisplayName(Algorithm algorithm, List<SignatureAlgorithmParameter> parameterList) {
        if (algorithm instanceof SignatureAlgorithm) {
            SignatureAlgorithm sigAlg = (SignatureAlgorithm)algorithm;
            StringBuffer name = new StringBuffer();
            name.append(sigAlg.getDigestAlgorithm().getName());
            name.append(' ');
            name.append(sigAlg.getBaseAlgorithm().name());
            VelocityHelper.appendParameters(parameterList, name);
            if (sigAlg.getPaddingAlgorithm() != null) {
                name.append(' ');
                name.append(sigAlg.getPaddingAlgorithm().getName());
            }
            if (sigAlg.getFormatAlgorithm() != null) {
                name.append(" Formatting: ");
                name.append(sigAlg.getFormatAlgorithm().name());
            }
            return name.toString();
        }
        return VelocityHelper.getDisplayName(algorithm, parameterList);
    }

    public static NestedResultCumulationInstruction getNestedResultCumulationInstruction(String name) {
        NestedResultCumulationInstruction valueOf = NestedResultCumulationInstruction.valueOf((String)name);
        if (valueOf == null) {
            throw new IllegalArgumentException("There is no value in the enum with the provided name");
        }
        return valueOf;
    }

    public static CumulatedValidationResult getOverallResult(List<? extends ResultAggregator> aggregators, NestedResultCumulationInstruction instruction) {
        return SignalAggregateUtil.aggregate(aggregators, (NestedResultCumulationInstruction)instruction);
    }

    public static CumulatedValidationResult getOverallResultFromValidationResultList(List<? extends ValidationResult> aggregators) {
        return SignalAggregateUtil.aggregate(aggregators);
    }

    public CumulatedValidationResult filterValidationMessages(ResultAggregator srcResult) {
        return this.filterValidationMessages(srcResult, true);
    }

    public CumulatedValidationResult filterValidationMessages(ResultAggregator srcResult, boolean doFilter) {
        ArrayList<ResultAggregator> raList = new ArrayList<ResultAggregator>();
        raList.add(srcResult);
        return SignalAggregateUtil.aggregate(raList, (NestedResultCumulationInstruction)(doFilter ? NestedResultCumulationInstruction.INCLUDE_MINOR : NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES));
    }

    public CumulatedValidationResult filterMinorResult(ResultAggregator srcResult) {
        return this.filterMinorResult(srcResult, true);
    }

    public CumulatedValidationResult filterMinorResult(ResultAggregator srcResult, boolean doFilter) {
        ArrayList<ResultAggregator> raList = new ArrayList<ResultAggregator>();
        raList.add(srcResult);
        return SignalAggregateUtil.aggregate(raList, (NestedResultCumulationInstruction)(doFilter ? NestedResultCumulationInstruction.INCLUDE_MAJOR : NestedResultCumulationInstruction.INCLUDE_VALIDATION_MESSAGES));
    }

    public static String getLocalizedString(List<InternationalizedString> strings, ResourceBundle rb) {
        InternationalizedString localizedValue = VelocityHelper.getLocalizedValue(strings, rb);
        if (localizedValue != null) {
            return localizedValue.getValue();
        }
        return null;
    }

    public static <T extends InternationalizedValue> T getLocalizedValue(List<T> strings, ResourceBundle rb) {
        if (strings == null || strings.isEmpty()) {
            return null;
        }
        Locale locale = rb.getLocale();
        String language = null;
        if (locale != null) {
            language = locale.getLanguage();
        }
        InternationalizedValue last = null;
        for (InternationalizedValue is : strings) {
            String lang = is.getLang();
            if (language != null && new Locale(lang).getLanguage().equals(language)) {
                return (T)is;
            }
            last = is;
        }
        return (T)last;
    }

    public static ValidationResult getIndeterminateResult() {
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, (MinorResult)null);
    }

    public static ValidationResult getIndeterminateResult(ValidationMessageCode messageCode) {
        return SVPFactory.create((MajorTotalResult)MajorTotalResult.INDETERMINATE, null, (ValidationMessageCode)messageCode);
    }

    public static PreprocessedMessageCode getPPMessageCode(String majorResult) {
        return new PreprocessedMessageCode(majorResult);
    }

    public static PreprocessedMessageCode getPPMessageCode(String majorResult, String text) {
        return new PreprocessedMessageCode(majorResult, text);
    }

    public static PreprocessedMessageCode getPPMessageCode(String majorResult, String text, String styles) {
        return new PreprocessedMessageCode(majorResult, text, styles);
    }

    public static String getVMFilename(String baseName, String pluginId) {
        if (baseName == null || pluginId == null) {
            return null;
        }
        String VM_EXT = ".vm";
        String pluginExt = "_" + pluginId.replace("-Plugin", "").toLowerCase(Locale.ENGLISH);
        if (baseName.getClass().getResource("/" + baseName + pluginExt + ".vm") != null) {
            return baseName + pluginExt + ".vm";
        }
        if (baseName.getClass().getResource("/" + baseName + ".vm") != null) {
            return baseName + ".vm";
        }
        return null;
    }

    public static String getQualifiedCertificateTypePropertyKey(SignatureValidationResult e) {
        String postfix;
        if (e == null) {
            return null;
        }
        PublicKeyCertificateValidationResult certResult = null;
        certResult = e instanceof PublicKeyCertificateValidationResult ? (PublicKeyCertificateValidationResult)e : (PublicKeyCertificateValidationResult)e.getSigningCertificateValidationResult();
        if (certResult == null) {
            return null;
        }
        CertificateQualificationInformation qualityInformation = certResult.getQualityInformation();
        if (qualityInformation == null) {
            return null;
        }
        CertificateQualification certificateQualification = qualityInformation.getCertificateQualification();
        EUQualifiedCertificateType type = qualityInformation.getCertificateType();
        if (type == null || certificateQualification == null) {
            return null;
        }
        switch (type) {
            case CERTIFICATE_FOR_ELECTRONIC_SIGNATURES: {
                postfix = "";
                break;
            }
            case CERTIFICATE_FOR_ELECTRONIC_SEALS: {
                postfix = "_SEAL";
                break;
            }
            case CERTIFICATE_FOR_WEBSITE_AUTHENTICATION: {
                postfix = "_WSA";
                break;
            }
            default: {
                postfix = "_UNKNOWN";
            }
        }
        return certificateQualification.getClass().getName() + "." + certificateQualification.name() + postfix;
    }

    public static String getMatchingCSSClass(String cssClasses, String regex, String defaultValue) {
        String[] cssClassArray;
        if (cssClasses == null) {
            return defaultValue;
        }
        for (String cssClass : cssClassArray = cssClasses.split(" ")) {
            if (!cssClass.trim().matches(regex)) continue;
            return cssClass.trim();
        }
        return defaultValue;
    }

    public static String getISO31662CountryCode(HTMLEscapingResourceBundle rb, String countryCode, String countryCodeKeyPrefix, String missingResourceKey, String nullValueKey) {
        if (countryCode != null) {
            String key = countryCodeKeyPrefix + countryCode.toUpperCase();
            try {
                return rb.getHTML(key);
            }
            catch (MissingResourceException mr_ex) {
                return rb.getHTML(missingResourceKey, countryCode);
            }
        }
        return rb.getHTML(nullValueKey);
    }

    public List<String> getMessages(ValidationResult result, HTMLEscapingResourceBundle rb, HTMLEscapingResourceBundle rbVal) {
        HashSet<MinorResult> minorResultSet;
        boolean hasValidationMessages;
        ArrayList<String> messageList = new ArrayList<String>();
        boolean bl = hasValidationMessages = result.getMessages() != null && !result.getMessages().isEmpty();
        if (result instanceof CumulatedValidationResult) {
            minorResultSet = ((CumulatedValidationResult)result).getMinorResults();
        } else {
            minorResultSet = new HashSet<MinorResult>();
            minorResultSet.add(result.getMinor());
        }
        for (MinorResult minorResult : minorResultSet) {
            if (minorResult == null || MinorResult.GENERIC.equals((Object)minorResult) && hasValidationMessages) continue;
            messageList.add(rb.getHTML("de.governikus.csl.uom.validate.commons.MinorResult." + minorResult.name()));
        }
        if (hasValidationMessages) {
            if (rbVal == null) {
                rbVal = rb;
            }
            for (de.governikus.csl.uom.validate.commons.ValidationMessageCode message : result.getMessages()) {
                messageList.add(HTMLEscapingResourceBundle.escapeHTML(HTMLEscapingResourceBundle.format((ResourceBundle)rbVal, message.getMessageCode(), message.getParameters().toArray())));
            }
        }
        return messageList;
    }

    public void addToList(List<Object> list, Object obj) {
        list.add(obj);
    }

    public boolean hasLineBreak(Object object) {
        if (object != null && object instanceof String) {
            return ((String)object).contains("\n");
        }
        return false;
    }

    public List<String> getValueList(String value) {
        return Arrays.asList(value.replaceAll("\r", "").split("\n"));
    }

    public static List<ValidationMessageCode> getQualityMessages(CertificateQualification certQual, ValidationMessageCode resultCode) {
        ArrayList<ValidationMessageCode> qmcList = new ArrayList<ValidationMessageCode>();
        if (certQual != null) {
            switch (certQual) {
                case QES_EUMS_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_QES_AES_QC_EUMS_TL"));
                    break;
                }
                case NO_QES_EUMS_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_QES_AES_QC_EUMS_TL"));
                    break;
                }
                case AES_QC_EUMS_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_QES_AES_QC_EUMS_TL"));
                    break;
                }
                case NO_AES_QC_EUMS_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_QES_AES_QC_EUMS_TL"));
                    break;
                }
                case AES_EUMS_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_AES_EUMS_TL"));
                    break;
                }
                case NO_AES_EUMS_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_AES_EUMS_TL"));
                    break;
                }
                case AES_GOV_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_AES_GOV_TL"));
                    break;
                }
                case AES_CUSTOM_TL: {
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_AES_CUSTOM_TL"));
                    break;
                }
                case ADS: {
                    if (resultCode != null && (resultCode.getMessageCode().equals("tl_invalid_signature") || resultCode.getMessageCode().equals("tl_expired"))) break;
                    qmcList.add(SVPFactory.createMessageCode((String)"quality_check_DS_NO_TL"));
                }
            }
        }
        if (resultCode != null) {
            qmcList.add(resultCode);
        }
        return qmcList;
    }

    public static Object getSignatureLevel(PreprocessedQualityInformation ppQI) {
        if (ppQI != null && ppQI.getQualifiedCertificateTypePropertyKey() != null) {
            return ppQI.getQualifiedCertificateTypePropertyKey();
        }
        return VelocityHelper.getIndeterminateResult();
    }

    public static Object getCertificateLevel(PreprocessedQualityInformation ppQI) {
        CertificateLevel level;
        de.governikus.csl.uom.validate.CertificateQualificationInformation qualityInformation;
        if (ppQI != null && (qualityInformation = ppQI.getQualityInformation()) != null && (level = qualityInformation.getCertificateLevel()) != null) {
            return level.getClass().getName() + "." + level;
        }
        return VelocityHelper.getIndeterminateResult();
    }

    public static PreprocessedInternalLink getInternalLink(String uid, String text) {
        return new PreprocessedInternalLink(uid, text);
    }

    public static PreprocessedInternalLink getInternalLink(String uid, Collection<?> collection) {
        return new PreprocessedInternalLink(uid, collection);
    }

    public abstract String escapeHTMLWrappableURL(Object var1);

    public boolean hasOnlySecureChanges(PAdESRevisionValidationResult revisionResult) {
        if (revisionResult == null) {
            return false;
        }
        Boolean onlySecureChanges = revisionResult.isLastHavingOnlySecureChanges();
        if (onlySecureChanges == null) {
            return false;
        }
        boolean alwaysShowOuterRevWarn = Boolean.parseBoolean(System.getProperty("gov.inspectionsheet.pdf.vuln.outer.rev.warn.always", "false"));
        if (alwaysShowOuterRevWarn) {
            return false;
        }
        return onlySecureChanges;
    }

    public String extractDigest(String url) {
        if (url != null && url.lastIndexOf(47) > -1 && url.lastIndexOf(47) < url.length() - 1) {
            return url.substring(url.lastIndexOf(47) + 1);
        }
        return null;
    }

    public static boolean hasOnlyErResults(PreprocessedValidationReport report) {
        return Plugin.PluginID.VALIDATE_ERS.getID().equals(report.getObjectTypeID()) || report.getSignatures().stream().allMatch(VelocityHelper::isErResult);
    }

    public static boolean isErResult(Object obj) {
        if (obj instanceof ERSValidationResult) {
            return true;
        }
        if (obj instanceof PreprocessedSignatureResult) {
            PreprocessedSignatureResult result = (PreprocessedSignatureResult)obj;
            return Plugin.PluginID.VALIDATE_ERS.getID().equals(result.getDocumentObjectTypeID());
        }
        return false;
    }

    public static boolean requireAsicErsAlgoNameMatch() {
        return !Boolean.getBoolean("de.governikus.csl.asic.ers.manifest.allow_algo_mismatch");
    }

    static {
        URL_PATTERN = Pattern.compile(REG_EXP_URL);
        QSCD_QUALIFIERS = Arrays.asList(QCWithSSCD, QCWithQSCD, QCQSCDManagedOnBehalf);
        ACQC = Quality.AC.name() + Quality.QC.name();
        isDevelopmentModeActive = System.getProperty("csl.disable.velocity.singleton") != null;
        parameterDisplayNames = new HashMap<String, String>();
        parameterDisplayNames.put("class", "c");
        parameterDisplayNames.put("digestAlgorithm", "da");
        parameterDisplayNames.put("elength", "e");
        parameterDisplayNames.put("mlength", "m");
        parameterDisplayNames.put("moduluslength", "n");
        parameterDisplayNames.put("plength", "p");
        parameterDisplayNames.put("qlength", "q");
        parameterDisplayNames.put("r0", "r");
        parameterDisplayNames.put("saltentropy", "se");
    }
}

